/*
 * Decompiled with CFR 0.152.
 */
package io.github.swagger2markup.extensions;

import io.github.swagger2markup.Swagger2MarkupConverter;
import io.github.swagger2markup.Swagger2MarkupProperties;
import io.github.swagger2markup.extensions.DynamicContentExtension;
import io.github.swagger2markup.markup.builder.MarkupLanguage;
import io.github.swagger2markup.model.PathOperation;
import io.github.swagger2markup.spi.ContentContext;
import io.github.swagger2markup.spi.PathsDocumentExtension;
import io.github.swagger2markup.utils.IOUtils;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DynamicPathsDocumentExtension
extends PathsDocumentExtension {
    private static final Logger logger = LoggerFactory.getLogger(DynamicPathsDocumentExtension.class);
    protected List<Path> contentPath;
    private static final String DEFAULT_EXTENSION_ID = "dynamicPaths";
    private static final String PROPERTY_CONTENT_PATH = "contentPath";
    private static final String PROPERTY_MARKUP_LANGUAGE = "markupLanguage";
    private String extensionId = "dynamicPaths";
    private MarkupLanguage extensionMarkupLanguage = MarkupLanguage.ASCIIDOC;

    public DynamicPathsDocumentExtension(List<Path> contentPath, MarkupLanguage extensionMarkupLanguage) {
        this(null, contentPath, extensionMarkupLanguage);
    }

    public DynamicPathsDocumentExtension(String extensionId, List<Path> contentPath, MarkupLanguage extensionMarkupLanguage) {
        Validate.notNull((Object)extensionMarkupLanguage);
        Validate.notNull(contentPath);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{extensionId})) {
            this.extensionId = extensionId;
        }
        this.contentPath = contentPath;
        this.extensionMarkupLanguage = extensionMarkupLanguage;
    }

    public DynamicPathsDocumentExtension() {
    }

    public void init(Swagger2MarkupConverter.Context globalContext) {
        Optional extensionMarkupLanguageProperty;
        Swagger2MarkupProperties extensionsProperties = globalContext.getConfig().getExtensionsProperties();
        this.contentPath = extensionsProperties.getPathList(this.extensionId + "." + PROPERTY_CONTENT_PATH);
        if (this.contentPath.isEmpty()) {
            if (globalContext.getSwaggerLocation() == null || !globalContext.getSwaggerLocation().getScheme().equals("file")) {
                if (logger.isWarnEnabled()) {
                    logger.warn("Disable DynamicOperationsContentExtension > Can't set default contentPath from swaggerLocation. You have to explicitly configure the content path.");
                }
            } else {
                this.contentPath.add(Paths.get(globalContext.getSwaggerLocation()).getParent());
            }
        }
        if ((extensionMarkupLanguageProperty = extensionsProperties.getMarkupLanguage(this.extensionId + "." + PROPERTY_MARKUP_LANGUAGE)).isPresent()) {
            this.extensionMarkupLanguage = (MarkupLanguage)extensionMarkupLanguageProperty.get();
        }
    }

    public void apply(PathsDocumentExtension.Context context) {
        Validate.notNull((Object)context);
        if (this.contentPath != null) {
            DynamicContentExtension dynamicContent = new DynamicContentExtension(this.globalContext, (ContentContext)context);
            PathsDocumentExtension.Position position = context.getPosition();
            switch (position) {
                case DOCUMENT_BEFORE: 
                case DOCUMENT_AFTER: 
                case DOCUMENT_BEGIN: 
                case DOCUMENT_END: {
                    dynamicContent.extensionsSection(this.extensionMarkupLanguage, this.contentPath, this.contentPrefix(position), this.levelOffset(context));
                    break;
                }
                case OPERATION_BEFORE: 
                case OPERATION_BEGIN: 
                case OPERATION_END: 
                case OPERATION_AFTER: 
                case OPERATION_DESCRIPTION_BEFORE: 
                case OPERATION_DESCRIPTION_AFTER: 
                case OPERATION_PARAMETERS_BEFORE: 
                case OPERATION_PARAMETERS_AFTER: 
                case OPERATION_RESPONSES_BEFORE: 
                case OPERATION_RESPONSES_AFTER: 
                case OPERATION_SECURITY_BEFORE: 
                case OPERATION_SECURITY_AFTER: 
                case OPERATION_DESCRIPTION_BEGIN: 
                case OPERATION_DESCRIPTION_END: 
                case OPERATION_PARAMETERS_BEGIN: 
                case OPERATION_PARAMETERS_END: 
                case OPERATION_RESPONSES_BEGIN: 
                case OPERATION_RESPONSES_END: 
                case OPERATION_SECURITY_BEGIN: 
                case OPERATION_SECURITY_END: {
                    List resolvedPaths = this.contentPath.stream().map(p -> p.resolve(IOUtils.normalizeName((String)((PathOperation)context.getOperation().get()).getId()))).collect(Collectors.toList());
                    dynamicContent.extensionsSection(this.extensionMarkupLanguage, resolvedPaths, this.contentPrefix(position), this.levelOffset(context));
                }
            }
        }
    }

    private String contentPrefix(PathsDocumentExtension.Position position) {
        return position.name().toLowerCase().replace('_', '-');
    }
}

