/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import java.io.Serializable;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Session;
import scala.Function1;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00153A!\u0003\u0006\u0003'!A!\u0004\u0001B\u0001B\u0003%1\u0004C\u0003#\u0001\u0011\u00051\u0005C\u0004(\u0001\t\u0007I\u0011\u0002\u0015\t\rQ\u0002\u0001\u0015!\u0003*\u0011\u001d)\u0004A1A\u0005\nYBa!\u0010\u0001!\u0002\u00139\u0004\"\u0002 \u0001\t\u0003y\u0004\"\u0002!\u0001\t\u0003\t%A\u0004&ngN+7o]5p]B{w\u000e\u001c\u0006\u0003\u00171\taa\u00197jK:$(BA\u0007\u000f\u0003\rQWn\u001d\u0006\u0003\u001fA\tqaZ1uY&twMC\u0001\u0012\u0003\tIwn\u0001\u0001\u0014\u0005\u0001!\u0002CA\u000b\u0019\u001b\u00051\"\"A\f\u0002\u000bM\u001c\u0017\r\\1\n\u0005e1\"AB!osJ+g-\u0001\u0006d_:tWm\u0019;j_:\u0004\"\u0001\b\u0011\u000e\u0003uQ!!\u0004\u0010\u000b\u0003}\tQA[1wCbL!!I\u000f\u0003\u0015\r{gN\\3di&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003I\u0019\u0002\"!\n\u0001\u000e\u0003)AQA\u0007\u0002A\u0002m\tQC]3hSN$XM]3e\u00156\u001c8+Z:tS>t7/F\u0001*!\rQs&M\u0007\u0002W)\u0011A&L\u0001\u0005kRLGNC\u0001/\u0003\u0011Q\u0017M^1\n\u0005AZ#aA*fiB\u0011ADM\u0005\u0003gu\u0011qaU3tg&|g.\u0001\fsK\u001eL7\u000f^3sK\u0012TUn]*fgNLwN\\:!\u0003-QWn]*fgNLwN\\:\u0016\u0003]\u00022\u0001O\u001e2\u001b\u0005I$B\u0001\u001e.\u0003\u0011a\u0017M\\4\n\u0005qJ$a\u0003+ie\u0016\fG\rT8dC2\fAB[7t'\u0016\u001c8/[8og\u0002\n!B[7t'\u0016\u001c8/[8o)\u0005\t\u0014!B2m_N,G#\u0001\"\u0011\u0005U\u0019\u0015B\u0001#\u0017\u0005\u0011)f.\u001b;")
public final class JmsSessionPool {
    private final Connection connection;
    private final Set<Session> registeredJmsSessions;
    private final ThreadLocal<Session> jmsSessions;

    private Set<Session> registeredJmsSessions() {
        return this.registeredJmsSessions;
    }

    private ThreadLocal<Session> jmsSessions() {
        return this.jmsSessions;
    }

    public Session jmsSession() {
        return this.jmsSessions().get();
    }

    public void close() {
        CollectionConverters$.MODULE$.SetHasAsScala(this.registeredJmsSessions()).asScala().foreach((Function1 & Serializable)x$1 -> {
            x$1.close();
            return BoxedUnit.UNIT;
        });
    }

    public JmsSessionPool(Connection connection) {
        this.connection = connection;
        this.registeredJmsSessions = Collections.newSetFromMap(new ConcurrentHashMap());
        this.jmsSessions = ThreadLocal.withInitial(() -> {
            Session s = $this.connection.createSession(false, 1);
            this.registeredJmsSessions().add(s);
            return s;
        });
    }
}

