/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.jms.client;

import io.gatling.commons.model.Credentials;
import io.gatling.commons.util.Clock;
import io.gatling.commons.validation.Validation;
import io.gatling.core.actor.ActorRef;
import io.gatling.core.actor.ActorSystem;
import io.gatling.core.config.GatlingConfiguration;
import io.gatling.core.session.package;
import io.gatling.core.session.package$;
import io.gatling.core.stats.StatsEngine;
import io.gatling.jms.client.JmsProducer;
import io.gatling.jms.client.JmsProducerPool;
import io.gatling.jms.client.JmsSessionPool;
import io.gatling.jms.client.JmsTracker;
import io.gatling.jms.client.JmsTrackerPool;
import io.gatling.jms.protocol.JmsMessageMatcher;
import io.gatling.jms.request.JmsDestination;
import io.gatling.jms.request.JmsDestination$TemporaryQueue$;
import io.gatling.jms.request.JmsDestination$TemporaryTopic$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005\u0005Mf\u0001B\f\u0019\u0005\u0005B\u0001\u0002\u000b\u0001\u0003\u0002\u0003\u0006I!\u000b\u0005\ta\u0001\u0011)\u0019!C\u0001c!AQ\b\u0001B\u0001B\u0003%!\u0007\u0003\u0005?\u0001\t\u0005\t\u0015!\u0003@\u0011!9\u0005A!A!\u0002\u0013A\u0005\u0002\u0003(\u0001\u0005\u0003\u0005\u000b\u0011B(\t\u0011U\u0003!\u0011!Q\u0001\nYCQ\u0001\u0018\u0001\u0005\u0002uCqA\u001a\u0001C\u0002\u0013%q\r\u0003\u0004l\u0001\u0001\u0006I\u0001\u001b\u0005\bY\u0002\u0011\r\u0011\"\u0003n\u0011\u001d\tY\u0001\u0001Q\u0001\n9D\u0001\"!\u0004\u0001\u0005\u0004%I!\u001c\u0005\b\u0003\u001f\u0001\u0001\u0015!\u0003o\u0011\u001d\t\t\u0002\u0001C\u0001\u0003'A\u0011\"a\u0012\u0001\u0005\u0004%I!!\u0013\t\u0011\u0005E\u0003\u0001)A\u0005\u0003\u0017Bq!a\u0015\u0001\t\u0003\t)\u0006C\u0005\u0002j\u0001\u0011\r\u0011\"\u0003\u0002l!A\u00111\u000f\u0001!\u0002\u0013\ti\u0007C\u0004\u0002v\u0001!\t!a\u001e\t\u000f\u0005%\u0006\u0001\"\u0001\u0002,\ni!*\\:D_:tWm\u0019;j_:T!!\u0007\u000e\u0002\r\rd\u0017.\u001a8u\u0015\tYB$A\u0002k[NT!!\b\u0010\u0002\u000f\u001d\fG\u000f\\5oO*\tq$\u0001\u0002j_\u000e\u00011C\u0001\u0001#!\t\u0019c%D\u0001%\u0015\u0005)\u0013!B:dC2\f\u0017BA\u0014%\u0005\u0019\te.\u001f*fM\u0006Q1m\u001c8oK\u000e$\u0018n\u001c8\u0011\u0005)rS\"A\u0016\u000b\u0005ma#\"A\u0017\u0002\u000b)\fg/\u0019=\n\u0005=Z#AC\"p]:,7\r^5p]\u0006Y1M]3eK:$\u0018.\u00197t+\u0005\u0011\u0004cA\u00124k%\u0011A\u0007\n\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YZT\"A\u001c\u000b\u0005aJ\u0014!B7pI\u0016d'B\u0001\u001e\u001d\u0003\u001d\u0019w.\\7p]NL!\u0001P\u001c\u0003\u0017\r\u0013X\rZ3oi&\fGn]\u0001\rGJ,G-\u001a8uS\u0006d7\u000fI\u0001\u0007gf\u001cH/Z7\u0011\u0005\u0001+U\"A!\u000b\u0005\t\u001b\u0015!B1di>\u0014(B\u0001#\u001d\u0003\u0011\u0019wN]3\n\u0005\u0019\u000b%aC!di>\u00148+_:uK6\f1b\u001d;biN,enZ5oKB\u0011\u0011\nT\u0007\u0002\u0015*\u00111jQ\u0001\u0006gR\fGo]\u0005\u0003\u001b*\u00131b\u0015;biN,enZ5oK\u0006)1\r\\8dWB\u0011\u0001kU\u0007\u0002#*\u0011!+O\u0001\u0005kRLG.\u0003\u0002U#\n)1\t\\8dW\u0006i1m\u001c8gS\u001e,(/\u0019;j_:\u0004\"a\u0016.\u000e\u0003aS!!W\"\u0002\r\r|gNZ5h\u0013\tY\u0006L\u0001\u000bHCRd\u0017N\\4D_:4\u0017nZ;sCRLwN\\\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000fy\u0003\u0017MY2eKB\u0011q\fA\u0007\u00021!)\u0001\u0006\u0003a\u0001S!)\u0001\u0007\u0003a\u0001e!)a\b\u0003a\u0001\u007f!)q\t\u0003a\u0001\u0011\")a\n\u0003a\u0001\u001f\")Q\u000b\u0003a\u0001-\u0006Y1/Z:tS>t\u0007k\\8m+\u0005A\u0007CA0j\u0013\tQ\u0007D\u0001\bK[N\u001cVm]:j_:\u0004vn\u001c7\u0002\u0019M,7o]5p]B{w\u000e\u001c\u0011\u0002\u0019M$\u0018\r^5d#V,W/Z:\u0016\u00039\u0004Ra\\;x\u0003\u000bi\u0011\u0001\u001d\u0006\u0003cJ\f!bY8oGV\u0014(/\u001a8u\u0015\t\u00116OC\u0001u\u0003\u0011Q\u0017M^1\n\u0005Y\u0004(!E\"p]\u000e,(O]3oi\"\u000b7\u000f['baB\u0011\u0001p \b\u0003sv\u0004\"A\u001f\u0013\u000e\u0003mT!\u0001 \u0011\u0002\rq\u0012xn\u001c;?\u0013\tqH%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u0003\t\u0019A\u0001\u0004TiJLgn\u001a\u0006\u0003}\u0012\u00022AKA\u0004\u0013\r\tIa\u000b\u0002\f\t\u0016\u001cH/\u001b8bi&|g.A\u0007ti\u0006$\u0018nY)vKV,7\u000fI\u0001\rgR\fG/[2U_BL7m]\u0001\u000egR\fG/[2U_BL7m\u001d\u0011\u0002\u0017\u0011,7\u000f^5oCRLwN\u001c\u000b\u0005\u0003+\t9\u0004\u0005\u0004\u0002\u0018\u0005E\u0012Q\u0001\b\u0005\u00033\tYC\u0004\u0003\u0002\u001c\u0005\u001db\u0002BA\u000f\u0003KqA!a\b\u0002$9\u0019!0!\t\n\u0003}I!!\b\u0010\n\u0005\u0011c\u0012bAA\u0015\u0007\u000691/Z:tS>t\u0017\u0002BA\u0017\u0003_\tq\u0001]1dW\u0006<WMC\u0002\u0002*\rKA!a\r\u00026\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u000b\t\u00055\u0012q\u0006\u0005\b\u0003sy\u0001\u0019AA\u001e\u00039QWn\u001d#fgRLg.\u0019;j_:\u0004B!!\u0010\u0002D5\u0011\u0011q\b\u0006\u0004\u0003\u0003R\u0012a\u0002:fcV,7\u000f^\u0005\u0005\u0003\u000b\nyD\u0001\bK[N$Um\u001d;j]\u0006$\u0018n\u001c8\u0002\u0019A\u0014x\u000eZ;dKJ\u0004vn\u001c7\u0016\u0005\u0005-\u0003cA0\u0002N%\u0019\u0011q\n\r\u0003\u001f)k7\u000f\u0015:pIV\u001cWM\u001d)p_2\fQ\u0002\u001d:pIV\u001cWM\u001d)p_2\u0004\u0013\u0001\u00039s_\u0012,8-\u001a:\u0015\r\u0005]\u0013QLA0!\ry\u0016\u0011L\u0005\u0004\u00037B\"a\u0003&ngB\u0013x\u000eZ;dKJDq!!\u0005\u0013\u0001\u0004\t)\u0001C\u0004\u0002bI\u0001\r!a\u0019\u0002\u0019\u0011,G.\u001b<feflu\u000eZ3\u0011\u0007\r\n)'C\u0002\u0002h\u0011\u00121!\u00138u\u0003-!(/Y2lKJ\u0004vn\u001c7\u0016\u0005\u00055\u0004cA0\u0002p%\u0019\u0011\u0011\u000f\r\u0003\u001d)k7\u000f\u0016:bG.,'\u000fU8pY\u0006aAO]1dW\u0016\u0014\bk\\8mA\u00059AO]1dW\u0016\u0014HCCA=\u0003\u001b\u000by)!&\u0002\u001aB)\u0001)a\u001f\u0002\u0000%\u0019\u0011QP!\u0003\u0011\u0005\u001bGo\u001c:SK\u001a\u0004B!!!\u0002\b:\u0019q,a!\n\u0007\u0005\u0015\u0005$\u0001\u0006K[N$&/Y2lKJLA!!#\u0002\f\n91i\\7nC:$'bAAC1!9\u0011\u0011C\u000bA\u0002\u0005\u0015\u0001bBAI+\u0001\u0007\u00111S\u0001\tg\u0016dWm\u0019;peB\u00191eM<\t\u000f\u0005]U\u00031\u0001\u0002d\u0005\u0019B.[:uK:,'\u000f\u00165sK\u0006$7i\\;oi\"9\u00111T\u000bA\u0002\u0005u\u0015AD7fgN\fw-Z'bi\u000eDWM\u001d\t\u0005\u0003?\u000b)+\u0004\u0002\u0002\"*\u0019\u00111\u0015\u000e\u0002\u0011A\u0014x\u000e^8d_2LA!a*\u0002\"\n\t\"*\\:NKN\u001c\u0018mZ3NCR\u001c\u0007.\u001a:\u0002\u000b\rdwn]3\u0015\u0005\u00055\u0006cA\u0012\u00020&\u0019\u0011\u0011\u0017\u0013\u0003\tUs\u0017\u000e\u001e")
public final class JmsConnection {
    private final Connection connection;
    private final Option<Credentials> credentials;
    private final JmsSessionPool sessionPool;
    private final ConcurrentHashMap<String, Destination> staticQueues;
    private final ConcurrentHashMap<String, Destination> staticTopics;
    private final JmsProducerPool producerPool;
    private final JmsTrackerPool trackerPool;

    public Option<Credentials> credentials() {
        return this.credentials;
    }

    private JmsSessionPool sessionPool() {
        return this.sessionPool;
    }

    private ConcurrentHashMap<String, Destination> staticQueues() {
        return this.staticQueues;
    }

    private ConcurrentHashMap<String, Destination> staticTopics() {
        return this.staticTopics;
    }

    public Function1<io.gatling.core.session.Session, Validation<Destination>> destination(JmsDestination jmsDestination) {
        Session jmsSession = this.sessionPool().jmsSession();
        JmsDestination jmsDestination2 = jmsDestination;
        if (JmsDestination$TemporaryQueue$.MODULE$.equals(jmsDestination2)) {
            return package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)jmsSession.createTemporaryQueue()));
        }
        if (JmsDestination$TemporaryTopic$.MODULE$.equals(jmsDestination2)) {
            return package.ExpressionSuccessWrapper$.MODULE$.expressionSuccess$extension(package$.MODULE$.ExpressionSuccessWrapper((Object)jmsSession.createTemporaryTopic()));
        }
        if (jmsDestination2 instanceof JmsDestination.Queue) {
            JmsDestination.Queue queue = (JmsDestination.Queue)jmsDestination2;
            Function1<io.gatling.core.session.Session, Validation<String>> name = queue.name();
            return package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(name), (Function1 & Serializable)n -> (Destination)this.staticQueues().computeIfAbsent((String)n, x$1 -> jmsSession.createQueue(x$1)));
        }
        if (jmsDestination2 instanceof JmsDestination.Topic) {
            JmsDestination.Topic topic = (JmsDestination.Topic)jmsDestination2;
            Function1<io.gatling.core.session.Session, Validation<String>> name = topic.name();
            return package.RichExpression$.MODULE$.map$extension(package$.MODULE$.RichExpression(name), (Function1 & Serializable)n -> (Destination)this.staticTopics().computeIfAbsent((String)n, x$1 -> jmsSession.createTopic(x$1)));
        }
        throw new MatchError((Object)jmsDestination2);
    }

    private JmsProducerPool producerPool() {
        return this.producerPool;
    }

    public JmsProducer producer(Destination destination, int deliveryMode) {
        return this.producerPool().producer(destination, deliveryMode);
    }

    private JmsTrackerPool trackerPool() {
        return this.trackerPool;
    }

    public ActorRef<JmsTracker.Command> tracker(Destination destination, Option<String> selector, int listenerThreadCount, JmsMessageMatcher messageMatcher) {
        return this.trackerPool().tracker(destination, selector, listenerThreadCount, messageMatcher);
    }

    public void close() {
        this.producerPool().close();
        this.sessionPool().close();
        this.connection.close();
    }

    public JmsConnection(Connection connection, Option<Credentials> credentials, ActorSystem system, StatsEngine statsEngine, Clock clock, GatlingConfiguration configuration) {
        this.connection = connection;
        this.credentials = credentials;
        this.sessionPool = new JmsSessionPool(connection);
        this.staticQueues = new ConcurrentHashMap();
        this.staticTopics = new ConcurrentHashMap();
        this.producerPool = new JmsProducerPool(this.sessionPool());
        this.trackerPool = new JmsTrackerPool(this.sessionPool(), system, statsEngine, clock, configuration);
    }
}

