/*
 * Decompiled with CFR 0.152.
 */
package io.gatling.http.util;

import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import io.gatling.commons.validation.Validation;
import io.gatling.core.session.Session;
import io.gatling.http.client.realm.BasicRealm;
import io.gatling.http.client.realm.DigestRealm;
import io.gatling.http.client.realm.Realm;
import io.gatling.http.client.uri.Uri;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpStatusClass;
import io.netty.handler.codec.http.cookie.ClientCookieDecoder;
import io.netty.handler.codec.http.cookie.Cookie;
import java.io.Serializable;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.IterableOnceOps;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

public final class HttpHelper$
implements StrictLogging {
    public static final HttpHelper$ MODULE$ = new HttpHelper$();
    private static final String HttpScheme;
    private static final String WsScheme;
    private static final Set<String> StandardApplicationTextMimeSubTypes;
    private static final Set<String> StandardApplicationTextExtensions;
    private static Logger logger;

    static {
        StrictLogging.$init$((StrictLogging)MODULE$);
        HttpScheme = "http";
        WsScheme = "ws";
        StandardApplicationTextMimeSubTypes = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"javascript", "json", "xml", "x-www-form-urlencoded", "x-javascript"}));
        StandardApplicationTextExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"+xml", "+json"}));
    }

    public Logger logger() {
        return logger;
    }

    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        logger = x$1;
    }

    private String HttpScheme() {
        return HttpScheme;
    }

    private String WsScheme() {
        return WsScheme;
    }

    public List<Tuple2<String, String>> parseFormBody(String body) {
        return (List)ArrayOps$.MODULE$.view$extension(Predef$.MODULE$.refArrayOps((Object[])body.split("&"))).map((Function1 & Serializable)x$1 -> x$1.split("=", 2)).map((Function1 & Serializable)pair -> {
            String paramName = URLDecoder.decode(pair[0], StandardCharsets.UTF_8);
            String paramValue = ((String[])pair).length > 1 ? URLDecoder.decode(pair[1], StandardCharsets.UTF_8) : "";
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)paramName), (Object)paramValue);
        }).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.List()));
    }

    public Function1<Session, Validation<Realm>> buildBasicAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return (Function1 & Serializable)session -> ((Validation)username.apply(session)).flatMap((Function1 & Serializable)usernameValue -> ((Validation)password.apply(session)).map((Function1 & Serializable)passwordValue -> new BasicRealm(usernameValue, passwordValue)));
    }

    public Function1<Session, Validation<Realm>> buildDigestAuthRealm(Function1<Session, Validation<String>> username, Function1<Session, Validation<String>> password) {
        return (Function1 & Serializable)session -> ((Validation)username.apply(session)).flatMap((Function1 & Serializable)usernameValue -> ((Validation)password.apply(session)).map((Function1 & Serializable)passwordValue -> new DigestRealm(usernameValue, passwordValue)));
    }

    private Option<String> mimeType(HttpHeaders headers) {
        return Option$.MODULE$.apply((Object)headers.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)).map((Function1 & Serializable)contentType -> {
            int comma = contentType.indexOf(59);
            if (comma == -1) {
                return contentType;
            }
            return contentType.substring(0, comma).trim();
        });
    }

    private Set<String> StandardApplicationTextMimeSubTypes() {
        return StandardApplicationTextMimeSubTypes;
    }

    private Set<String> StandardApplicationTextExtensions() {
        return StandardApplicationTextExtensions;
    }

    public boolean isText(HttpHeaders headers) {
        return this.mimeType(headers).exists((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.$anonfun$isText$1(headers, x0$1)));
    }

    private boolean isText(String mt) {
        Option option;
        String string = mt;
        if (string != null && !(option = new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"application/", ""})).s().unapplySeq(string)).isEmpty() && option.get() != null && ((SeqOps)option.get()).lengthCompare(1) == 0) {
            String subType = (String)((SeqOps)option.get()).apply(0);
            return this.StandardApplicationTextMimeSubTypes().contains((Object)subType) || this.StandardApplicationTextExtensions().exists((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)subType.endsWith(x$1)));
        }
        return string.startsWith("text/");
    }

    public boolean isCss(HttpHeaders headers) {
        return this.mimeType(headers).contains((Object)HttpHeaderValues.TEXT_CSS.toString());
    }

    public boolean isHtml(HttpHeaders headers) {
        return this.mimeType(headers).exists((Function1 & Serializable)mt -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.$anonfun$isHtml$1(mt)));
    }

    public boolean isAjax(HttpHeaders headers) {
        return headers.contains((CharSequence)HttpHeaderNames.X_REQUESTED_WITH, (CharSequence)HttpHeaderValues.XML_HTTP_REQUEST.toString(), false);
    }

    public Uri resolveFromUri(Uri rootURI, String relative) {
        if (relative.startsWith("//")) {
            return Uri.create((String)(rootURI.getScheme() + ":" + relative));
        }
        return Uri.create((Uri)rootURI, (String)relative);
    }

    public Option<Uri> resolveFromUriSilently(Uri rootURI, String relative) {
        Some some;
        try {
            some = new Some((Object)this.resolveFromUri(rootURI, relative));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Failed to resolve URI rootURI='" + rootURI + "', relative='" + relative + "'", throwable2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                some = None$.MODULE$;
            }
            throw throwable;
        }
        return some;
    }

    public boolean isOk(int statusCode) {
        HttpStatusClass httpStatusClass = HttpStatusClass.valueOf((int)statusCode);
        HttpStatusClass httpStatusClass2 = HttpStatusClass.SUCCESS;
        return !(httpStatusClass == null ? httpStatusClass2 != null : !httpStatusClass.equals(httpStatusClass2)) || statusCode == HttpResponseStatus.NOT_MODIFIED.code();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRedirect(HttpResponseStatus status) {
        HttpStatusClass httpStatusClass = HttpStatusClass.valueOf((int)status.code());
        HttpStatusClass httpStatusClass2 = HttpStatusClass.REDIRECTION;
        if (httpStatusClass == null) {
            if (httpStatusClass2 != null) {
                return false;
            }
        } else if (!httpStatusClass.equals(httpStatusClass2)) return false;
        HttpResponseStatus httpResponseStatus = status;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.NOT_MODIFIED;
        if (httpResponseStatus == null) {
            if (httpResponseStatus2 == null) return false;
            return true;
        } else if (httpResponseStatus.equals(httpResponseStatus2)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isPermanentRedirect(HttpResponseStatus status) {
        HttpResponseStatus httpResponseStatus = status;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.MOVED_PERMANENTLY;
        if (httpResponseStatus == null) {
            if (httpResponseStatus2 == null) return true;
        } else if (httpResponseStatus.equals(httpResponseStatus2)) return true;
        HttpResponseStatus httpResponseStatus3 = status;
        HttpResponseStatus httpResponseStatus4 = HttpResponseStatus.PERMANENT_REDIRECT;
        if (httpResponseStatus3 != null) {
            if (!httpResponseStatus3.equals(httpResponseStatus4)) return false;
            return true;
        }
        if (httpResponseStatus4 == null) return true;
        return false;
    }

    public boolean isNotModified(HttpResponseStatus status) {
        HttpResponseStatus httpResponseStatus = status;
        HttpResponseStatus httpResponseStatus2 = HttpResponseStatus.NOT_MODIFIED;
        return !(httpResponseStatus != null ? !httpResponseStatus.equals(httpResponseStatus2) : httpResponseStatus2 != null);
    }

    public boolean isAbsoluteHttpUrl(String url) {
        return url.startsWith(this.HttpScheme());
    }

    public boolean isAbsoluteWsUrl(String url) {
        return url.startsWith(this.WsScheme());
    }

    public boolean isMultipartFormData(String contentType) {
        return contentType != null && contentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString());
    }

    public Option<Charset> extractCharsetFromContentType(String contentType) {
        Option option;
        try {
            option = this.extractAttributeFromContentType(contentType, "charset=").map((Function1 & Serializable)x$1 -> Charset.forName(x$1));
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable throwable3 = throwable;
            if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Failed to extract charset from Content-Type='" + contentType + "'", throwable2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                option = None$.MODULE$;
            }
            throw throwable;
        }
        return option;
    }

    private Option<String> extractAttributeFromContentType(String contentType, String attributeNameAndEqualChar) {
        String charsetString;
        int n;
        int n2 = contentType.indexOf(attributeNameAndEqualChar);
        switch (n2) {
            case -1: {
                return None$.MODULE$;
            }
        }
        int start = n2 + attributeNameAndEqualChar.length();
        if (contentType.regionMatches(true, start, StandardCharsets.UTF_8.name(), 0, 5)) {
            return new Some((Object)StandardCharsets.UTF_8.name());
        }
        int n3 = contentType.indexOf(59, start);
        switch (n3) {
            case -1: {
                n = contentType.length();
                break;
            }
            default: {
                n = n3;
                break;
            }
        }
        int end = n;
        while (start < end && contentType.charAt(start) == ' ') {
            ++start;
        }
        while (end > start && contentType.charAt(end - 1) == ' ') {
            --end;
        }
        if (start < end && contentType.charAt(start) == '\"') {
            ++start;
        }
        if (end > start && contentType.charAt(end - 1) == '\"') {
            --end;
        }
        if ((charsetString = contentType.substring(start, end)).isEmpty()) {
            return None$.MODULE$;
        }
        return new Some((Object)charsetString);
    }

    public List<Cookie> responseCookies(HttpHeaders headers) {
        java.util.List setCookieValues = headers.getAll((CharSequence)HttpHeaderNames.SET_COOKIE);
        if (setCookieValues.isEmpty()) {
            return Nil$.MODULE$;
        }
        return ((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(setCookieValues).asScala().view().flatMap((Function1 & Serializable)setCookie -> Option$.MODULE$.apply((Object)ClientCookieDecoder.LAX.decode(setCookie)).toList())).toList();
    }

    public static final /* synthetic */ boolean $anonfun$isText$1(HttpHeaders headers$1, String x0$1) {
        String string = x0$1;
        switch (string == null ? 0 : string.hashCode()) {
            case -1741069880: {
                if (!"multipart/related".equals(string)) break;
                return Option$.MODULE$.apply((Object)headers$1.get((CharSequence)HttpHeaderNames.CONTENT_TYPE)).flatMap((Function1 & Serializable)x$2 -> MODULE$.extractAttributeFromContentType((String)x$2, "type=")).exists((Function1 & Serializable)mt -> BoxesRunTime.boxToBoolean((boolean)HttpHelper$.MODULE$.isText(mt)));
            }
        }
        return MODULE$.isText(string);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final /* synthetic */ boolean $anonfun$isHtml$1(String mt) {
        String string = mt;
        String string2 = HttpHeaderValues.TEXT_HTML.toString();
        if (string == null) {
            if (string2 == null) return true;
        } else if (string.equals(string2)) return true;
        String string3 = mt;
        String string4 = HttpHeaderValues.APPLICATION_XHTML.toString();
        if (string3 != null) {
            if (!string3.equals(string4)) return false;
            return true;
        }
        if (string4 == null) return true;
        return false;
    }

    private HttpHelper$() {
    }
}

