/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.machine.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPDisk;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPEncryptionKeyReference;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPEncryptionKeyReferenceBuilder;
import io.fabric8.openshift.api.model.machine.v1beta1.GCPEncryptionKeyReferenceFluent;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class GCPDiskFluent<A extends GCPDiskFluent<A>>
extends BaseFluent<A> {
    private Boolean autoDelete;
    private Boolean boot;
    private GCPEncryptionKeyReferenceBuilder encryptionKey;
    private String image;
    private Map<String, String> labels;
    private Long sizeGb;
    private String type;
    private Map<String, Object> additionalProperties;

    public GCPDiskFluent() {
    }

    public GCPDiskFluent(GCPDisk instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(GCPDisk instance) {
        GCPDisk gCPDisk = instance = instance != null ? instance : new GCPDisk();
        if (instance != null) {
            this.withAutoDelete(instance.getAutoDelete());
            this.withBoot(instance.getBoot());
            this.withEncryptionKey(instance.getEncryptionKey());
            this.withImage(instance.getImage());
            this.withLabels(instance.getLabels());
            this.withSizeGb(instance.getSizeGb());
            this.withType(instance.getType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public Boolean getAutoDelete() {
        return this.autoDelete;
    }

    public A withAutoDelete(Boolean autoDelete) {
        this.autoDelete = autoDelete;
        return (A)((Object)this);
    }

    public boolean hasAutoDelete() {
        return this.autoDelete != null;
    }

    public Boolean getBoot() {
        return this.boot;
    }

    public A withBoot(Boolean boot) {
        this.boot = boot;
        return (A)((Object)this);
    }

    public boolean hasBoot() {
        return this.boot != null;
    }

    public GCPEncryptionKeyReference buildEncryptionKey() {
        return this.encryptionKey != null ? this.encryptionKey.build() : null;
    }

    public A withEncryptionKey(GCPEncryptionKeyReference encryptionKey) {
        this._visitables.remove((Object)"encryptionKey");
        if (encryptionKey != null) {
            this.encryptionKey = new GCPEncryptionKeyReferenceBuilder(encryptionKey);
            this._visitables.get((Object)"encryptionKey").add(this.encryptionKey);
        } else {
            this.encryptionKey = null;
            this._visitables.get((Object)"encryptionKey").remove((Object)this.encryptionKey);
        }
        return (A)((Object)this);
    }

    public boolean hasEncryptionKey() {
        return this.encryptionKey != null;
    }

    public EncryptionKeyNested<A> withNewEncryptionKey() {
        return new EncryptionKeyNested(null);
    }

    public EncryptionKeyNested<A> withNewEncryptionKeyLike(GCPEncryptionKeyReference item) {
        return new EncryptionKeyNested(item);
    }

    public EncryptionKeyNested<A> editEncryptionKey() {
        return this.withNewEncryptionKeyLike(Optional.ofNullable(this.buildEncryptionKey()).orElse(null));
    }

    public EncryptionKeyNested<A> editOrNewEncryptionKey() {
        return this.withNewEncryptionKeyLike(Optional.ofNullable(this.buildEncryptionKey()).orElse(new GCPEncryptionKeyReferenceBuilder().build()));
    }

    public EncryptionKeyNested<A> editOrNewEncryptionKeyLike(GCPEncryptionKeyReference item) {
        return this.withNewEncryptionKeyLike(Optional.ofNullable(this.buildEncryptionKey()).orElse(item));
    }

    public String getImage() {
        return this.image;
    }

    public A withImage(String image) {
        this.image = image;
        return (A)((Object)this);
    }

    public boolean hasImage() {
        return this.image != null;
    }

    public A addToLabels(String key, String value) {
        if (this.labels == null && key != null && value != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (key != null && value != null) {
            this.labels.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToLabels(Map<String, String> map) {
        if (this.labels == null && map != null) {
            this.labels = new LinkedHashMap<String, String>();
        }
        if (map != null) {
            this.labels.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(String key) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (key != null && this.labels != null) {
            this.labels.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromLabels(Map<String, String> map) {
        if (this.labels == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.labels == null) continue;
                this.labels.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, String> getLabels() {
        return this.labels;
    }

    public <K, V> A withLabels(Map<String, String> labels) {
        this.labels = labels == null ? null : new LinkedHashMap<String, String>(labels);
        return (A)((Object)this);
    }

    public boolean hasLabels() {
        return this.labels != null;
    }

    public Long getSizeGb() {
        return this.sizeGb;
    }

    public A withSizeGb(Long sizeGb) {
        this.sizeGb = sizeGb;
        return (A)((Object)this);
    }

    public boolean hasSizeGb() {
        return this.sizeGb != null;
    }

    public String getType() {
        return this.type;
    }

    public A withType(String type) {
        this.type = type;
        return (A)((Object)this);
    }

    public boolean hasType() {
        return this.type != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        GCPDiskFluent that = (GCPDiskFluent)((Object)o);
        if (!Objects.equals(this.autoDelete, that.autoDelete)) {
            return false;
        }
        if (!Objects.equals(this.boot, that.boot)) {
            return false;
        }
        if (!Objects.equals((Object)this.encryptionKey, (Object)that.encryptionKey)) {
            return false;
        }
        if (!Objects.equals(this.image, that.image)) {
            return false;
        }
        if (!Objects.equals(this.labels, that.labels)) {
            return false;
        }
        if (!Objects.equals(this.sizeGb, that.sizeGb)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.autoDelete, this.boot, this.encryptionKey, this.image, this.labels, this.sizeGb, this.type, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.autoDelete != null) {
            sb.append("autoDelete:");
            sb.append(this.autoDelete + ",");
        }
        if (this.boot != null) {
            sb.append("boot:");
            sb.append(this.boot + ",");
        }
        if (this.encryptionKey != null) {
            sb.append("encryptionKey:");
            sb.append(String.valueOf((Object)this.encryptionKey) + ",");
        }
        if (this.image != null) {
            sb.append("image:");
            sb.append(this.image + ",");
        }
        if (this.labels != null && !this.labels.isEmpty()) {
            sb.append("labels:");
            sb.append(String.valueOf(this.labels) + ",");
        }
        if (this.sizeGb != null) {
            sb.append("sizeGb:");
            sb.append(this.sizeGb + ",");
        }
        if (this.type != null) {
            sb.append("type:");
            sb.append(this.type + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public A withAutoDelete() {
        return this.withAutoDelete(true);
    }

    public A withBoot() {
        return this.withBoot(true);
    }

    public class EncryptionKeyNested<N>
    extends GCPEncryptionKeyReferenceFluent<EncryptionKeyNested<N>>
    implements Nested<N> {
        GCPEncryptionKeyReferenceBuilder builder;

        EncryptionKeyNested(GCPEncryptionKeyReference item) {
            this.builder = new GCPEncryptionKeyReferenceBuilder(this, item);
        }

        public N and() {
            return (N)GCPDiskFluent.this.withEncryptionKey(this.builder.build());
        }

        public N endEncryptionKey() {
            return this.and();
        }
    }
}

