/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model.hive.ovirt.v1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.openshift.api.model.hive.ovirt.v1.CPU;
import io.fabric8.openshift.api.model.hive.ovirt.v1.CPUBuilder;
import io.fabric8.openshift.api.model.hive.ovirt.v1.CPUFluent;
import io.fabric8.openshift.api.model.hive.ovirt.v1.Disk;
import io.fabric8.openshift.api.model.hive.ovirt.v1.DiskBuilder;
import io.fabric8.openshift.api.model.hive.ovirt.v1.DiskFluent;
import io.fabric8.openshift.api.model.hive.ovirt.v1.MachinePool;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class MachinePoolFluent<A extends MachinePoolFluent<A>>
extends BaseFluent<A> {
    private CPUBuilder cpu;
    private Integer memoryMB;
    private DiskBuilder osDisk;
    private String vmType;
    private Map<String, Object> additionalProperties;

    public MachinePoolFluent() {
    }

    public MachinePoolFluent(MachinePool instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(MachinePool instance) {
        MachinePool machinePool = instance = instance != null ? instance : new MachinePool();
        if (instance != null) {
            this.withCpu(instance.getCpu());
            this.withMemoryMB(instance.getMemoryMB());
            this.withOsDisk(instance.getOsDisk());
            this.withVmType(instance.getVmType());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public CPU buildCpu() {
        return this.cpu != null ? this.cpu.build() : null;
    }

    public A withCpu(CPU cpu) {
        this._visitables.remove((Object)"cpu");
        if (cpu != null) {
            this.cpu = new CPUBuilder(cpu);
            this._visitables.get((Object)"cpu").add(this.cpu);
        } else {
            this.cpu = null;
            this._visitables.get((Object)"cpu").remove((Object)this.cpu);
        }
        return (A)((Object)this);
    }

    public boolean hasCpu() {
        return this.cpu != null;
    }

    public A withNewCpu(Integer cores, Integer sockets) {
        return this.withCpu(new CPU(cores, sockets));
    }

    public CpuNested<A> withNewCpu() {
        return new CpuNested(null);
    }

    public CpuNested<A> withNewCpuLike(CPU item) {
        return new CpuNested(item);
    }

    public CpuNested<A> editCpu() {
        return this.withNewCpuLike(Optional.ofNullable(this.buildCpu()).orElse(null));
    }

    public CpuNested<A> editOrNewCpu() {
        return this.withNewCpuLike(Optional.ofNullable(this.buildCpu()).orElse(new CPUBuilder().build()));
    }

    public CpuNested<A> editOrNewCpuLike(CPU item) {
        return this.withNewCpuLike(Optional.ofNullable(this.buildCpu()).orElse(item));
    }

    public Integer getMemoryMB() {
        return this.memoryMB;
    }

    public A withMemoryMB(Integer memoryMB) {
        this.memoryMB = memoryMB;
        return (A)((Object)this);
    }

    public boolean hasMemoryMB() {
        return this.memoryMB != null;
    }

    public Disk buildOsDisk() {
        return this.osDisk != null ? this.osDisk.build() : null;
    }

    public A withOsDisk(Disk osDisk) {
        this._visitables.remove((Object)"osDisk");
        if (osDisk != null) {
            this.osDisk = new DiskBuilder(osDisk);
            this._visitables.get((Object)"osDisk").add(this.osDisk);
        } else {
            this.osDisk = null;
            this._visitables.get((Object)"osDisk").remove((Object)this.osDisk);
        }
        return (A)((Object)this);
    }

    public boolean hasOsDisk() {
        return this.osDisk != null;
    }

    public A withNewOsDisk(Long sizeGB) {
        return this.withOsDisk(new Disk(sizeGB));
    }

    public OsDiskNested<A> withNewOsDisk() {
        return new OsDiskNested(null);
    }

    public OsDiskNested<A> withNewOsDiskLike(Disk item) {
        return new OsDiskNested(item);
    }

    public OsDiskNested<A> editOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(null));
    }

    public OsDiskNested<A> editOrNewOsDisk() {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(new DiskBuilder().build()));
    }

    public OsDiskNested<A> editOrNewOsDiskLike(Disk item) {
        return this.withNewOsDiskLike(Optional.ofNullable(this.buildOsDisk()).orElse(item));
    }

    public String getVmType() {
        return this.vmType;
    }

    public A withVmType(String vmType) {
        this.vmType = vmType;
        return (A)((Object)this);
    }

    public boolean hasVmType() {
        return this.vmType != null;
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MachinePoolFluent that = (MachinePoolFluent)((Object)o);
        if (!Objects.equals((Object)this.cpu, (Object)that.cpu)) {
            return false;
        }
        if (!Objects.equals(this.memoryMB, that.memoryMB)) {
            return false;
        }
        if (!Objects.equals((Object)this.osDisk, (Object)that.osDisk)) {
            return false;
        }
        if (!Objects.equals(this.vmType, that.vmType)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cpu, this.memoryMB, this.osDisk, this.vmType, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.cpu != null) {
            sb.append("cpu:");
            sb.append(String.valueOf((Object)this.cpu) + ",");
        }
        if (this.memoryMB != null) {
            sb.append("memoryMB:");
            sb.append(this.memoryMB + ",");
        }
        if (this.osDisk != null) {
            sb.append("osDisk:");
            sb.append(String.valueOf((Object)this.osDisk) + ",");
        }
        if (this.vmType != null) {
            sb.append("vmType:");
            sb.append(this.vmType + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class OsDiskNested<N>
    extends DiskFluent<OsDiskNested<N>>
    implements Nested<N> {
        DiskBuilder builder;

        OsDiskNested(Disk item) {
            this.builder = new DiskBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolFluent.this.withOsDisk(this.builder.build());
        }

        public N endOsDisk() {
            return this.and();
        }
    }

    public class CpuNested<N>
    extends CPUFluent<CpuNested<N>>
    implements Nested<N> {
        CPUBuilder builder;

        CpuNested(CPU item) {
            this.builder = new CPUBuilder(this, item);
        }

        public N and() {
            return (N)MachinePoolFluent.this.withCpu(this.builder.build());
        }

        public N endCpu() {
            return this.and();
        }
    }
}

