/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.progressbar;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.component.progressbar.ProgressBar;
import com.vaadin.flow.component.progressbar.ProgressBarVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.function.SerializableSupplier;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentHasSize;
import org.vaadin.firitin.fluency.ui.FluentHasStyle;

public class VProgressBar
extends ProgressBar
implements FluentComponent<VProgressBar>,
FluentHasSize<VProgressBar>,
FluentHasStyle<VProgressBar> {
    private boolean prepareForOverdueInAnimation = true;

    public VProgressBar() {
    }

    public VProgressBar(double min, double max) {
        super(min, max);
    }

    public VProgressBar(double min, double max, double value) {
        super(min, max, value);
    }

    public static VProgressBar indeterminateForTask(Runnable task) {
        VProgressBar progressBar = new VProgressBar();
        progressBar.setIndeterminate(true);
        progressBar.addAttachListener((ComponentEventListener & Serializable)attachEvent -> {
            Page page = attachEvent.getUI().getPage();
            page.executeJs("document.querySelector('vaadin-connection-indicator').style.display = 'none';", new Object[0]).then((SerializableConsumer & Serializable)v -> {
                task.run();
                progressBar.removeFromParent();
                page.executeJs("document.querySelector('vaadin-connection-indicator').style.display = '';", new Object[0]);
            });
        });
        return progressBar;
    }

    public static VProgressBar indeterminateForTask(SerializableSupplier<Component> task) {
        VProgressBar progressBar = new VProgressBar();
        progressBar.setIndeterminate(true);
        progressBar.addAttachListener((ComponentEventListener & Serializable)attachEvent -> {
            Page page = attachEvent.getUI().getPage();
            page.executeJs("document.querySelector('vaadin-connection-indicator').style.display = 'none';", new Object[0]).then((SerializableConsumer & Serializable)v -> {
                Component component = (Component)task.get();
                Optional parent = progressBar.getParent();
                Element parentElement = progressBar.getElement().getParent();
                int index = parentElement.indexOfChild(progressBar.getElement());
                parentElement.insertChild(index, new Element[]{component.getElement()});
                progressBar.removeFromParent();
                page.executeJs("document.querySelector('vaadin-connection-indicator').style.display = '';", new Object[0]);
            });
        });
        return progressBar;
    }

    public VProgressBar withValue(double value) {
        this.setValue(value);
        return this;
    }

    public VProgressBar withMax(double max) {
        this.setMax(max);
        return this;
    }

    public VProgressBar withMin(double min) {
        this.setMin(min);
        return this;
    }

    public VProgressBar withThemeVariants(ProgressBarVariant ... variants) {
        this.addThemeVariants((ThemeVariant[])variants);
        return this;
    }

    public void animateToEstimate(LocalDateTime startOfProgress, LocalDateTime estimatedEndOfProgress) {
        double max = startOfProgress.until(estimatedEndOfProgress, ChronoUnit.MILLIS);
        double now = startOfProgress.until(LocalDateTime.now(), ChronoUnit.MILLIS);
        this.setMin(0.0);
        this.setMax(max);
        if (now > max) {
            this.setValue(max);
        } else {
            this.setValue(now);
        }
        this.animateToEstimate();
    }

    public void animateToEstimate() {
        this.getElement().executeJs("  const progressBar = this;\n  const estimatedDuration = $0;\n  const beginning = progressBar.value;\n  const start = new Date().getTime();\n  const prepareForOverdueInAnimation = $1;\n  const step = () => {\n    if(progressBar.finished) {\n      console.log(\"Stopped animation as already finished\");\n      return;\n    }\n    var elapsed = beginning + new Date().getTime() - start;\n    if(prepareForOverdueInAnimation) {\n        // slow down the animation when it's almost done to play some time if estimate is passed\n        if(elapsed > estimatedDuration * 0.8) {\n          // TODO make this somehow smoother\n          elapsed = estimatedDuration * 0.8 + (elapsed - estimatedDuration * 0.8) * 0.2;\n        }\n    }\n\n    if(elapsed >= estimatedDuration) {\n        // if still over estimate, stop animation and switch to indeterminate mode\n        progressBar.indeterminate = true;\n    } else {\n        progressBar.value = elapsed;\n    }\n    if(document.body.contains(progressBar) && !progressBar.hidden) {\n        requestAnimationFrame(step);\n    }\n  }\n  requestAnimationFrame(step);\n", new Object[]{this.getMax(), this.prepareForOverdueInAnimation});
    }

    public void finish() {
        this.getElement().executeJs("this.finished = true; this.indeterminate = false;", new Object[0]);
        this.setValue(this.getMax());
    }

    public boolean isPrepareForOverdueInAnimation() {
        return this.prepareForOverdueInAnimation;
    }

    public VProgressBar setPrepareForOverdueInAnimation(boolean prepareForOverdueInAnimation) {
        this.prepareForOverdueInAnimation = prepareForOverdueInAnimation;
        return this;
    }
}

