/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.web.dispatcher;

import fr.opensagres.xdocreport.core.XDocReportException;
import fr.opensagres.xdocreport.core.utils.StringUtils;
import fr.opensagres.xdocreport.document.IXDocReport;
import fr.opensagres.xdocreport.document.dispatcher.IXDocReportDispatcher;
import fr.opensagres.xdocreport.document.web.AbstractProcessXDocReportServlet;
import fr.opensagres.xdocreport.document.web.dispatcher.IXDocReportWEBController;
import fr.opensagres.xdocreport.template.IContext;
import fr.opensagres.xdocreport.template.formatter.FieldsMetadata;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;

public class ProcessDispatcherXDocReportServlet
extends AbstractProcessXDocReportServlet {
    private static final long serialVersionUID = -1568586154827821538L;
    protected final List<IXDocReportDispatcher<?>> dispatchers = new ArrayList();

    @Override
    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        String dispatchers = config.getInitParameter("dispatchers");
        if (StringUtils.isNotEmpty((String)dispatchers)) {
            String clazz = null;
            String[] classes = dispatchers.split(",");
            for (int i = 0; i < classes.length; ++i) {
                clazz = classes[i];
                try {
                    Object instance = this.getClass().getClassLoader().loadClass(clazz).newInstance();
                    this.registerDispatcher((IXDocReportDispatcher)instance);
                    continue;
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public void registerDispatcher(IXDocReportDispatcher<?> dispatcher) {
        this.dispatchers.add(dispatcher);
    }

    public void unregisterDispatcher(IXDocReportDispatcher<?> dispatcher) {
        this.dispatchers.remove(dispatcher);
    }

    @Override
    protected InputStream getSourceStream(String reportId, HttpServletRequest request) throws IOException, XDocReportException {
        for (IXDocReportDispatcher<?> dispatcher : this.dispatchers) {
            InputStream in = dispatcher.getSourceStream(reportId);
            if (in == null) continue;
            return in;
        }
        return null;
    }

    @Override
    protected String getTemplateEngineKind(HttpServletRequest request) {
        for (IXDocReportDispatcher<?> dispatcher : this.dispatchers) {
            String templateEngineId = dispatcher.getTemplateEngineKind(this.getReportId(request));
            if (!StringUtils.isNotEmpty((String)templateEngineId)) continue;
            return templateEngineId;
        }
        return super.getTemplateEngineKind(request);
    }

    @Override
    protected FieldsMetadata getFieldsMetadata(String reportId, HttpServletRequest request) {
        for (IXDocReportDispatcher<?> dispatcher : this.dispatchers) {
            FieldsMetadata fieldsMetadata = dispatcher.getFieldsMetadata(reportId);
            if (fieldsMetadata == null) continue;
            return fieldsMetadata;
        }
        return super.getFieldsMetadata(reportId, request);
    }

    @Override
    protected boolean isCacheReport(String reportId, HttpServletRequest request) {
        for (IXDocReportDispatcher<?> dispatcher : this.dispatchers) {
            Boolean cacheReport = dispatcher.isCacheReport(reportId);
            if (cacheReport == null) continue;
            return cacheReport;
        }
        return super.isCacheReport(reportId, request);
    }

    @Override
    protected void populateContext(IContext context, String reportId, HttpServletRequest request) throws IOException, XDocReportException {
        IXDocReport report = super.getRegistry(request).getReport(reportId);
        if (report != null) {
            this.populateContext(context, report, request);
        }
    }

    protected void populateContext(IContext context, IXDocReport report, HttpServletRequest request) {
        String reportId = report.getId();
        for (IXDocReportDispatcher<?> dispatcher : this.dispatchers) {
            IXDocReportWEBController controler = (IXDocReportWEBController)dispatcher.getReportController(reportId);
            if (controler == null) continue;
            controler.populateContext(context, report, request);
        }
    }
}

