/*
 * Decompiled with CFR 0.152.
 */
package fr.ird.observe.application.web.security;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import fr.ird.observe.services.configuration.ObserveDataSourceConfigurationAndConnection;
import java.io.Closeable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ObserveWebSecurityAuthenticationTokenCache
implements Closeable {
    private static final Log log = LogFactory.getLog(ObserveWebSecurityAuthenticationTokenCache.class);
    protected final Cache<String, ObserveDataSourceConfigurationAndConnection> authenticationTokenCache;

    public ObserveWebSecurityAuthenticationTokenCache(int maximumSize, int expireDelay) {
        this.authenticationTokenCache = CacheBuilder.newBuilder().maximumSize((long)maximumSize).expireAfterWrite((long)expireDelay, TimeUnit.MINUTES).expireAfterAccess((long)expireDelay, TimeUnit.MINUTES).removalListener(notification -> {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Remove authentication token: %s - %s", notification.getKey(), notification.getValue()));
            }
        }).build();
    }

    public ObserveDataSourceConfigurationAndConnection getDataSourceConfigurationAndConnectionIfPresent(String authenticationToken) {
        return (ObserveDataSourceConfigurationAndConnection)this.authenticationTokenCache.getIfPresent((Object)authenticationToken);
    }

    public String registerDataSourceConfiguration(ObserveDataSourceConfigurationAndConnection configurationAndConnection) {
        String authenticationToken = UUID.randomUUID().toString();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Add authenticationToken: %s for data source configuration: %s", authenticationToken, configurationAndConnection.getConfiguration()));
        }
        this.authenticationTokenCache.put((Object)authenticationToken, (Object)configurationAndConnection);
        return authenticationToken;
    }

    public void removeAuthenticationToken(String authenticationToken) {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Remove authenticationToken: %s ", authenticationToken));
        }
        this.authenticationTokenCache.invalidate((Object)authenticationToken);
    }

    public void removeAllAuthenticationTokens() {
        if (log.isInfoEnabled()) {
            log.info((Object)"Remove all authenticationTokens");
        }
        this.authenticationTokenCache.invalidateAll();
    }

    public Cache<String, ObserveDataSourceConfigurationAndConnection> getAuthenticationTokenCache() {
        return this.authenticationTokenCache;
    }

    @Override
    public void close() {
        this.removeAllAuthenticationTokens();
    }
}

