/*
 * #%L
 * Refcomp :: services
 * 
 * $Id: WikittyInraLDAP.java 263 2012-02-09 13:10:48Z jcouteau $
 * $HeadURL: svn+ssh://jcouteau@scm.mulcyber.toulouse.inra.fr/svnroot/refcomp/tags/refcomp-1.7/refcomp-services/src/main/java/fr/inra/refcomp/services/WikittyInraLDAP.java $
 * %%
 * Copyright (C) 2010 - 2012 Inra
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * #L%
 */
package fr.inra.refcomp.services;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyTokenHelper;
import org.nuiton.wikitty.entities.WikittyUser;
import org.nuiton.wikitty.query.WikittyQuery;
import org.nuiton.wikitty.query.WikittyQueryMaker;
import org.nuiton.wikitty.services.WikittyServiceAuthenticationAbstract;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

import javax.naming.AuthenticationException;
import javax.naming.Context;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

/**
 * Permet de faire une authentification sur un serveur LDAP. Il faut pour cela
 * fournir les informations pour se connecter au LDAP (url du serveur, pattern
 * des DN des utilisateurs et toutes autres informations utiles).
 *
 * Il est possible d'indiquer de creer automatiquement l'objet WikittyUser
 * associe au compte LDAP si celui-ci n'existe pas. Si le WikittyUser n'existe
 * pas et qu'on a pas le droit de le creer, l'authentification echoue forcement
 *
 * @author poussin
 * @version $Revision: 263 $
 *
 * Last update: $Date: 2012-02-09 14:10:48 +0100 (jeu., 09 févr. 2012) $
 * by : $Author: jcouteau $
 */
public class WikittyInraLDAP extends WikittyServiceAuthenticationAbstract {

    /** to use log facility, just put in your code: log.info(\"...\"); */
    static private Log log = LogFactory.getLog(WikittyInraLDAP.class);
    public static final String UID = "uid";

    protected Properties jndiProp;
    protected String ldapSearch;
    protected String adminLogin;
    protected String adminPassword;

    /*public WikittyInraLDAP(WikittyService ws) {
        this(null,ws);
        log.debug("Init LDAP without conf");
    }*/

    public WikittyInraLDAP(ApplicationConfig config, WikittyService ws) {
        super(config, ws);

        log.debug("Initializing LDAP connexion");

        // on charge toutes les options jndi
        Properties jndiPropTmp = config.getOptionStartsWith(WikittyConfigOption
                .WIKITTY_SECURITY_EXTERNAL_AUTHENTICATION_LDAP_JNDI.getKey());

        jndiProp = new Properties();
        for (Enumeration<String> e=(Enumeration<String>)jndiPropTmp.propertyNames(); e.hasMoreElements();) {
            String key = e.nextElement();
            String value = jndiPropTmp.getProperty(key);
            int debut = WikittyConfigOption.WIKITTY_SECURITY_EXTERNAL_AUTHENTICATION_LDAP_JNDI.getKey().length();
            key = key.substring(debut);
            jndiProp.setProperty(key, value);
        }

        // on charge l'url du serveur ldap
        String serverUrl = config.getOption(
                WikittyConfigOption.WIKITTY_SECURITY_EXTERNAL_AUTHENTICATION_LDAP_SERVER.getKey());
        jndiProp.put(Context.PROVIDER_URL, serverUrl);

        // on charge le pattern des recherches
        ldapSearch = config.getOption(
                WikittyConfigOption.WIKITTY_SECURITY_EXTERNAL_AUTHENTICATION_LDAP_LOGIN_PATTERN.getKey());

        // on charge le pattern des recherches
        adminLogin = ServiceFactory.getConfig().getAdminLogin();
        adminPassword = ServiceFactory.getConfig().getAdminPassword();
        
        log.debug("LDAP connexion initialized");
    }

    @Override
    public String login(String login, String password) {

        Wikitty user;
        String tokenId = null;

        WikittyQuery criteria = new WikittyQueryMaker()
                .eq(WikittyUser.FQ_FIELD_WIKITTYUSER_LOGIN, login).end();
        String userId = getDelegate().findByQuery(null,
                Collections.singletonList(criteria)).get(0);

        boolean authenticated = false;

        // si l'utilisateur existe deja ou qu'on pourra le creer alors on va
        // plus loin dans l'authentification
        if (userId != null) {

            //if admin authenticate without going to ldap
            if(adminLogin.equals(login) && adminPassword.equals(password)) {
                authenticated = true;
            }

            if (!authenticated) {


                //la requête du dn
                String userDn = null;

                // on fait une copie pour etre thread safe (si plusieurs thread appelent
                // cette methode en meme temps
                Hashtable<String, String> env = new Hashtable(jndiProp);

                //Connexion anonyme pour récupérer le dn
                try {
                    DirContext dirContext = new InitialDirContext(env);

                    String searchQuery = UID +"="+login;

                    // Search for objects that have those matching attributes
                    SearchControls controls = new SearchControls();
                    controls.setSearchScope(SearchControls.SUBTREE_SCOPE);
                    NamingEnumeration answer =
                            dirContext.search(ldapSearch, searchQuery, controls);

                    while (answer.hasMore()) {
                        SearchResult sr = (SearchResult)answer.next();
                        userDn = sr.getName();
                    }

                    // Close the context when we're done
                    dirContext.close();

                } catch (NamingException eee) {
                    log.debug(String.format(
                            "Erreur lors de l'acces anonyme au serveur LDAP pour " +
                                    "la recherche de l'utilisateur %s -> %s",
                            login, ldapSearch), eee);
                }


                //Vérification avec le dn récupéré lors de la première requête
                if (userDn != null) {
                    env.put(Context.SECURITY_PRINCIPAL, userDn + "," + ldapSearch);
                    env.put(Context.SECURITY_CREDENTIALS, password);

                    try {
                        DirContext dirContext = new InitialDirContext(env);
                        dirContext.close();
                        authenticated = true;
                    } catch (AuthenticationException eee) {
                        throw new SecurityException("wrong password for user : " + login);
                    } catch (NamingException eee) {
                        log.debug(String.format(
                                "Erreur lors de l'acces au serveur LDAP pour l'utilisateur %s -> %s",
                                login, userDn), eee);
                        throw new SecurityException("Error accessing LDAP server",eee);
                    }
                } else {
                    throw new SecurityException("wrong login");
                }

            }

            log.info(String.format(
                    "External authentication success for account '%s'", login));
            // authentification reussie
            user = WikittyServiceEnhanced.restore(
                    getDelegate(), null, userId);
            if (user != null) {
                tokenId = getToken(user);
            } else if (adminLogin.equals(login) && adminPassword.equals(password)){
                // generation d'un nouveau token
                tokenId = WikittyUtil.genSecurityTokenId();
                Wikitty wikittyToken = new WikittyImpl(tokenId);
                // force add extension to wikitty
                WikittyTokenHelper.addExtension(wikittyToken);
                //WikittyTokenHelper.setUser(wikittyToken, user.getId());
                WikittyTokenHelper.setDate(wikittyToken, new Date());
                getDelegate().store(null, Arrays.asList(wikittyToken), false);
            } else {
                throw new SecurityException("This user does not exist in Refcomp");
            }

        } else {
            throw new SecurityException("wrong login or password");
        }

        return tokenId;
    }


}
