/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.requestfactory;

import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.handler.component.ResponseBuilder;
import org.apache.solr.handler.component.ShardRequest;
import org.apache.solr.search.grouping.GroupingSpecification;
import org.apache.solr.search.grouping.distributed.ShardRequestFactory;

public class SearchGroupsRequestFactory
implements ShardRequestFactory {
    public ShardRequest[] constructRequest(ResponseBuilder rb) {
        ShardRequest sreq = new ShardRequest();
        GroupingSpecification groupingSpecification = rb.getGroupingSpec();
        if (groupingSpecification.getFields().length == 0) {
            return new ShardRequest[0];
        }
        sreq.purpose = 2048;
        sreq.params = new ModifiableSolrParams(rb.req.getParams());
        sreq.params.remove("shards");
        if (rb.shards_start > -1) {
            sreq.params.set("start", rb.shards_start);
        } else {
            sreq.params.set("start", new String[]{"0"});
        }
        if (rb.shards_rows > -1) {
            sreq.params.set("rows", rb.shards_rows);
        } else {
            sreq.params.set("rows", rb.getSortSpec().getOffset() + rb.getSortSpec().getCount());
        }
        sreq.params.set("group.distibuted.first", new String[]{"true"});
        if ((rb.getFieldFlags() & 1) != 0 || rb.getSortSpec().includesScore()) {
            sreq.params.set("fl", new String[]{rb.req.getSchema().getUniqueKeyField().getName() + ",score"});
        } else {
            sreq.params.set("fl", new String[]{rb.req.getSchema().getUniqueKeyField().getName()});
        }
        return new ShardRequest[]{sreq};
    }
}

