/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.core;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.util.DOMUtil;
import org.apache.solr.common.util.FileUtils;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.Config;
import org.apache.solr.core.CoreDescriptor;
import org.apache.solr.core.SolrConfig;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.admin.CoreAdminHandler;
import org.apache.solr.schema.IndexSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CoreContainer {
    private static final String DEFAULT_DEFAULT_CORE_NAME = "collection1";
    protected static Logger log = LoggerFactory.getLogger(CoreContainer.class);
    protected final Map<String, SolrCore> cores = new LinkedHashMap<String, SolrCore>();
    protected boolean persistent = false;
    protected String adminPath = null;
    protected String managementPath = null;
    protected CoreAdminHandler coreAdminHandler = null;
    protected File configFile = null;
    protected String libDir = null;
    protected ClassLoader libLoader = null;
    protected SolrResourceLoader loader = null;
    protected Properties containerProperties;
    protected Map<String, IndexSchema> indexSchemaCache;
    protected String adminHandler;
    protected boolean shareSchema;
    protected String solrHome;
    protected String solrConfigFilenameOverride;
    private String defaultCoreName = "";
    private boolean defaultAbortOnConfigError = false;
    private int numCoresAbortOnConfigError = 0;
    private boolean isShutDown = false;
    private static final String DEF_SOLR_XML = "<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n<solr persistent=\"false\">\n  <cores adminPath=\"/admin/cores\" defaultCoreName=\"collection1\">\n    <core name=\"collection1\" instanceDir=\".\" />\n  </cores>\n</solr>";

    public CoreContainer() {
        this.solrHome = SolrResourceLoader.locateSolrHome();
        log.info("New CoreContainer: solrHome=" + this.solrHome + " instance=" + System.identityHashCode(this));
    }

    public Properties getContainerProperties() {
        return this.containerProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Properties getCoreProps(String instanceDir, String file, Properties defaults) {
        File corePropsFile;
        if (file == null) {
            file = "conf" + File.separator + "solrcore.properties";
        }
        if (!(corePropsFile = new File(file)).isAbsolute()) {
            corePropsFile = new File(instanceDir, file);
        }
        Properties p = defaults;
        if (corePropsFile.exists() && corePropsFile.isFile()) {
            p = new Properties(defaults);
            FileInputStream is = null;
            try {
                is = new FileInputStream(corePropsFile);
                p.load(is);
            }
            catch (IOException e) {
                try {
                    log.warn("Error loading properties ", (Throwable)e);
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(is);
                    throw throwable;
                }
                IOUtils.closeQuietly((InputStream)is);
            }
            IOUtils.closeQuietly((InputStream)is);
        }
        return p;
    }

    public CoreContainer(String dir, File configFile) throws ParserConfigurationException, IOException, SAXException {
        this.load(dir, configFile);
    }

    public CoreContainer(SolrResourceLoader loader) {
        this.loader = loader;
        this.solrHome = loader.getInstanceDir();
    }

    public CoreContainer(String solrHome) {
        this.solrHome = solrHome;
    }

    public void load(String dir, File configFile) throws ParserConfigurationException, IOException, SAXException {
        this.configFile = configFile;
        this.load(dir, new InputSource(configFile.toURI().toASCIIString()));
    }

    public void load(String dir, InputSource cfgis) throws ParserConfigurationException, IOException, SAXException {
        String name;
        this.loader = new SolrResourceLoader(dir);
        this.solrHome = this.loader.getInstanceDir();
        Config cfg = new Config(this.loader, null, cfgis, null);
        String dcoreName = cfg.get("solr/cores/@defaultCoreName", null);
        if (dcoreName != null) {
            this.defaultCoreName = dcoreName;
        }
        this.persistent = cfg.getBool("solr/@persistent", false);
        this.libDir = cfg.get("solr/@sharedLib", null);
        this.adminPath = cfg.get("solr/cores/@adminPath", null);
        this.shareSchema = cfg.getBool("solr/cores/@shareSchema", false);
        if (this.shareSchema) {
            this.indexSchemaCache = new ConcurrentHashMap<String, IndexSchema>();
        }
        this.adminHandler = cfg.get("solr/cores/@adminHandler", null);
        this.managementPath = cfg.get("solr/cores/@managementPath", null);
        if (this.libDir != null) {
            File f = FileUtils.resolvePath((File)new File(dir), (String)this.libDir);
            log.info("loading shared library: " + f.getAbsolutePath());
            this.libLoader = SolrResourceLoader.createClassLoader(f, null);
        }
        if (this.adminPath != null) {
            this.coreAdminHandler = this.adminHandler == null ? new CoreAdminHandler(this) : this.createMultiCoreHandler(this.adminHandler);
        }
        try {
            this.containerProperties = this.readProperties(cfg, ((NodeList)cfg.evaluate("solr", XPathConstants.NODESET)).item(0));
        }
        catch (Throwable e) {
            SolrConfig.severeErrors.add(e);
            SolrException.logOnce((Logger)log, null, (Throwable)e);
        }
        NodeList nodes = (NodeList)cfg.evaluate("solr/cores/core/@name", XPathConstants.NODESET);
        HashSet<String> names = new HashSet<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            name = DOMUtil.getText((Node)nodes.item(i));
            if (names.contains(name)) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Multiple cores found with same name: " + name);
            }
            names.add(name);
        }
        nodes = (NodeList)cfg.evaluate("solr/cores/core", XPathConstants.NODESET);
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            try {
                name = DOMUtil.getAttr((Node)node, (String)"name", null);
                if (null == name) {
                    throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Each core in solr.xml must have a 'name'");
                }
                if (name.equals(this.defaultCoreName)) {
                    name = "";
                }
                CoreDescriptor p = new CoreDescriptor(this, name, DOMUtil.getAttr((Node)node, (String)"instanceDir", null));
                String opt = DOMUtil.getAttr((Node)node, (String)"config", null);
                if (this.solrConfigFilenameOverride != null && name.equals("")) {
                    p.setConfigName(this.solrConfigFilenameOverride);
                } else if (opt != null) {
                    p.setConfigName(opt);
                }
                opt = DOMUtil.getAttr((Node)node, (String)"schema", null);
                if (opt != null) {
                    p.setSchemaName(opt);
                }
                if ((opt = DOMUtil.getAttr((Node)node, (String)"properties", null)) != null) {
                    p.setPropertiesName(opt);
                }
                if ((opt = DOMUtil.getAttr((Node)node, (String)"dataDir", null)) != null) {
                    p.setDataDir(opt);
                }
                p.setCoreProperties(this.readProperties(cfg, node));
                SolrCore core = this.create(p);
                this.register(name, core, false);
                continue;
            }
            catch (Throwable ex) {
                SolrConfig.severeErrors.add(ex);
                SolrException.logOnce((Logger)log, null, (Throwable)ex);
            }
        }
    }

    private Properties readProperties(Config cfg, Node node) throws XPathExpressionException {
        XPath xpath = cfg.getXPath();
        NodeList props = (NodeList)xpath.evaluate("property", node, XPathConstants.NODESET);
        Properties properties = new Properties();
        for (int i = 0; i < props.getLength(); ++i) {
            Node prop = props.item(i);
            properties.setProperty(DOMUtil.getAttr((Node)prop, (String)"name"), DOMUtil.getAttr((Node)prop, (String)"value"));
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            try {
                for (SolrCore core : this.cores.values()) {
                    core.close();
                }
                this.cores.clear();
            }
            finally {
                this.isShutDown = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isShutDown) {
                log.error("CoreContainer was not shutdown prior to finalize(), indicates a bug -- POSSIBLE RESOURCE LEAK!!!  instance=" + System.identityHashCode(this));
                this.shutdown();
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore register(String name, SolrCore core, boolean returnPrevNotClosed) {
        if (core == null) {
            throw new RuntimeException("Can not register a null core.");
        }
        if (name == null || name.indexOf(47) >= 0 || name.indexOf(92) >= 0) {
            throw new RuntimeException("Invalid core name: " + name);
        }
        SolrCore old = null;
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            old = this.cores.put(name, core);
            core.setName(name);
            core.getCoreDescriptor().name = name;
        }
        if (old == null || old == core) {
            log.info("registering core: " + name);
            return null;
        }
        log.info("replacing core: " + name);
        if (!returnPrevNotClosed) {
            old.close();
        }
        return old;
    }

    public SolrCore register(SolrCore core, boolean returnPrev) {
        return this.register(core.getName(), core, returnPrev);
    }

    public SolrCore create(CoreDescriptor dcore) throws ParserConfigurationException, IOException, SAXException {
        String instanceDir;
        SolrResourceLoader solrLoader;
        SolrConfig config;
        File idir = new File(dcore.getInstanceDir());
        if (!idir.isAbsolute()) {
            idir = new File(this.solrHome, dcore.getInstanceDir());
        }
        if ((config = new SolrConfig(solrLoader = new SolrResourceLoader(instanceDir = idir.getPath(), this.libLoader, CoreContainer.getCoreProps(instanceDir, dcore.getPropertiesName(), dcore.getCoreProperties())), dcore.getConfigName(), null)).getBool("abortOnConfigurationError", this.defaultAbortOnConfigError)) {
            ++this.numCoresAbortOnConfigError;
        }
        IndexSchema schema = null;
        if (this.indexSchemaCache != null) {
            File schemaFile = new File(dcore.getSchemaName());
            if (!schemaFile.isAbsolute()) {
                schemaFile = new File(solrLoader.getInstanceDir() + "conf" + File.separator + dcore.getSchemaName());
            }
            if (schemaFile.exists()) {
                String key = schemaFile.getAbsolutePath() + ":" + new SimpleDateFormat("yyyyMMddHHmmss", Locale.US).format(new Date(schemaFile.lastModified()));
                schema = this.indexSchemaCache.get(key);
                if (schema == null) {
                    log.info("creating new schema object for core: " + dcore.name);
                    schema = new IndexSchema(config, dcore.getSchemaName(), null);
                    this.indexSchemaCache.put(key, schema);
                } else {
                    log.info("re-using schema object for core: " + dcore.name);
                }
            }
        }
        if (schema == null) {
            schema = new IndexSchema(config, dcore.getSchemaName(), null);
        }
        SolrCore core = new SolrCore(dcore.getName(), null, config, schema, dcore);
        return core;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<SolrCore> getCores() {
        ArrayList<SolrCore> lst = new ArrayList<SolrCore>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            lst.addAll(this.cores.values());
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCoreNames() {
        ArrayList<String> lst = new ArrayList<String>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            lst.addAll(this.cores.keySet());
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<String> getCoreNames(SolrCore core) {
        ArrayList<String> lst = new ArrayList<String>();
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            for (Map.Entry<String, SolrCore> entry : this.cores.entrySet()) {
                if (core != entry.getValue()) continue;
                lst.add(entry.getKey());
            }
        }
        return lst;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload(String name) throws ParserConfigurationException, IOException, SAXException {
        SolrCore core;
        name = this.checkDefault(name);
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            core = this.cores.get(name);
        }
        if (core == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + name);
        }
        SolrCore newCore = this.create(core.getCoreDescriptor());
        this.register(name, newCore, false);
    }

    private String checkDefault(String name) {
        return name.length() == 0 || this.defaultCoreName.equals(name) || name.trim().length() == 0 ? "" : name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swap(String n0, String n1) {
        if (n0 == null || n1 == null) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Can not swap unnamed cores.");
        }
        n0 = this.checkDefault(n0);
        n1 = this.checkDefault(n1);
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            SolrCore c0 = this.cores.get(n0);
            SolrCore c1 = this.cores.get(n1);
            if (c0 == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n0);
            }
            if (c1 == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "No such core: " + n1);
            }
            this.cores.put(n0, c1);
            this.cores.put(n1, c0);
            c0.setName(n1);
            c0.getCoreDescriptor().name = n1;
            c1.setName(n0);
            c1.getCoreDescriptor().name = n0;
        }
        log.info("swaped: " + n0 + " with " + n1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore remove(String name) {
        name = this.checkDefault(name);
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            return this.cores.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SolrCore getCore(String name) {
        name = this.checkDefault(name);
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            SolrCore core = this.cores.get(name);
            if (core != null) {
                core.open();
            }
            return core;
        }
    }

    protected CoreAdminHandler createMultiCoreHandler(String adminHandlerClass) {
        SolrResourceLoader loader = new SolrResourceLoader(null, this.libLoader, null);
        Object obj = loader.newAdminHandlerInstance(this, adminHandlerClass, new String[0]);
        if (!(obj instanceof CoreAdminHandler)) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "adminHandlerClass is not of type " + CoreAdminHandler.class);
        }
        return (CoreAdminHandler)obj;
    }

    public CoreAdminHandler getMultiCoreHandler() {
        return this.coreAdminHandler;
    }

    public String getDefaultCoreName() {
        return this.defaultCoreName;
    }

    public boolean isPersistent() {
        return this.persistent;
    }

    public void setPersistent(boolean persistent) {
        this.persistent = persistent;
    }

    public String getAdminPath() {
        return this.adminPath;
    }

    public void setAdminPath(String adminPath) {
        this.adminPath = adminPath;
    }

    public String getManagementPath() {
        return this.managementPath;
    }

    public void setManagementPath(String path) {
        this.managementPath = path;
    }

    public File getConfigFile() {
        return this.configFile;
    }

    public void persist() {
        this.persistFile(null);
    }

    public void persistFile(File file) {
        log.info("Persisting cores config to " + (file == null ? this.configFile : file));
        File tmpFile = null;
        try {
            if (file == null) {
                file = tmpFile = File.createTempFile("solr", ".xml", this.configFile.getParentFile());
            }
            FileOutputStream out = new FileOutputStream(file);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            this.persist(writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
            out.close();
            if (tmpFile != null) {
                if (tmpFile.renameTo(this.configFile)) {
                    tmpFile = null;
                } else {
                    CoreContainer.fileCopy(tmpFile, this.configFile);
                }
            }
        }
        catch (FileNotFoundException xnf) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)xnf);
        }
        catch (IOException xio) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)xio);
        }
        finally {
            if (tmpFile != null && !tmpFile.delete()) {
                tmpFile.deleteOnExit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persist(Writer w) throws IOException {
        w.write("<?xml version=\"1.0\" encoding=\"UTF-8\" ?>\n");
        w.write("<solr");
        if (this.libDir != null) {
            this.writeAttribute(w, "sharedLib", this.libDir);
        }
        this.writeAttribute(w, "persistent", this.isPersistent());
        w.write(">\n");
        if (this.containerProperties != null && !this.containerProperties.isEmpty()) {
            this.writeProperties(w, this.containerProperties, "  ");
        }
        w.write("  <cores");
        this.writeAttribute(w, "adminPath", this.adminPath);
        if (this.adminHandler != null) {
            this.writeAttribute(w, "adminHandler", this.adminHandler);
        }
        if (this.shareSchema) {
            this.writeAttribute(w, "shareSchema", "true");
        }
        if (!this.defaultCoreName.equals("")) {
            this.writeAttribute(w, "defaultCoreName", this.defaultCoreName);
        }
        w.write(">\n");
        Map<String, SolrCore> map = this.cores;
        synchronized (map) {
            for (SolrCore solrCore : this.cores.values()) {
                this.persist(w, solrCore.getCoreDescriptor());
            }
        }
        w.write("  </cores>\n");
        w.write("</solr>\n");
    }

    private void writeAttribute(Writer w, String name, Object value) throws IOException {
        if (value == null) {
            return;
        }
        w.write(" ");
        w.write(name);
        w.write("=\"");
        XML.escapeAttributeValue((String)value.toString(), (Writer)w);
        w.write("\"");
    }

    void persist(Writer w, CoreDescriptor dcore) throws IOException {
        w.write("    <core");
        this.writeAttribute(w, "name", dcore.name.equals("") ? this.defaultCoreName : dcore.name);
        this.writeAttribute(w, "instanceDir", dcore.getInstanceDir());
        String opt = dcore.getConfigName();
        if (opt != null && !opt.equals(dcore.getDefaultConfigName())) {
            this.writeAttribute(w, "config", opt);
        }
        if ((opt = dcore.getSchemaName()) != null && !opt.equals(dcore.getDefaultSchemaName())) {
            this.writeAttribute(w, "schema", opt);
        }
        if ((opt = dcore.getPropertiesName()) != null) {
            this.writeAttribute(w, "properties", opt);
        }
        if ((opt = dcore.dataDir) != null) {
            this.writeAttribute(w, "dataDir", opt);
        }
        if (dcore.getCoreProperties() == null || dcore.getCoreProperties().isEmpty()) {
            w.write("/>\n");
        } else {
            w.write(">\n");
            this.writeProperties(w, dcore.getCoreProperties(), "      ");
            w.write("    </core>\n");
        }
    }

    private void writeProperties(Writer w, Properties props, String indent) throws IOException {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            w.write(indent + "<property");
            this.writeAttribute(w, "name", entry.getKey());
            this.writeAttribute(w, "value", entry.getValue());
            w.write("/>\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void fileCopy(File src, File dest) throws IOException {
        IOException xforward;
        block39: {
            IOException xio222222;
            AbstractInterruptibleChannel fcout;
            AbstractInterruptibleChannel fcin;
            FileOutputStream fos;
            FileInputStream fis;
            block33: {
                xforward = null;
                fis = null;
                fos = null;
                fcin = null;
                fcout = null;
                fis = new FileInputStream(src);
                fos = new FileOutputStream(dest);
                fcin = fis.getChannel();
                fcout = fos.getChannel();
                int MB32 = 0x2000000;
                long size = ((FileChannel)fcin).size();
                for (long position = 0L; position < size; position += ((FileChannel)fcin).transferTo(position, 0x2000000L, (WritableByteChannel)((Object)fcout))) {
                }
                Object var13_11 = null;
                if (fis == null) break block33;
                try {
                    fis.close();
                    fis = null;
                }
                catch (IOException xio222222) {
                    // empty catch block
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                    fos = null;
                }
                catch (IOException xio222222) {
                    // empty catch block
                }
            }
            if (fcin != null && fcin.isOpen()) {
                try {
                    fcin.close();
                    fcin = null;
                }
                catch (IOException xio222222) {
                    // empty catch block
                }
            }
            if (fcout != null && fcout.isOpen()) {
                try {
                    fcout.close();
                    fcout = null;
                }
                catch (IOException xio222222) {}
            }
            break block39;
            {
                catch (IOException xio3) {
                    IOException xio222222;
                    xforward = xio3;
                    Object var13_12 = null;
                    if (fis != null) {
                        try {
                            fis.close();
                            fis = null;
                        }
                        catch (IOException xio222222) {
                            // empty catch block
                        }
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                            fos = null;
                        }
                        catch (IOException xio222222) {
                            // empty catch block
                        }
                    }
                    if (fcin != null && fcin.isOpen()) {
                        try {
                            fcin.close();
                            fcin = null;
                        }
                        catch (IOException xio222222) {
                            // empty catch block
                        }
                    }
                    if (fcout != null && fcout.isOpen()) {
                        try {
                            fcout.close();
                            fcout = null;
                        }
                        catch (IOException xio222222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException xio222222;
                Object var13_13 = null;
                if (fis != null) {
                    try {
                        fis.close();
                        fis = null;
                    }
                    catch (IOException xio222222) {
                        // empty catch block
                    }
                }
                if (fos != null) {
                    try {
                        fos.close();
                        fos = null;
                    }
                    catch (IOException xio222222) {
                        // empty catch block
                    }
                }
                if (fcin != null && fcin.isOpen()) {
                    try {
                        fcin.close();
                        fcin = null;
                    }
                    catch (IOException xio222222) {
                        // empty catch block
                    }
                }
                if (fcout != null && fcout.isOpen()) {
                    try {
                        fcout.close();
                        fcout = null;
                    }
                    catch (IOException xio222222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        if (xforward != null) {
            throw xforward;
        }
    }

    public String getSolrHome() {
        return this.solrHome;
    }

    public static class Initializer {
        protected String solrConfigFilename = null;
        protected boolean abortOnConfigurationError = true;

        public boolean isAbortOnConfigurationError() {
            return this.abortOnConfigurationError;
        }

        public void setAbortOnConfigurationError(boolean abortOnConfigurationError) {
            this.abortOnConfigurationError = abortOnConfigurationError;
        }

        public String getSolrConfigFilename() {
            return this.solrConfigFilename;
        }

        @Deprecated
        public void setSolrConfigFilename(String solrConfigFilename) {
            this.solrConfigFilename = solrConfigFilename;
        }

        public CoreContainer initialize() throws IOException, ParserConfigurationException, SAXException {
            CoreContainer cores = null;
            String solrHome = SolrResourceLoader.locateSolrHome();
            File fconf = new File(solrHome, this.solrConfigFilename == null ? "solr.xml" : this.solrConfigFilename);
            log.info("looking for solr.xml: " + fconf.getAbsolutePath());
            cores = new CoreContainer();
            cores.solrConfigFilenameOverride = this.solrConfigFilename;
            if (fconf.exists()) {
                cores.defaultAbortOnConfigError = false;
                cores.load(solrHome, fconf);
            } else {
                cores.defaultAbortOnConfigError = this.abortOnConfigurationError;
                cores.load(solrHome, new InputSource(new ByteArrayInputStream(CoreContainer.DEF_SOLR_XML.getBytes("UTF-8"))));
                cores.configFile = fconf;
            }
            this.setAbortOnConfigurationError(0 < cores.numCoresAbortOnConfigError);
            this.solrConfigFilename = cores.getConfigFile().getName();
            return cores;
        }
    }
}

