/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.pop3;

import com.sun.mail.pop3.DefaultFolder;
import com.sun.mail.pop3.POP3Folder;
import com.sun.mail.pop3.Protocol;
import com.sun.mail.util.PropUtil;
import java.io.EOFException;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.Map;
import javax.mail.AuthenticationFailedException;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public class POP3Store
extends Store {
    private String name;
    private int defaultPort;
    private boolean isSSL;
    private Protocol port;
    private POP3Folder portOwner;
    private String host;
    private int portNum;
    private String user;
    private String passwd;
    private boolean useStartTLS;
    private boolean requireStartTLS;
    private Map capabilities;
    volatile Constructor messageConstructor;
    volatile boolean rsetBeforeQuit;
    volatile boolean disableTop;
    volatile boolean forgetTopHeaders;
    volatile boolean supportsUidl;

    public POP3Store(Session session, URLName url) {
        this(session, url, "pop3", false);
    }

    public POP3Store(Session session, URLName url, String name, boolean isSSL) {
        block8: {
            super(session, url);
            this.name = "pop3";
            this.defaultPort = 110;
            this.isSSL = false;
            this.port = null;
            this.portOwner = null;
            this.host = null;
            this.portNum = -1;
            this.user = null;
            this.passwd = null;
            this.useStartTLS = false;
            this.requireStartTLS = false;
            this.messageConstructor = null;
            this.rsetBeforeQuit = false;
            this.disableTop = false;
            this.forgetTopHeaders = false;
            this.supportsUidl = true;
            if (url != null) {
                name = url.getProtocol();
            }
            this.name = name;
            if (!isSSL) {
                isSSL = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".ssl.enable", false);
            }
            this.defaultPort = isSSL ? 995 : 110;
            this.isSSL = isSSL;
            this.rsetBeforeQuit = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".rsetbeforequit", false);
            this.disableTop = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".disabletop", false);
            this.forgetTopHeaders = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".forgettopheaders", false);
            this.useStartTLS = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".starttls.enable", false);
            this.requireStartTLS = PropUtil.getBooleanSessionProperty(session, "mail." + name + ".starttls.required", false);
            String s = session.getProperty("mail." + name + ".message.class");
            if (s != null) {
                if (session.getDebug()) {
                    session.getDebugOut().println("DEBUG POP3: message class: " + s);
                }
                try {
                    ClassLoader cl = this.getClass().getClassLoader();
                    Class<?> messageClass = null;
                    try {
                        messageClass = Class.forName(s, false, cl);
                    }
                    catch (ClassNotFoundException ex1) {
                        messageClass = Class.forName(s);
                    }
                    Class[] c = new Class[]{Folder.class, Integer.TYPE};
                    this.messageConstructor = messageClass.getConstructor(c);
                }
                catch (Exception ex) {
                    if (!session.getDebug()) break block8;
                    session.getDebugOut().println("DEBUG POP3: failed to load message class: " + ex);
                }
            }
        }
    }

    protected synchronized boolean protocolConnect(String host, int portNum, String user, String passwd) throws MessagingException {
        if (host == null || passwd == null || user == null) {
            return false;
        }
        if (portNum == -1) {
            portNum = PropUtil.getIntSessionProperty(this.session, "mail." + this.name + ".port", -1);
        }
        if (portNum == -1) {
            portNum = this.defaultPort;
        }
        this.host = host;
        this.portNum = portNum;
        this.user = user;
        this.passwd = passwd;
        try {
            this.port = this.getPort(null);
        }
        catch (EOFException eex) {
            throw new AuthenticationFailedException(eex.getMessage());
        }
        catch (IOException ioex) {
            throw new MessagingException("Connect failed", ioex);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isConnected() {
        if (!super.isConnected()) {
            return false;
        }
        try {
            if (this.port == null) {
                this.port = this.getPort(null);
            } else if (!this.port.noop()) {
                throw new IOException("NOOP failed");
            }
            return true;
        }
        catch (IOException ioex) {
            try {
                try {
                    super.close();
                }
                catch (MessagingException messagingException) {
                    Object var4_3 = null;
                    return false;
                }
                Object var4_2 = null;
                return false;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                return false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized Protocol getPort(POP3Folder owner) throws IOException {
        if (this.port != null && this.portOwner == null) {
            this.portOwner = owner;
            return this.port;
        }
        Protocol p = new Protocol(this.host, this.portNum, this.session.getDebug(), this.session.getDebugOut(), this.session.getProperties(), "mail." + this.name, this.isSSL);
        if (this.useStartTLS || this.requireStartTLS) {
            if (p.hasCapability("STLS")) {
                p.stls();
                p.setCapabilities(p.capa());
            } else if (this.requireStartTLS) {
                if (this.debug) {
                    this.session.getDebugOut().println("DEBUG POP3: STLS required but not supported");
                }
                try {
                    try {
                        p.quit();
                    }
                    catch (IOException ioex) {
                        Object var5_4 = null;
                        throw new EOFException("STLS required but not supported");
                    }
                    Object var5_3 = null;
                    throw new EOFException("STLS required but not supported");
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    throw new EOFException("STLS required but not supported");
                }
            }
        }
        this.capabilities = p.getCapabilities();
        if (!this.disableTop && this.capabilities != null && this.capabilities.containsKey("TOP")) {
            this.disableTop = true;
            this.session.getDebugOut().println("DEBUG POP3: server doesn't support TOP, disabling it");
        }
        this.supportsUidl = this.capabilities == null || this.capabilities.containsKey("UIDL");
        String msg = null;
        msg = p.login(this.user, this.passwd);
        if (msg != null) {
            try {
                try {
                    p.quit();
                }
                catch (IOException ioex) {
                    Object var7_11 = null;
                    throw new EOFException(msg);
                }
                Object var7_10 = null;
                throw new EOFException(msg);
            }
            catch (Throwable throwable) {
                Object var7_12 = null;
                throw new EOFException(msg);
            }
        }
        if (this.port == null && owner != null) {
            this.port = p;
            this.portOwner = owner;
        }
        if (this.portOwner != null) return p;
        this.portOwner = owner;
        return p;
    }

    synchronized void closePort(POP3Folder owner) {
        if (this.portOwner == owner) {
            this.port = null;
            this.portOwner = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws MessagingException {
        try {
            block4: {
                try {
                    if (this.port == null) break block4;
                    this.port.quit();
                }
                catch (IOException iOException) {
                    Object var3_2 = null;
                    this.port = null;
                    super.close();
                    return;
                }
            }
            Object var3_1 = null;
            this.port = null;
            super.close();
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.port = null;
            super.close();
            throw throwable;
        }
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new DefaultFolder(this);
    }

    public Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        return new POP3Folder(this, name);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return new POP3Folder(this, url.getFile());
    }

    public Map capabilities() throws MessagingException {
        Map c = this.capabilities;
        if (c != null) {
            return Collections.unmodifiableMap(c);
        }
        return Collections.emptyMap();
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.port != null) {
            this.close();
        }
    }

    private void checkConnected() throws MessagingException {
        if (!super.isConnected()) {
            throw new MessagingException("Not connected");
        }
    }
}

