/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search.grouping.distributed.shardresultserializer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.search.SolrIndexSearcher;
import org.apache.solr.search.grouping.Command;
import org.apache.solr.search.grouping.distributed.command.SearchGroupsFieldCommand;
import org.apache.solr.search.grouping.distributed.shardresultserializer.ShardResultTransformer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SearchGroupsResultTransformer
implements ShardResultTransformer<List<Command>, Map<String, Collection<SearchGroup<String>>>> {
    private final SolrIndexSearcher searcher;

    public SearchGroupsResultTransformer(SolrIndexSearcher searcher) {
        this.searcher = searcher;
    }

    @Override
    public NamedList transform(List<Command> data) throws IOException {
        NamedList result = new NamedList();
        for (Command command : data) {
            NamedList commandResult;
            if (SearchGroupsFieldCommand.class.isInstance(command)) {
                SearchGroupsFieldCommand fieldCommand = (SearchGroupsFieldCommand)command;
                Object searchGroups = fieldCommand.result();
                if (searchGroups == null) continue;
                commandResult = this.serializeSearchGroup((Collection<SearchGroup<String>>)searchGroups, fieldCommand.getGroupSort());
            } else {
                commandResult = null;
            }
            result.add(command.getKey(), commandResult);
        }
        return result;
    }

    @Override
    public Map<String, Collection<SearchGroup<String>>> transformToNative(NamedList<NamedList> shardResponse, Sort groupSort, Sort sortWithinGroup, String shard) throws IOException {
        HashMap<String, Collection<SearchGroup<String>>> result = new HashMap<String, Collection<SearchGroup<String>>>();
        for (Map.Entry command : shardResponse) {
            ArrayList<SearchGroup> searchGroups = new ArrayList<SearchGroup>();
            NamedList rawSearchGroups = (NamedList)command.getValue();
            for (Map.Entry rawSearchGroup : rawSearchGroups) {
                SearchGroup searchGroup = new SearchGroup();
                searchGroup.groupValue = rawSearchGroup.getKey() != null ? (String)rawSearchGroup.getKey() : null;
                searchGroup.sortValues = ((List)rawSearchGroup.getValue()).toArray(new Comparable[((List)rawSearchGroup.getValue()).size()]);
                searchGroups.add(searchGroup);
            }
            result.put((String)command.getKey(), (Collection<SearchGroup<String>>)searchGroups);
        }
        return result;
    }

    private NamedList serializeSearchGroup(Collection<SearchGroup<String>> data, Sort groupSort) {
        NamedList result = new NamedList();
        for (SearchGroup<String> searchGroup : data) {
            Comparable[] convertedSortValues = new Comparable[searchGroup.sortValues.length];
            for (int i = 0; i < searchGroup.sortValues.length; ++i) {
                SchemaField field;
                Comparable sortValue = (Comparable)searchGroup.sortValues[i];
                SchemaField schemaField = field = groupSort.getSort()[i].getField() != null ? this.searcher.getSchema().getFieldOrNull(groupSort.getSort()[i].getField()) : null;
                if (field != null) {
                    FieldType fieldType = field.getType();
                    if (sortValue instanceof String) {
                        sortValue = (Comparable)fieldType.toObject(field.createField(fieldType.indexedToReadable((String)((Object)sortValue)), 0.0f));
                    }
                }
                convertedSortValues[i] = sortValue;
            }
            String groupValue = searchGroup.groupValue != null ? (String)searchGroup.groupValue : null;
            result.add(groupValue, (Object)convertedSortValues);
        }
        return result;
    }
}

