/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyConfigOption;
import org.nuiton.wikitty.services.WikittyServiceSecurityExternalAuthentication;

@Deprecated
public class WikittyServiceSecurityExternalAuthenticationLDAP
implements WikittyServiceSecurityExternalAuthentication {
    private static Log log = LogFactory.getLog(WikittyServiceSecurityExternalAuthenticationLDAP.class);
    protected ApplicationConfig config;
    protected Properties jndiProp;
    protected String ldapLoginPattern;

    public WikittyServiceSecurityExternalAuthenticationLDAP(ApplicationConfig config) {
        this.config = config;
        Properties jndiPropTmp = config.getOptionStartsWith(WikittyConfigOption.WIKITTY_SERVICE_AUTHENTICATION_LDAP_JNDI.getKey());
        this.jndiProp = new Properties();
        Enumeration<?> e = jndiPropTmp.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = jndiPropTmp.getProperty(key);
            int debut = WikittyConfigOption.WIKITTY_SERVICE_AUTHENTICATION_LDAP_JNDI.getKey().length();
            key = key.substring(debut);
            this.jndiProp.setProperty(key, value);
        }
        String serverUrl = config.getOption(WikittyConfigOption.WIKITTY_SERVICE_AUTHENTICATION_LDAP_SERVER.getKey());
        this.jndiProp.put("java.naming.provider.url", serverUrl);
        this.ldapLoginPattern = config.getOption(WikittyConfigOption.WIKITTY_SERVICE_AUTHENTICATION_LDAP_LOGIN_PATTERN.getKey());
    }

    @Override
    public boolean login(String login, String password) {
        boolean result = false;
        String ldapLogin = String.format(this.ldapLoginPattern, login);
        Hashtable<Object, Object> env = new Hashtable<Object, Object>(this.jndiProp);
        env.put("java.naming.security.principal", ldapLogin);
        env.put("java.naming.security.credentials", password);
        try {
            InitialDirContext dirContext = new InitialDirContext(env);
            dirContext.close();
            result = true;
        }
        catch (NamingException eee) {
            log.debug((Object)String.format("Erreur lors de l'acces au serveur LDAP pour l'utilisateur %s -> %s", login, ldapLogin), (Throwable)eee);
        }
        return result;
    }
}

