/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.spelling.suggest;

import java.util.ArrayList;
import java.util.List;
import org.apache.solr.util.TermFreqIterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferingTermFreqIteratorWrapper
implements TermFreqIterator {
    protected ArrayList<Entry> entries = new ArrayList();
    protected int curPos;
    protected Entry curEntry;

    public BufferingTermFreqIteratorWrapper(TermFreqIterator source) {
        while (source.hasNext()) {
            String w = (String)source.next();
            Entry e = new Entry(w, source.freq());
            this.entries.add(e);
        }
        this.curPos = 0;
    }

    @Override
    public float freq() {
        return this.curEntry.freq;
    }

    @Override
    public boolean hasNext() {
        return this.curPos < this.entries.size();
    }

    @Override
    public String next() {
        this.curEntry = this.entries.get(this.curPos);
        ++this.curPos;
        return this.curEntry.word;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove is not supported");
    }

    public List<Entry> entries() {
        return this.entries;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Entry
    implements Comparable<Entry> {
        String word;
        float freq;

        public Entry(String word, float freq) {
            this.word = word;
            this.freq = freq;
        }

        @Override
        public int compareTo(Entry o) {
            return this.word.compareTo(o.word);
        }
    }
}

