/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.response;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.apache.commons.io.IOUtils;
import org.apache.solr.common.util.ContentStream;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.BinaryQueryResponseWriter;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;

public class RawResponseWriter
implements BinaryQueryResponseWriter {
    public static final String CONTENT = "content";
    private String _baseWriter = null;

    public void init(NamedList n) {
        Object base;
        if (n != null && (base = n.get("base")) != null) {
            this._baseWriter = base.toString();
        }
    }

    protected QueryResponseWriter getBaseWriter(SolrQueryRequest request) {
        return request.getCore().getQueryResponseWriter(this._baseWriter);
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        Object obj = response.getValues().get(CONTENT);
        if (obj != null && obj instanceof ContentStream) {
            return ((ContentStream)obj).getContentType();
        }
        return this.getBaseWriter(request).getContentType(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        block3: {
            Object obj = response.getValues().get(CONTENT);
            if (obj != null && obj instanceof ContentStream) {
                ContentStream content = (ContentStream)obj;
                Reader reader = content.getReader();
                try {
                    IOUtils.copy((Reader)reader, (Writer)writer);
                    Object var8_7 = null;
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    reader.close();
                    throw throwable;
                }
                reader.close();
                {
                    break block3;
                }
            }
            this.getBaseWriter(request).write(writer, request, response);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream out, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        InputStream in;
        Object obj = response.getValues().get(CONTENT);
        if (obj != null && obj instanceof ContentStream) {
            ContentStream content = (ContentStream)obj;
            in = content.getStream();
            try {
                IOUtils.copy((InputStream)in, (OutputStream)out);
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                in.close();
                throw throwable;
            }
        } else {
            throw new IOException("did not find a CONTENT object");
        }
        in.close();
    }
}

