/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;
import org.nuiton.util.ApplicationConfig;
import org.nuiton.wikitty.WikittyService;
import org.nuiton.wikitty.WikittyUtil;
import org.nuiton.wikitty.entities.Wikitty;
import org.nuiton.wikitty.entities.WikittyAuthorisationHelper;
import org.nuiton.wikitty.entities.WikittyExtension;
import org.nuiton.wikitty.entities.WikittyGroupHelper;
import org.nuiton.wikitty.entities.WikittyImpl;
import org.nuiton.wikitty.entities.WikittyMetaExtensionUtil;
import org.nuiton.wikitty.entities.WikittyTokenHelper;
import org.nuiton.wikitty.entities.WikittyTreeNode;
import org.nuiton.wikitty.entities.WikittyUserHelper;
import org.nuiton.wikitty.search.Criteria;
import org.nuiton.wikitty.search.Search;
import org.nuiton.wikitty.services.WikittyEvent;
import org.nuiton.wikitty.services.WikittyListener;
import org.nuiton.wikitty.services.WikittyServiceDelegator;
import org.nuiton.wikitty.services.WikittyServiceEnhanced;

public class WikittyServiceSecurity
extends WikittyServiceDelegator {
    private static Log log = LogFactory.getLog(WikittyServiceSecurity.class);
    protected transient String appAdminGroupId = null;

    public WikittyServiceSecurity(ApplicationConfig config, WikittyService ws) {
        super(ws);
    }

    @Override
    public void addWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        this.getDelegate().addWikittyServiceListener(listener, type);
    }

    @Override
    public void removeWikittyServiceListener(WikittyListener listener, WikittyService.ServiceListenerType type) {
        this.getDelegate().addWikittyServiceListener(listener, type);
    }

    @Override
    public String login(String login, String password) {
        Criteria criteria = Search.query().eq("WikittyUser.login", login).criteria();
        String userId = this.getDelegate().findByCriteria(null, Collections.singletonList(criteria)).get(0);
        if (userId == null) {
            throw new IllegalArgumentException(String.format("no such account '%s'", login));
        }
        Wikitty user = WikittyServiceEnhanced.restore(this.getDelegate(), null, userId);
        if (WikittyUserHelper.getPassword(user).equals(password)) {
            String tokenId = WikittyUtil.genSecurityTokenId();
            WikittyImpl wikittyToken = new WikittyImpl(tokenId);
            WikittyTokenHelper.addExtension(wikittyToken);
            WikittyTokenHelper.setUser(wikittyToken, user.getId());
            WikittyTokenHelper.setDate(wikittyToken, new Date());
            this.getDelegate().store(null, Arrays.asList(wikittyToken), false);
            log.debug((Object)String.format("token '%s' is for login '%s'", tokenId, login));
            return tokenId;
        }
        throw new SecurityException("bad password");
    }

    @Override
    public void logout(String securityToken) {
        if (securityToken != null) {
            this.getDelegate().delete(securityToken, Arrays.asList(securityToken));
        }
    }

    @Override
    public WikittyEvent clear(String securityToken) {
        String userId = this.getUserId(securityToken);
        if (this.isAppAdmin(securityToken, userId)) {
            WikittyEvent result = this.getDelegate().clear(securityToken);
            return result;
        }
        throw new SecurityException(I18n._((String)"user %s can't clear data", (Object[])new Object[]{userId}));
    }

    @Override
    public WikittyEvent replay(String securityToken, List<WikittyEvent> events, boolean force) {
        String userId = this.getUserId(securityToken);
        for (WikittyEvent e : events) {
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.CLEAR_WIKITTY) || e.getType().contains((Object)WikittyEvent.WikittyEventType.CLEAR_EXTENSION)) {
                if (this.isAppAdmin(securityToken, userId)) break;
                throw new SecurityException(I18n._((String)"user %s can't clear data", (Object[])new Object[]{userId}));
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.PUT_WIKITTY)) {
                this.checkStore(securityToken, e.getWikitties().values());
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.REMOVE_WIKITTY)) {
                this.checkDelete(securityToken, e.getRemoveDate().keySet());
            }
            if (e.getType().contains((Object)WikittyEvent.WikittyEventType.PUT_EXTENSION)) {
                this.checkStoreExtension(securityToken, e.getExtensions().values());
            }
            if (!e.getType().contains((Object)WikittyEvent.WikittyEventType.REMOVE_EXTENSION)) continue;
            this.checkDeleteExtension(securityToken, e.getDeletedExtensions());
        }
        WikittyEvent result = this.getDelegate().replay(securityToken, events, force);
        return result;
    }

    protected boolean userIsAnonymousOrAppAdmin(String securityToken, String userId) {
        boolean userIsAnonymousOrAppAdmin = false;
        if (this.getAppAdminGroup(securityToken) == null) {
            if (securityToken == null) {
                userIsAnonymousOrAppAdmin = true;
            }
        } else if (this.isAppAdmin(securityToken, userId)) {
            userIsAnonymousOrAppAdmin = true;
        }
        return userIsAnonymousOrAppAdmin;
    }

    @Override
    public WikittyEvent store(String securityToken, Collection<Wikitty> wikitties, boolean force) {
        this.checkStore(securityToken, wikitties);
        WikittyEvent result = this.getDelegate().store(securityToken, wikitties, force);
        return result;
    }

    protected void checkStore(String securityToken, Collection<Wikitty> wikitties) {
        String userId = this.getUserId(securityToken);
        for (Wikitty wikitty : wikitties) {
            if (wikitty == null) continue;
            Wikitty oldVersion = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, wikitty.getId());
            ArrayList<String> newExtensions = new ArrayList<String>(wikitty.getExtensionNames());
            if (oldVersion != null) {
                newExtensions.removeAll(oldVersion.getExtensionNames());
            }
            for (String extensionName : newExtensions) {
                Wikitty extensionRights = this.restoreExtensionAuthorisation(securityToken, extensionName);
                boolean canCreate = extensionRights == null || this.canRead(securityToken, userId, null, extensionRights);
                if (canCreate) continue;
                throw new SecurityException(I18n._((String)"user %s can't create instance of extension %s", (Object[])new Object[]{userId, extensionRights}));
            }
            if (oldVersion == null) continue;
            for (String fqFieldDirtyName : wikitty.getDirty()) {
                boolean fieldRequireAdminRights;
                boolean canChange;
                String concernedExtensionName = WikittyUtil.getExtensionNameFromFQFieldName(fqFieldDirtyName);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("will update field %s from extension %s", fqFieldDirtyName, concernedExtensionName));
                }
                if (canChange = (fieldRequireAdminRights = "WikittyAuthorisation".equals(concernedExtensionName) || "WikittyAuthorisation".equals(WikittyUtil.getMetaExtensionNameFromFQMetaExtensionName(concernedExtensionName))) ? this.canAdmin(securityToken, userId, concernedExtensionName, wikitty) : this.canWrite(securityToken, userId, concernedExtensionName, wikitty)) continue;
                throw new SecurityException(I18n._((String)"user %s can't write field %s on wikitty %s", (Object[])new Object[]{userId, fqFieldDirtyName, wikitty}));
            }
        }
    }

    @Override
    public List<Wikitty> restore(String securityToken, List<String> ids) {
        String userId = this.getUserId(securityToken);
        List<Wikitty> wikitties = this.getDelegate().restore(securityToken, ids);
        for (Wikitty wikitty : wikitties) {
            if (wikitty == null) continue;
            this.refuseUnauthorizedRead(securityToken, userId, wikitty);
        }
        return wikitties;
    }

    protected void refuseUnauthorizedRead(String securityToken, String userId, Wikitty wikitty) {
        if (wikitty != null) {
            for (String extensionName : wikitty.getExtensionNames()) {
                if (this.canRead(securityToken, userId, extensionName, wikitty)) continue;
                throw new SecurityException(I18n._((String)"user %s can't read extension %s on wikitty %s, it may be due to a global policy on the wikitty", (Object[])new Object[]{userId, extensionName, wikitty}));
            }
        }
    }

    protected boolean canRead(String securityToken, String userId, String extensionName, Wikitty wikitty) {
        boolean canRead = false;
        canRead = wikitty.hasMetaExtension("WikittyAuthorisation", extensionName) ? this.isReader(securityToken, userId, wikitty, extensionName) || this.canWrite(securityToken, userId, extensionName, wikitty) : (!canRead && wikitty.hasExtension("WikittyAuthorisation") ? this.isReader(securityToken, userId, wikitty, null) || this.canWrite(securityToken, userId, extensionName, wikitty) : true);
        return canRead;
    }

    protected boolean canWrite(String securityToken, String userId, String extensionName, Wikitty wikitty) {
        boolean canWrite = false;
        canWrite = wikitty.hasMetaExtension("WikittyAuthorisation", extensionName) ? this.isWriter(securityToken, userId, wikitty, extensionName) || this.canAdmin(securityToken, userId, extensionName, wikitty) : (!canWrite && wikitty.hasExtension("WikittyAuthorisation") ? this.isWriter(securityToken, userId, wikitty, null) || this.canAdmin(securityToken, userId, extensionName, wikitty) : true);
        return canWrite;
    }

    protected boolean canAdmin(String securityToken, String userId, String extensionName, Wikitty wikitty) {
        boolean canAdmin = false;
        if (wikitty.hasMetaExtension("WikittyAuthorisation", extensionName)) {
            canAdmin = this.isAdmin(securityToken, userId, wikitty, extensionName) || this.isOwner(securityToken, userId, wikitty, extensionName);
        } else if (!canAdmin && wikitty.hasExtension("WikittyAuthorisation")) {
            canAdmin = this.isAdmin(securityToken, userId, wikitty, null) || this.isOwner(securityToken, userId, wikitty, null);
        } else if (!canAdmin) {
            canAdmin = this.userIsAnonymousOrAppAdmin(securityToken, userId);
        }
        return canAdmin;
    }

    @Override
    public WikittyEvent delete(String securityToken, Collection<String> ids) {
        this.checkDelete(securityToken, ids);
        WikittyEvent result = this.getDelegate().delete(securityToken, ids);
        return result;
    }

    public void checkDelete(String securityToken, Collection<String> ids) {
        String userId = this.getUserId(securityToken);
        ArrayList<String> idsAsList = new ArrayList<String>(ids);
        List<Wikitty> wikitties = this.getDelegate().restore(securityToken, idsAsList);
        for (Wikitty wikitty : wikitties) {
            if (wikitty == null) continue;
            for (String extensionName : wikitty.getExtensionNames()) {
                if (this.canWrite(securityToken, userId, extensionName, wikitty)) continue;
                throw new SecurityException(I18n._((String)"user %s doesn't have rights on extension %s on wikitty %s", (Object[])new Object[]{userId, extensionName, wikitty}));
            }
        }
    }

    @Override
    public boolean canWrite(String securityToken, Wikitty wikitty) {
        boolean result = true;
        String userId = this.getUserId(securityToken);
        for (String extName : wikitty.getExtensionNames()) {
            if (result = result && this.isWriter(securityToken, userId, wikitty, extName)) continue;
            break;
        }
        return result;
    }

    @Override
    public boolean canDelete(String securityToken, String wikittyId) {
        boolean result = true;
        Wikitty wikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, wikittyId);
        if (wikitty != null) {
            String userId = this.getUserId(securityToken);
            for (String extName : wikitty.getExtensionNames()) {
                if (result = result && this.isWriter(securityToken, userId, wikitty, extName)) continue;
                break;
            }
        }
        return result;
    }

    @Override
    public boolean canRead(String securityToken, String wikittyId) {
        boolean result = true;
        String userId = this.getUserId(securityToken);
        Wikitty wikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, wikittyId);
        for (String extName : wikitty.getExtensionNames()) {
            if (result = result && this.isReader(securityToken, userId, wikitty, extName)) continue;
            break;
        }
        return result;
    }

    protected void checkStoreExtension(String securityToken, Collection<WikittyExtension> exts) {
        String userId = this.getUserId(securityToken);
        if (!this.userIsAnonymousOrAppAdmin(securityToken, userId)) {
            for (WikittyExtension extension : exts) {
                boolean canWrite;
                Wikitty extensionAuthorisation = this.restoreExtensionAuthorisation(securityToken, extension.getName());
                if (extensionAuthorisation == null || (canWrite = this.canWrite(securityToken, userId, null, extensionAuthorisation))) continue;
                throw new SecurityException(I18n._((String)"user %s don't have write right for extension %s", (Object[])new Object[]{userId, extension}));
            }
        }
    }

    protected void checkDeleteExtension(String securityToken, Collection<String> extNames) {
    }

    @Override
    public WikittyEvent storeExtension(String securityToken, Collection<WikittyExtension> exts) {
        this.checkStoreExtension(securityToken, exts);
        return this.getDelegate().storeExtension(securityToken, exts);
    }

    @Override
    public WikittyEvent deleteExtension(String securityToken, Collection<String> extNames) {
        this.checkDeleteExtension(securityToken, extNames);
        return this.getDelegate().deleteExtension(securityToken, extNames);
    }

    private void checkRestoreTreeNode(String securityToken, String userId, WikittyTreeNode treeNode) {
        Wikitty treeNodeWikitty = WikittyUtil.getWikitty(this.getDelegate(), securityToken, treeNode);
        this.refuseUnauthorizedRead(securityToken, userId, treeNodeWikitty);
    }

    @Override
    public WikittyEvent deleteTree(String securityToken, String treeNodeId) {
        Wikitty treeNodeWikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, treeNodeId);
        List<Wikitty> wikitties = Collections.singletonList(treeNodeWikitty);
        this.checkStore(securityToken, wikitties);
        return this.getDelegate().deleteTree(securityToken, treeNodeId);
    }

    @Override
    public Wikitty restoreVersion(String securityToken, String wikittyId, String version) {
        Wikitty wikitty = this.getDelegate().restoreVersion(securityToken, wikittyId, version);
        String userId = this.getUserId(securityToken);
        this.refuseUnauthorizedRead(securityToken, userId, wikitty);
        return wikitty;
    }

    @Override
    public void syncSearchEngine(String securityToken) {
        String userId = this.getUserId(securityToken);
        if (!this.isAppAdmin(securityToken, userId)) {
            throw new SecurityException(I18n._((String)"user %s can't sync search engine", (Object[])new Object[]{this.getUserId(securityToken)}));
        }
        this.getDelegate().syncSearchEngine(securityToken);
    }

    protected String getUserId(String securityToken) {
        String result = null;
        if (securityToken != null) {
            Wikitty securityTokenWikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, securityToken);
            if (securityTokenWikitty == null) {
                throw new SecurityException("bad (obsolete ?) token");
            }
            result = WikittyTokenHelper.getUser(securityTokenWikitty);
        }
        return result;
    }

    protected boolean isReader(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "reader");
        boolean result = this.isMember(securityToken, userId, wikitty, metaFieldName, true);
        return result;
    }

    protected boolean isWriter(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "writer");
        log.trace((Object)("meta field name " + metaFieldName));
        boolean result = this.isMember(securityToken, userId, wikitty, metaFieldName);
        return result;
    }

    protected boolean isAdmin(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "admin");
        boolean result = this.isMember(securityToken, userId, wikitty, metaFieldName);
        return result;
    }

    protected boolean isOwner(String securityToken, String userId, Wikitty wikitty, String extensionName) {
        String fieldName;
        String metaFieldName = WikittyUtil.getMetaFieldName("WikittyAuthorisation", extensionName, "owner");
        String actualExtensionName = WikittyUtil.getExtensionNameFromFQFieldName(metaFieldName);
        String owner = wikitty.getFieldAsString(actualExtensionName, fieldName = WikittyUtil.getFieldNameFromFQFieldName(metaFieldName));
        boolean isOwner = owner == null ? false : owner.equals(userId);
        return isOwner;
    }

    protected boolean isMember(String securityToken, String userId, Wikitty extensionRights, String fqFieldName) {
        return this.isMember(securityToken, userId, extensionRights, fqFieldName, false);
    }

    protected boolean isMember(String securityToken, String userId, Wikitty extensionRights, String fqFieldName, boolean considerEmptyGroupAsMembership) {
        String parentId;
        String fieldName;
        String extensionName = WikittyUtil.getExtensionNameFromFQFieldName(fqFieldName);
        Set<String> groupOrUser = extensionRights.getFieldAsSet(extensionName, fieldName = WikittyUtil.getFieldNameFromFQFieldName(fqFieldName), String.class);
        boolean isMember = groupOrUser == null || groupOrUser.isEmpty() ? considerEmptyGroupAsMembership : this.isMember(securityToken, userId, groupOrUser);
        if (!isMember && (parentId = WikittyAuthorisationHelper.getParent(extensionRights)) != null) {
            Wikitty parent = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, parentId);
            isMember = this.isMember(securityToken, userId, parent, fqFieldName);
        }
        return isMember;
    }

    protected boolean isAppAdmin(String securityToken, String userId) {
        boolean result = true;
        Wikitty group = this.getAppAdminGroup(securityToken);
        if (group != null) {
            Set<String> ids = WikittyGroupHelper.getMembers(group);
            result = this.isMember(securityToken, userId, ids);
        }
        return result;
    }

    protected Wikitty getAppAdminGroup(String securityToken) {
        Wikitty group = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, this.appAdminGroupId);
        if (group == null) {
            String groupId;
            Criteria criteria = Search.query().eq("WikittyGroup.name", "WikittyAppAdmin").criteria();
            this.appAdminGroupId = groupId = this.getDelegate().findByCriteria(securityToken, Collections.singletonList(criteria)).get(0);
            group = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, this.appAdminGroupId);
        }
        return group;
    }

    protected boolean isMember(String securityToken, String userId, Set<String> groupOrUser) {
        if (groupOrUser != null) {
            for (String id : groupOrUser) {
                if (id.equals(userId)) {
                    return true;
                }
                Wikitty groupWikitty = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, id);
                if (!WikittyGroupHelper.hasExtension(groupWikitty)) continue;
                Set<String> members = WikittyGroupHelper.getMembers(groupWikitty);
                return this.isMember(securityToken, userId, members);
            }
        }
        return false;
    }

    protected Wikitty restoreExtensionAuthorisation(String securityToken, WikittyExtension extension) {
        return this.restoreExtensionAuthorisation(securityToken, extension.getName());
    }

    protected Wikitty restoreExtensionAuthorisation(String securityToken, String extensionName) {
        String wikittyAuthorisationId = WikittyMetaExtensionUtil.generateId("WikittyAuthorisation", extensionName);
        Wikitty wikittyAuthorisation = WikittyServiceEnhanced.restore(this.getDelegate(), securityToken, wikittyAuthorisationId);
        if (wikittyAuthorisation == null) {
            log.debug((Object)(extensionName + " has no authorization attached"));
        }
        return wikittyAuthorisation;
    }
}

