/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.config.ActionConfig;
import org.apache.struts.config.ActionConfigMatcher;
import org.apache.struts.config.BaseConfig;
import org.apache.struts.config.ControllerConfig;
import org.apache.struts.config.ExceptionConfig;
import org.apache.struts.config.FormBeanConfig;
import org.apache.struts.config.ForwardConfig;
import org.apache.struts.config.MessageResourcesConfig;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;

public class ModuleConfigImpl
extends BaseConfig
implements Serializable,
ModuleConfig {
    protected static Log log = LogFactory.getLog((Class)ModuleConfigImpl.class);
    protected HashMap actionConfigs = null;
    protected HashMap actionConfigIds = null;
    protected List actionConfigList = null;
    protected HashMap exceptions = null;
    protected HashMap formBeans = null;
    protected HashMap forwards = null;
    protected HashMap messageResources = null;
    protected ArrayList plugIns = null;
    protected ControllerConfig controllerConfig = null;
    protected String prefix = null;
    protected String actionFormBeanClass = "org.apache.struts.action.ActionFormBean";
    protected String actionMappingClass = "org.apache.struts.action.ActionMapping";
    protected String actionForwardClass = "org.apache.struts.action.ActionForward";
    protected ActionConfigMatcher matcher = null;

    public ModuleConfigImpl() {
        this("");
    }

    public ModuleConfigImpl(String prefix) {
        this.prefix = prefix;
        this.actionConfigs = new HashMap();
        this.actionConfigIds = new HashMap();
        this.actionConfigList = new ArrayList();
        this.actionFormBeanClass = "org.apache.struts.action.ActionFormBean";
        this.actionMappingClass = "org.apache.struts.action.ActionMapping";
        this.actionForwardClass = "org.apache.struts.action.ActionForward";
        this.configured = false;
        this.controllerConfig = null;
        this.exceptions = new HashMap();
        this.formBeans = new HashMap();
        this.forwards = new HashMap();
        this.messageResources = new HashMap();
        this.plugIns = new ArrayList();
    }

    public boolean getConfigured() {
        return this.configured;
    }

    public ControllerConfig getControllerConfig() {
        if (this.controllerConfig == null) {
            this.controllerConfig = new ControllerConfig();
        }
        return this.controllerConfig;
    }

    public void setControllerConfig(ControllerConfig cc) {
        this.throwIfConfigured();
        this.controllerConfig = cc;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String prefix) {
        this.throwIfConfigured();
        this.prefix = prefix;
    }

    public String getActionFormBeanClass() {
        return this.actionFormBeanClass;
    }

    public void setActionFormBeanClass(String actionFormBeanClass) {
        this.actionFormBeanClass = actionFormBeanClass;
    }

    public String getActionMappingClass() {
        return this.actionMappingClass;
    }

    public void setActionMappingClass(String actionMappingClass) {
        this.actionMappingClass = actionMappingClass;
    }

    public void addActionConfig(ActionConfig config) {
        String actionId;
        this.throwIfConfigured();
        config.setModuleConfig(this);
        String path = config.getPath();
        if (this.actionConfigs.containsKey(path)) {
            log.warn((Object)("Overriding ActionConfig of path " + path));
        }
        if ((actionId = config.getActionId()) != null && !actionId.equals("")) {
            if (this.actionConfigIds.containsKey(actionId) && log.isWarnEnabled()) {
                ActionConfig otherConfig = (ActionConfig)this.actionConfigIds.get(actionId);
                StringBuffer msg = new StringBuffer("Overriding actionId[");
                msg.append(actionId);
                msg.append("] for path[");
                msg.append(otherConfig.getPath());
                msg.append("] with path[");
                msg.append(path);
                msg.append("]");
                log.warn((Object)msg);
            }
            this.actionConfigIds.put(actionId, config);
        }
        this.actionConfigs.put(path, config);
        this.actionConfigList.add(config);
    }

    public void addExceptionConfig(ExceptionConfig config) {
        this.throwIfConfigured();
        String key = config.getType();
        if (this.exceptions.containsKey(key)) {
            log.warn((Object)("Overriding ExceptionConfig of type " + key));
        }
        this.exceptions.put(key, config);
    }

    public void addFormBeanConfig(FormBeanConfig config) {
        this.throwIfConfigured();
        String key = config.getName();
        if (this.formBeans.containsKey(key)) {
            log.warn((Object)("Overriding ActionForm of name " + key));
        }
        this.formBeans.put(key, config);
    }

    public String getActionForwardClass() {
        return this.actionForwardClass;
    }

    public void setActionForwardClass(String actionForwardClass) {
        this.actionForwardClass = actionForwardClass;
    }

    public void addForwardConfig(ForwardConfig config) {
        this.throwIfConfigured();
        String key = config.getName();
        if (this.forwards.containsKey(key)) {
            log.warn((Object)("Overriding global ActionForward of name " + key));
        }
        this.forwards.put(key, config);
    }

    public void addMessageResourcesConfig(MessageResourcesConfig config) {
        this.throwIfConfigured();
        String key = config.getKey();
        if (this.messageResources.containsKey(key)) {
            log.warn((Object)("Overriding MessageResources bundle of key " + key));
        }
        this.messageResources.put(key, config);
    }

    public void addPlugInConfig(PlugInConfig plugInConfig) {
        this.throwIfConfigured();
        this.plugIns.add(plugInConfig);
    }

    public ActionConfig findActionConfig(String path) {
        ActionConfig config = (ActionConfig)this.actionConfigs.get(path);
        if (config == null && this.matcher != null) {
            config = this.matcher.match(path);
        }
        return config;
    }

    public ActionConfig findActionConfigId(String actionId) {
        if (actionId != null) {
            return (ActionConfig)this.actionConfigIds.get(actionId);
        }
        return null;
    }

    public ActionConfig[] findActionConfigs() {
        ActionConfig[] results = new ActionConfig[this.actionConfigList.size()];
        return this.actionConfigList.toArray(results);
    }

    public ExceptionConfig findExceptionConfig(String type) {
        return (ExceptionConfig)this.exceptions.get(type);
    }

    public ExceptionConfig findException(Class type) {
        ExceptionConfig config = null;
        do {
            String name = type.getName();
            log.debug((Object)("findException: look locally for " + name));
            config = this.findExceptionConfig(name);
            if (config == null) continue;
            return config;
        } while ((type = type.getSuperclass()) != null);
        return null;
    }

    public ExceptionConfig[] findExceptionConfigs() {
        ExceptionConfig[] results = new ExceptionConfig[this.exceptions.size()];
        return this.exceptions.values().toArray(results);
    }

    public FormBeanConfig findFormBeanConfig(String name) {
        return (FormBeanConfig)this.formBeans.get(name);
    }

    public FormBeanConfig[] findFormBeanConfigs() {
        FormBeanConfig[] results = new FormBeanConfig[this.formBeans.size()];
        return this.formBeans.values().toArray(results);
    }

    public ForwardConfig findForwardConfig(String name) {
        return (ForwardConfig)this.forwards.get(name);
    }

    public ForwardConfig[] findForwardConfigs() {
        ForwardConfig[] results = new ForwardConfig[this.forwards.size()];
        return this.forwards.values().toArray(results);
    }

    public MessageResourcesConfig findMessageResourcesConfig(String key) {
        return (MessageResourcesConfig)this.messageResources.get(key);
    }

    public MessageResourcesConfig[] findMessageResourcesConfigs() {
        MessageResourcesConfig[] results = new MessageResourcesConfig[this.messageResources.size()];
        return this.messageResources.values().toArray(results);
    }

    public PlugInConfig[] findPlugInConfigs() {
        PlugInConfig[] results = new PlugInConfig[this.plugIns.size()];
        return this.plugIns.toArray(results);
    }

    public void freeze() {
        super.freeze();
        ActionConfig[] aconfigs = this.findActionConfigs();
        for (int i = 0; i < aconfigs.length; ++i) {
            aconfigs[i].freeze();
        }
        this.matcher = new ActionConfigMatcher(aconfigs);
        this.getControllerConfig().freeze();
        ExceptionConfig[] econfigs = this.findExceptionConfigs();
        for (int i = 0; i < econfigs.length; ++i) {
            econfigs[i].freeze();
        }
        FormBeanConfig[] fbconfigs = this.findFormBeanConfigs();
        for (int i = 0; i < fbconfigs.length; ++i) {
            fbconfigs[i].freeze();
        }
        ForwardConfig[] fconfigs = this.findForwardConfigs();
        for (int i = 0; i < fconfigs.length; ++i) {
            fconfigs[i].freeze();
        }
        MessageResourcesConfig[] mrconfigs = this.findMessageResourcesConfigs();
        for (int i = 0; i < mrconfigs.length; ++i) {
            mrconfigs[i].freeze();
        }
        PlugInConfig[] piconfigs = this.findPlugInConfigs();
        for (int i = 0; i < piconfigs.length; ++i) {
            piconfigs[i].freeze();
        }
    }

    public void removeActionConfig(ActionConfig config) {
        this.throwIfConfigured();
        config.setModuleConfig(null);
        this.actionConfigs.remove(config.getPath());
        this.actionConfigList.remove(config);
    }

    public void removeExceptionConfig(ExceptionConfig config) {
        this.throwIfConfigured();
        this.exceptions.remove(config.getType());
    }

    public void removeFormBeanConfig(FormBeanConfig config) {
        this.throwIfConfigured();
        this.formBeans.remove(config.getName());
    }

    public void removeForwardConfig(ForwardConfig config) {
        this.throwIfConfigured();
        this.forwards.remove(config.getName());
    }

    public void removeMessageResourcesConfig(MessageResourcesConfig config) {
        this.throwIfConfigured();
        this.messageResources.remove(config.getKey());
    }
}

