/*
 * Decompiled with CFR 0.152.
 */
package org.nuiton.wikitty.entities;

import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.nuiton.wikitty.WikittyException;
import org.nuiton.wikitty.entities.BusinessEntity;
import org.nuiton.wikitty.entities.WikittyAuthorisation;
import org.nuiton.wikitty.entities.WikittyField;

public class WikittyAuthorisationDTO
implements WikittyAuthorisation {
    @WikittyField(fqn="WikittyAuthorisation.owner")
    protected String owner;
    @WikittyField(fqn="WikittyAuthorisation.admin")
    protected Set<String> admin = new LinkedHashSet<String>();
    @WikittyField(fqn="WikittyAuthorisation.writer")
    protected Set<String> writer = new LinkedHashSet<String>();
    @WikittyField(fqn="WikittyAuthorisation.reader")
    protected Set<String> reader = new LinkedHashSet<String>();
    @WikittyField(fqn="WikittyAuthorisation.parent")
    protected String parent;
    protected String wikittyId;
    protected int modificationCount = 0;
    protected String wikittyVersion;

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
        ++this.modificationCount;
    }

    public Set<String> getAdmin() {
        return this.admin;
    }

    public void setAdmin(Set<String> admin) {
        this.admin = admin == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(admin);
        ++this.modificationCount;
    }

    public void addAllAdmin(Set<String> admin) {
        if (this.admin == null) {
            this.admin = new LinkedHashSet<String>();
        }
        this.admin.addAll(admin);
        ++this.modificationCount;
    }

    public void addAdmin(String element) {
        if (this.admin == null) {
            this.admin = new LinkedHashSet<String>();
        }
        this.admin.add(element);
        ++this.modificationCount;
    }

    public void removeAdmin(String element) {
        this.admin.remove(element);
        ++this.modificationCount;
    }

    public void clearAdmin() {
        this.admin.clear();
        ++this.modificationCount;
    }

    public Set<String> getWriter() {
        return this.writer;
    }

    public void setWriter(Set<String> writer) {
        this.writer = writer == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(writer);
        ++this.modificationCount;
    }

    public void addAllWriter(Set<String> writer) {
        if (this.writer == null) {
            this.writer = new LinkedHashSet<String>();
        }
        this.writer.addAll(writer);
        ++this.modificationCount;
    }

    public void addWriter(String element) {
        if (this.writer == null) {
            this.writer = new LinkedHashSet<String>();
        }
        this.writer.add(element);
        ++this.modificationCount;
    }

    public void removeWriter(String element) {
        this.writer.remove(element);
        ++this.modificationCount;
    }

    public void clearWriter() {
        this.writer.clear();
        ++this.modificationCount;
    }

    public Set<String> getReader() {
        return this.reader;
    }

    public void setReader(Set<String> reader) {
        this.reader = reader == null ? new LinkedHashSet<String>() : new LinkedHashSet<String>(reader);
        ++this.modificationCount;
    }

    public void addAllReader(Set<String> reader) {
        if (this.reader == null) {
            this.reader = new LinkedHashSet<String>();
        }
        this.reader.addAll(reader);
        ++this.modificationCount;
    }

    public void addReader(String element) {
        if (this.reader == null) {
            this.reader = new LinkedHashSet<String>();
        }
        this.reader.add(element);
        ++this.modificationCount;
    }

    public void removeReader(String element) {
        this.reader.remove(element);
        ++this.modificationCount;
    }

    public void clearReader() {
        this.reader.clear();
        ++this.modificationCount;
    }

    public String getParent() {
        return this.parent;
    }

    public void setParent(String parent) {
        this.parent = parent;
        ++this.modificationCount;
    }

    public WikittyAuthorisationDTO() {
    }

    public WikittyAuthorisationDTO(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String toString() {
        return "dto:" + this.getWikittyId() + ":" + this.getWikittyVersion();
    }

    public String getWikittyId() {
        return this.wikittyId;
    }

    public void setWikittyId(String wikittyId) {
        this.wikittyId = wikittyId;
    }

    public String getWikittyVersion() {
        String result = this.wikittyVersion;
        if (this.modificationCount > 0) {
            result = result + "." + this.modificationCount;
        }
        return result;
    }

    public void setWikittyVersion(String wikittyVersion) {
        this.wikittyVersion = wikittyVersion;
        this.modificationCount = 0;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void addPropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void removePropertyChangeListener(String property, PropertyChangeListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionFields(String ext) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Collection<String> getExtensionNames() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public Object getField(String ext, String fieldName) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setField(String ext, String fieldName, Object value) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void copyFrom(BusinessEntity source) {
        Set reader;
        Set writer;
        if (!(source instanceof WikittyAuthorisation)) {
            throw new WikittyException("Can't copy source object " + source + ". They are not of the same type");
        }
        WikittyAuthorisation sourceCopy = (WikittyAuthorisation)source;
        this.setOwner(sourceCopy.getOwner());
        Set admin = sourceCopy.getAdmin();
        if (admin != null) {
            this.setAdmin(new LinkedHashSet<String>(admin));
        }
        if ((writer = sourceCopy.getWriter()) != null) {
            this.setWriter(new LinkedHashSet<String>(writer));
        }
        if ((reader = sourceCopy.getReader()) != null) {
            this.setReader(new LinkedHashSet<String>(reader));
        }
        this.setParent(sourceCopy.getParent());
        this.setWikittyVersion(sourceCopy.getWikittyVersion());
    }
}

