/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.packet;

import java.util.ArrayList;
import java.util.List;
import org.jivesoftware.smack.packet.IQ;
import org.jivesoftware.smack.packet.PacketExtension;
import org.jivesoftware.smackx.commands.AdHocCommand;
import org.jivesoftware.smackx.commands.AdHocCommandNote;
import org.jivesoftware.smackx.packet.DataForm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdHocCommandData
extends IQ {
    private String id;
    private String name;
    private String node;
    private String sessionID;
    private List<AdHocCommandNote> notes = new ArrayList<AdHocCommandNote>();
    private DataForm form;
    private AdHocCommand.Action action;
    private AdHocCommand.Status status;
    private ArrayList<AdHocCommand.Action> actions = new ArrayList();
    private AdHocCommand.Action executeAction;
    private String lang;

    public String getChildElementXML() {
        StringBuilder buf = new StringBuilder();
        buf.append("<command xmlns=\"http://jabber.org/protocol/commands\"");
        buf.append(" node=\"").append(this.node).append("\"");
        if (this.sessionID != null && !this.sessionID.equals("")) {
            buf.append(" sessionid=\"").append(this.sessionID).append("\"");
        }
        if (this.status != null) {
            buf.append(" status=\"").append((Object)this.status).append("\"");
        }
        if (this.action != null) {
            buf.append(" action=\"").append((Object)this.action).append("\"");
        }
        if (this.lang != null && !this.lang.equals("")) {
            buf.append(" lang=\"").append(this.lang).append("\"");
        }
        buf.append(">");
        if (this.getType() == IQ.Type.RESULT) {
            buf.append("<actions");
            if (this.executeAction != null) {
                buf.append(" execute=\"").append((Object)this.executeAction).append("\"");
            }
            if (this.actions.size() == 0) {
                buf.append("/>");
            } else {
                buf.append(">");
                for (AdHocCommand.Action action : this.actions) {
                    buf.append("<").append((Object)action).append("/>");
                }
                buf.append("</actions>");
            }
        }
        if (this.form != null) {
            buf.append(this.form.toXML());
        }
        for (AdHocCommandNote note : this.notes) {
            buf.append("<note type=\"").append(note.getType().toString()).append("\">");
            buf.append(note.getValue());
            buf.append("</note>");
        }
        buf.append("</command>");
        return buf.toString();
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public List<AdHocCommandNote> getNotes() {
        return this.notes;
    }

    public void addNote(AdHocCommandNote note) {
        this.notes.add(note);
    }

    public void remveNote(AdHocCommandNote note) {
        this.notes.remove(note);
    }

    public DataForm getForm() {
        return this.form;
    }

    public void setForm(DataForm form) {
        this.form = form;
    }

    public AdHocCommand.Action getAction() {
        return this.action;
    }

    public void setAction(AdHocCommand.Action action) {
        this.action = action;
    }

    public AdHocCommand.Status getStatus() {
        return this.status;
    }

    public void setStatus(AdHocCommand.Status status) {
        this.status = status;
    }

    public List<AdHocCommand.Action> getActions() {
        return this.actions;
    }

    public void addAction(AdHocCommand.Action action) {
        this.actions.add(action);
    }

    public void setExecuteAction(AdHocCommand.Action executeAction) {
        this.executeAction = executeAction;
    }

    public AdHocCommand.Action getExecuteAction() {
        return this.executeAction;
    }

    public void setSessionID(String sessionID) {
        this.sessionID = sessionID;
    }

    public String getSessionID() {
        return this.sessionID;
    }

    public static class SpecificError
    implements PacketExtension {
        public static final String namespace = "http://jabber.org/protocol/commands";
        public AdHocCommand.SpecificErrorCondition condition;

        public SpecificError(AdHocCommand.SpecificErrorCondition condition) {
            this.condition = condition;
        }

        public String getElementName() {
            return this.condition.toString();
        }

        public String getNamespace() {
            return namespace;
        }

        public AdHocCommand.SpecificErrorCondition getCondition() {
            return this.condition;
        }

        public String toXML() {
            StringBuilder buf = new StringBuilder();
            buf.append("<").append(this.getElementName());
            buf.append(" xmlns=\"").append(this.getNamespace()).append("\"/>");
            return buf.toString();
        }
    }
}

