/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.ComplexExplanation;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Similarity;
import org.apache.lucene.search.Weight;
import org.apache.solr.search.SolrIndexReader;
import org.apache.solr.search.function.DocValues;
import org.apache.solr.search.function.ValueSource;

class SpatialDistanceQuery
extends Query {
    String origField;
    ValueSource latSource;
    ValueSource lonSource;
    double lonMin;
    double lonMax;
    double lon2Min;
    double lon2Max;
    double latMin;
    double latMax;
    boolean lon2;
    boolean calcDist;
    double latCenter;
    double lonCenter;
    double dist;
    double planetRadius;

    SpatialDistanceQuery() {
    }

    public Query rewrite(IndexReader reader) throws IOException {
        return this;
    }

    public void extractTerms(Set terms) {
    }

    public Weight createWeight(Searcher searcher) throws IOException {
        return new SpatialWeight(searcher);
    }

    public String toString(String field) {
        float boost = this.getBoost();
        return ((double)boost != 1.0 ? "(" : "") + "geofilt(latlonSource=" + this.origField + "(" + this.latSource + "," + this.lonSource + ")" + ",latCenter=" + this.latCenter + ",lonCenter=" + this.lonCenter + ",dist=" + this.dist + ",latMin=" + this.latMin + ",latMax=" + this.latMax + ",lonMin=" + this.lonMin + ",lonMax" + this.lonMax + ",lon2Min=" + this.lon2Min + ",lon2Max" + this.lon2Max + ",calcDist=" + this.calcDist + ",planetRadius=" + this.planetRadius + ")" + ((double)boost == 1.0 ? "" : ")^" + boost);
    }

    public boolean equals(Object o) {
        if (SpatialDistanceQuery.class != o.getClass()) {
            return false;
        }
        SpatialDistanceQuery other = (SpatialDistanceQuery)((Object)o);
        return this.latCenter == other.latCenter && this.lonCenter == other.lonCenter && this.latMin == other.latMin && this.latMax == other.latMax && this.lonMin == other.lonMin && this.lonMax == other.lonMax && this.lon2Min == other.lon2Min && this.lon2Max == other.lon2Max && this.dist == other.dist && this.planetRadius == other.planetRadius && this.calcDist == other.calcDist && this.lonSource.equals(other.lonSource) && this.latSource.equals(other.latSource) && this.getBoost() == other.getBoost();
    }

    public int hashCode() {
        long hash = Double.doubleToLongBits(this.latCenter);
        hash = hash * 31L + Double.doubleToLongBits(this.lonMin);
        return (int)(hash >> (int)(32L + hash));
    }

    protected class SpatialScorer
    extends Scorer {
        final IndexReader reader;
        final SpatialWeight weight;
        final int maxDoc;
        final float qWeight;
        int doc;
        final DocValues latVals;
        final DocValues lonVals;
        final double lonMin;
        final double lonMax;
        final double lon2Min;
        final double lon2Max;
        final double latMin;
        final double latMax;
        final boolean lon2;
        final boolean calcDist;
        final double latCenterRad;
        final double lonCenterRad;
        final double latCenterRad_cos;
        final double dist;
        final double planetRadius;
        int lastDistDoc;
        double lastDist;

        public SpatialScorer(Similarity similarity, IndexReader reader, SpatialWeight w) throws IOException {
            super(similarity, (Weight)w);
            this.doc = -1;
            this.weight = w;
            this.qWeight = w.getValue();
            this.reader = reader;
            this.maxDoc = reader.maxDoc();
            this.latVals = SpatialDistanceQuery.this.latSource.getValues(this.weight.latContext, reader);
            this.lonVals = SpatialDistanceQuery.this.lonSource.getValues(this.weight.lonContext, reader);
            this.lonMin = SpatialDistanceQuery.this.lonMin;
            this.lonMax = SpatialDistanceQuery.this.lonMax;
            this.lon2Min = SpatialDistanceQuery.this.lon2Min;
            this.lon2Max = SpatialDistanceQuery.this.lon2Max;
            this.latMin = SpatialDistanceQuery.this.latMin;
            this.latMax = SpatialDistanceQuery.this.latMax;
            this.lon2 = SpatialDistanceQuery.this.lon2;
            this.calcDist = SpatialDistanceQuery.this.calcDist;
            this.latCenterRad = SpatialDistanceQuery.this.latCenter * (Math.PI / 180);
            this.lonCenterRad = SpatialDistanceQuery.this.lonCenter * (Math.PI / 180);
            this.latCenterRad_cos = this.calcDist ? Math.cos(this.latCenterRad) : 0.0;
            this.dist = SpatialDistanceQuery.this.dist;
            this.planetRadius = SpatialDistanceQuery.this.planetRadius;
        }

        boolean match() {
            double lon = this.lonVals.doubleVal(this.doc);
            if (!(lon >= this.lonMin && lon <= this.lonMax || this.lon2 && lon >= this.lon2Min && lon <= this.lon2Max)) {
                return false;
            }
            double lat = this.latVals.doubleVal(this.doc);
            if (!(lat >= this.latMin) || !(lat <= this.latMax)) {
                return false;
            }
            if (!this.calcDist) {
                return true;
            }
            return this.dist(lat, lon) <= this.dist;
        }

        double dist(double lat, double lon) {
            double latRad = lat * (Math.PI / 180);
            double lonRad = lon * (Math.PI / 180);
            double diffX = this.latCenterRad - latRad;
            double diffY = this.lonCenterRad - lonRad;
            double hsinX = Math.sin(diffX * 0.5);
            double hsinY = Math.sin(diffY * 0.5);
            double h = hsinX * hsinX + this.latCenterRad_cos * Math.cos(latRad) * hsinY * hsinY;
            double result = this.planetRadius * 2.0 * Math.atan2(Math.sqrt(h), Math.sqrt(1.0 - h));
            this.lastDistDoc = this.doc;
            this.lastDist = result;
            return result;
        }

        public int docID() {
            return this.doc;
        }

        public int nextDoc() throws IOException {
            do {
                ++this.doc;
                if (this.doc < this.maxDoc) continue;
                this.doc = Integer.MAX_VALUE;
                return Integer.MAX_VALUE;
            } while (this.reader.isDeleted(this.doc) || !this.match());
            return this.doc;
        }

        public int advance(int target) throws IOException {
            this.doc = target - 1;
            return this.nextDoc();
        }

        public float score() throws IOException {
            double dist = this.doc == this.lastDistDoc ? this.lastDist : this.dist(this.latVals.doubleVal(this.doc), this.lonVals.doubleVal(this.doc));
            return (float)(dist * (double)this.qWeight);
        }

        public Explanation explain(int doc) throws IOException {
            this.advance(doc);
            boolean matched = this.doc == doc;
            this.doc = doc;
            float sc = matched ? this.score() : 0.0f;
            double dist = this.dist(this.latVals.doubleVal(doc), this.lonVals.doubleVal(doc));
            String description = SpatialDistanceQuery.this.toString();
            ComplexExplanation result = new ComplexExplanation(this.doc == doc, sc, description + " product of:");
            result.addDetail(new Explanation((float)dist, "hsin(" + this.latVals.doubleVal(doc) + "," + this.lonVals.doubleVal(doc)));
            result.addDetail(new Explanation(SpatialDistanceQuery.this.getBoost(), "boost"));
            result.addDetail(new Explanation(this.weight.queryNorm, "queryNorm"));
            return result;
        }
    }

    protected class SpatialWeight
    extends Weight {
        protected Searcher searcher;
        protected float queryNorm;
        protected float queryWeight;
        protected Map latContext;
        protected Map lonContext;

        public SpatialWeight(Searcher searcher) throws IOException {
            this.searcher = searcher;
            SpatialDistanceQuery spatialDistanceQuery2 = SpatialDistanceQuery.this;
            this.latContext = spatialDistanceQuery2.latSource.newContext();
            SpatialDistanceQuery spatialDistanceQuery3 = SpatialDistanceQuery.this;
            this.lonContext = spatialDistanceQuery3.lonSource.newContext();
            SpatialDistanceQuery.this.latSource.createWeight(this.latContext, searcher);
            SpatialDistanceQuery.this.lonSource.createWeight(this.lonContext, searcher);
        }

        public Query getQuery() {
            return SpatialDistanceQuery.this;
        }

        public float getValue() {
            return this.queryWeight;
        }

        public float sumOfSquaredWeights() throws IOException {
            this.queryWeight = SpatialDistanceQuery.this.getBoost();
            return this.queryWeight * this.queryWeight;
        }

        public void normalize(float norm) {
            this.queryNorm = norm;
            this.queryWeight *= this.queryNorm;
        }

        public Scorer scorer(IndexReader reader, boolean scoreDocsInOrder, boolean topScorer) throws IOException {
            return new SpatialScorer(SpatialDistanceQuery.this.getSimilarity(this.searcher), reader, this);
        }

        public Explanation explain(IndexReader reader, int doc) throws IOException {
            SolrIndexReader topReader = (SolrIndexReader)reader;
            SolrIndexReader[] subReaders = topReader.getLeafReaders();
            int[] offsets = topReader.getLeafOffsets();
            int readerPos = SolrIndexReader.readerIndex(doc, offsets);
            int readerBase = offsets[readerPos];
            return ((SpatialScorer)this.scorer((IndexReader)subReaders[readerPos], true, true)).explain(doc - readerBase);
        }
    }
}

