/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.component;

import java.util.HashMap;
import java.util.Map;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.common.util.SimpleOrderedMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsValues {
    private static final String FACETS = "facets";
    double min;
    double max;
    double sum;
    double sumOfSquares;
    long count;
    long missing;
    public Map<String, Map<String, StatsValues>> facets;

    public StatsValues() {
        this.reset();
    }

    public void accumulate(NamedList stv) {
        this.min = Math.min(this.min, (Double)stv.get("min"));
        this.max = Math.max(this.max, (Double)stv.get("max"));
        this.sum += ((Double)stv.get("sum")).doubleValue();
        this.count += ((Long)stv.get("count")).longValue();
        this.missing += ((Long)stv.get("missing")).longValue();
        this.sumOfSquares += ((Double)stv.get("sumOfSquares")).doubleValue();
        NamedList f = (NamedList)stv.get(FACETS);
        if (f != null) {
            if (this.facets == null) {
                this.facets = new HashMap<String, Map<String, StatsValues>>();
            }
            for (int i = 0; i < f.size(); ++i) {
                String field = f.getName(i);
                NamedList vals = (NamedList)f.getVal(i);
                Map<String, StatsValues> addTo = this.facets.get(field);
                if (addTo == null) {
                    addTo = new HashMap<String, StatsValues>();
                    this.facets.put(field, addTo);
                }
                for (int j = 0; j < vals.size(); ++j) {
                    String val = vals.getName(j);
                    StatsValues vvals = addTo.get(val);
                    if (vvals == null) {
                        vvals = new StatsValues();
                        addTo.put(val, vvals);
                    }
                    vvals.accumulate((NamedList)vals.getVal(j));
                }
            }
        }
    }

    public void accumulate(double v) {
        this.sumOfSquares += v * v;
        this.min = Math.min(this.min, v);
        this.max = Math.max(this.max, v);
        this.sum += v;
        ++this.count;
    }

    public void accumulate(double v, int c) {
        this.sumOfSquares += v * v * (double)c;
        this.min = Math.min(this.min, v);
        this.max = Math.max(this.max, v);
        this.sum += v * (double)c;
        this.count += (long)c;
    }

    public void addMissing(int c) {
        this.missing += (long)c;
    }

    public double getAverage() {
        return this.sum / (double)this.count;
    }

    public double getStandardDeviation() {
        if ((double)this.count <= 1.0) {
            return 0.0;
        }
        return Math.sqrt(((double)this.count * this.sumOfSquares - this.sum * this.sum) / ((double)this.count * ((double)this.count - 1.0)));
    }

    public long getCount() {
        return this.count;
    }

    public void reset() {
        this.min = Double.MAX_VALUE;
        this.max = -1.7976931348623157E308;
        this.missing = 0L;
        this.count = 0L;
        this.sum = 0L;
        this.sumOfSquares = 0.0;
        this.facets = null;
    }

    public NamedList<?> getStatsValues() {
        SimpleOrderedMap res = new SimpleOrderedMap();
        res.add("min", (Object)this.min);
        res.add("max", (Object)this.max);
        res.add("sum", (Object)this.sum);
        res.add("count", (Object)this.count);
        res.add("missing", (Object)this.missing);
        res.add("sumOfSquares", (Object)this.sumOfSquares);
        res.add("mean", (Object)this.getAverage());
        res.add("stddev", (Object)this.getStandardDeviation());
        if (this.facets != null && this.facets.size() > 0) {
            SimpleOrderedMap nl = new SimpleOrderedMap();
            for (Map.Entry<String, Map<String, StatsValues>> entry : this.facets.entrySet()) {
                SimpleOrderedMap nl2 = new SimpleOrderedMap();
                nl.add(entry.getKey(), (Object)nl2);
                for (Map.Entry<String, StatsValues> e2 : entry.getValue().entrySet()) {
                    nl2.add(e2.getKey(), e2.getValue().getStatsValues());
                }
            }
            res.add(FACETS, (Object)nl);
        }
        return res;
    }
}

