/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geohash;

import java.util.HashMap;
import java.util.Map;

public class GeoHashUtils {
    private static final char[] BASE_32 = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final Map<Character, Integer> DECODE_MAP = new HashMap<Character, Integer>();
    private static final int PRECISION = 12;
    private static final int[] BITS = new int[]{16, 8, 4, 2, 1};

    private GeoHashUtils() {
    }

    public static String encode(double latitude, double longitude) {
        double[] latInterval = new double[]{-90.0, 90.0};
        double[] lngInterval = new double[]{-180.0, 180.0};
        StringBuilder geohash = new StringBuilder();
        boolean isEven = true;
        int bit = 0;
        int ch = 0;
        while (geohash.length() < 12) {
            double mid = 0.0;
            if (isEven) {
                mid = (lngInterval[0] + lngInterval[1]) / 2.0;
                if (longitude > mid) {
                    ch |= BITS[bit];
                    lngInterval[0] = mid;
                } else {
                    lngInterval[1] = mid;
                }
            } else {
                mid = (latInterval[0] + latInterval[1]) / 2.0;
                if (latitude > mid) {
                    ch |= BITS[bit];
                    latInterval[0] = mid;
                } else {
                    latInterval[1] = mid;
                }
            }
            boolean bl = isEven = !isEven;
            if (bit < 4) {
                ++bit;
                continue;
            }
            geohash.append(BASE_32[ch]);
            bit = 0;
            ch = 0;
        }
        return geohash.toString();
    }

    public static double[] decode(String geohash) {
        double[] latInterval = new double[]{-90.0, 90.0};
        double[] lngInterval = new double[]{-180.0, 180.0};
        boolean isEven = true;
        for (int i = 0; i < geohash.length(); ++i) {
            int cd = DECODE_MAP.get(Character.valueOf(geohash.charAt(i)));
            for (int mask : BITS) {
                if (isEven) {
                    if ((cd & mask) != 0) {
                        lngInterval[0] = (lngInterval[0] + lngInterval[1]) / 2.0;
                    } else {
                        lngInterval[1] = (lngInterval[0] + lngInterval[1]) / 2.0;
                    }
                } else if ((cd & mask) != 0) {
                    latInterval[0] = (latInterval[0] + latInterval[1]) / 2.0;
                } else {
                    latInterval[1] = (latInterval[0] + latInterval[1]) / 2.0;
                }
                isEven = !isEven;
            }
        }
        double latitude = (latInterval[0] + latInterval[1]) / 2.0;
        double longitude = (lngInterval[0] + lngInterval[1]) / 2.0;
        return new double[]{latitude, longitude};
    }

    static {
        for (int i = 0; i < BASE_32.length; ++i) {
            DECODE_MAP.put(Character.valueOf(BASE_32[i]), i);
        }
    }
}

