/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.search;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.params.DefaultSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.search.FunctionQParserPlugin;
import org.apache.solr.search.QParser;
import org.apache.solr.search.QueryParsing;
import org.apache.solr.util.SolrPluginUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisMaxQParser
extends QParser {
    private static String IMPOSSIBLE_FIELD_NAME = "\ufffc\ufffc\ufffc";
    protected Map<String, Float> queryFields;
    protected Query parsedUserQuery;
    protected String[] boostParams;
    protected List<Query> boostQueries;
    protected Query altUserQuery;
    protected QParser altQParser;

    public DisMaxQParser(String qstr, SolrParams localParams, SolrParams params, SolrQueryRequest req) {
        super(qstr, localParams, params, req);
    }

    @Override
    public Query parse() throws ParseException {
        SolrParams solrParams = this.localParams == null ? this.params : new DefaultSolrParams(this.localParams, this.params);
        this.queryFields = SolrPluginUtils.parseFieldBoosts(solrParams.getParams("qf"));
        if (0 == this.queryFields.size()) {
            this.queryFields.put(this.req.getSchema().getDefaultSearchFieldName(), Float.valueOf(1.0f));
        }
        BooleanQuery query = new BooleanQuery(true);
        this.addMainQuery(query, solrParams);
        this.addBoostQuery(query, solrParams);
        this.addBoostFunctions(query, solrParams);
        return query;
    }

    protected void addBoostFunctions(BooleanQuery query, SolrParams solrParams) throws ParseException {
        String[] boostFuncs = solrParams.getParams("bf");
        if (null != boostFuncs && 0 != boostFuncs.length) {
            for (String boostFunc : boostFuncs) {
                if (null == boostFunc || "".equals(boostFunc)) continue;
                Map<String, Float> ff = SolrPluginUtils.parseFieldBoosts(boostFunc);
                for (String f : ff.keySet()) {
                    Query fq = this.subQuery(f, FunctionQParserPlugin.NAME).parse();
                    Float b = ff.get(f);
                    if (null != b) {
                        fq.setBoost(b.floatValue());
                    }
                    query.add(fq, BooleanClause.Occur.SHOULD);
                }
            }
        }
    }

    protected void addBoostQuery(BooleanQuery query, SolrParams solrParams) throws ParseException {
        block8: {
            this.boostParams = solrParams.getParams("bq");
            this.boostQueries = null;
            if (this.boostParams != null && this.boostParams.length > 0) {
                this.boostQueries = new ArrayList<Query>();
                for (String qs : this.boostParams) {
                    if (qs.trim().length() == 0) continue;
                    Query q = this.subQuery(qs, null).parse();
                    this.boostQueries.add(q);
                }
            }
            if (null == this.boostQueries) break block8;
            if (1 == this.boostQueries.size() && 1 == this.boostParams.length) {
                Query f = this.boostQueries.get(0);
                if (1.0f == f.getBoost() && f instanceof BooleanQuery) {
                    for (BooleanClause c : ((BooleanQuery)f).clauses()) {
                        query.add(c);
                    }
                } else {
                    query.add(f, BooleanClause.Occur.SHOULD);
                }
            } else {
                for (Query f : this.boostQueries) {
                    query.add(f, BooleanClause.Occur.SHOULD);
                }
            }
        }
    }

    protected void addMainQuery(BooleanQuery query, SolrParams solrParams) throws ParseException {
        Map<String, Float> phraseFields = SolrPluginUtils.parseFieldBoosts(solrParams.getParams("pf"));
        float tiebreaker = solrParams.getFloat("tie", 0.0f);
        SolrPluginUtils.DisjunctionMaxQueryParser up = this.getParser(this.queryFields, "qs", solrParams, tiebreaker);
        SolrPluginUtils.DisjunctionMaxQueryParser pp = this.getParser(phraseFields, "ps", solrParams, tiebreaker);
        this.parsedUserQuery = null;
        String userQuery = this.getString();
        this.altUserQuery = null;
        if (userQuery == null || userQuery.trim().length() < 1) {
            this.altUserQuery = this.getAlternateUserQuery(solrParams);
            query.add(this.altUserQuery, BooleanClause.Occur.MUST);
        } else {
            userQuery = ((Object)SolrPluginUtils.partialEscape(SolrPluginUtils.stripUnbalancedQuotes(userQuery))).toString();
            userQuery = ((Object)SolrPluginUtils.stripIllegalOperators(userQuery)).toString();
            this.parsedUserQuery = this.getUserQuery(userQuery, up, solrParams);
            query.add(this.parsedUserQuery, BooleanClause.Occur.MUST);
            Query phrase = this.getPhraseQuery(userQuery, pp);
            if (null != phrase) {
                query.add(phrase, BooleanClause.Occur.SHOULD);
            }
        }
    }

    protected Query getAlternateUserQuery(SolrParams solrParams) throws ParseException {
        String altQ = solrParams.get("q.alt");
        if (altQ != null) {
            QParser altQParser = this.subQuery(altQ, null);
            return altQParser.parse();
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "missing query string");
    }

    protected Query getPhraseQuery(String userQuery, SolrPluginUtils.DisjunctionMaxQueryParser pp) throws ParseException {
        String userPhraseQuery = userQuery.replace("\"", "");
        return pp.parse("\"" + userPhraseQuery + "\"");
    }

    protected Query getUserQuery(String userQuery, SolrPluginUtils.DisjunctionMaxQueryParser up, SolrParams solrParams) throws ParseException {
        Query dis;
        String minShouldMatch = solrParams.get("mm", "100%");
        Query query = dis = up.parse(userQuery);
        if (dis instanceof BooleanQuery) {
            BooleanQuery t = new BooleanQuery();
            SolrPluginUtils.flattenBooleanQuery(t, (BooleanQuery)dis);
            SolrPluginUtils.setMinShouldMatch(t, minShouldMatch);
            query = t;
        }
        return query;
    }

    protected SolrPluginUtils.DisjunctionMaxQueryParser getParser(Map<String, Float> fields, String paramName, SolrParams solrParams, float tiebreaker) {
        int slop = solrParams.getInt(paramName, 0);
        SolrPluginUtils.DisjunctionMaxQueryParser parser = new SolrPluginUtils.DisjunctionMaxQueryParser(this, IMPOSSIBLE_FIELD_NAME);
        parser.addAlias(IMPOSSIBLE_FIELD_NAME, tiebreaker, fields);
        parser.setPhraseSlop(slop);
        return parser;
    }

    @Override
    public String[] getDefaultHighlightFields() {
        return this.queryFields.keySet().toArray(new String[this.queryFields.keySet().size()]);
    }

    @Override
    public Query getHighlightQuery() throws ParseException {
        return this.parsedUserQuery == null ? this.altUserQuery : this.parsedUserQuery;
    }

    @Override
    public void addDebugInfo(NamedList<Object> debugInfo) {
        super.addDebugInfo(debugInfo);
        debugInfo.add("altquerystring", (Object)this.altUserQuery);
        if (null != this.boostQueries) {
            debugInfo.add("boost_queries", (Object)this.boostParams);
            debugInfo.add("parsed_boost_queries", QueryParsing.toString(this.boostQueries, this.req.getSchema()));
        }
        debugInfo.add("boostfuncs", (Object)this.req.getParams().getParams("bf"));
    }
}

