/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.schema;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.search.SortField;
import org.apache.solr.response.TextResponseWriter;
import org.apache.solr.response.XMLWriter;
import org.apache.solr.schema.FieldType;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.schema.SortableIntFieldSource;
import org.apache.solr.search.QParser;
import org.apache.solr.search.function.ValueSource;
import org.apache.solr.util.NumberUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SortableIntField
extends FieldType {
    @Override
    protected void init(IndexSchema schema, Map<String, String> args) {
    }

    @Override
    public SortField getSortField(SchemaField field, boolean reverse) {
        return this.getStringSort(field, reverse);
    }

    @Override
    public ValueSource getValueSource(SchemaField field, QParser qparser) {
        field.checkFieldCacheSource(qparser);
        return new SortableIntFieldSource(field.name);
    }

    @Override
    public String toInternal(String val) {
        return NumberUtils.int2sortableStr(val);
    }

    @Override
    public String toExternal(Fieldable f) {
        return this.indexedToReadable(f.stringValue());
    }

    @Override
    public String indexedToReadable(String indexedForm) {
        return NumberUtils.SortableStr2int(indexedForm);
    }

    @Override
    public Integer toObject(Fieldable f) {
        return NumberUtils.SortableStr2int(f.stringValue(), 0, 3);
    }

    @Override
    public void write(XMLWriter xmlWriter, String name, Fieldable f) throws IOException {
        String sval = f.stringValue();
        xmlWriter.writeInt(name, NumberUtils.SortableStr2int(sval, 0, sval.length()));
    }

    @Override
    public void write(TextResponseWriter writer, String name, Fieldable f) throws IOException {
        String sval = f.stringValue();
        writer.writeInt(name, NumberUtils.SortableStr2int(sval, 0, sval.length()));
    }
}

