/*
 * #%L
 * Wao :: Web Interface
 * %%
 * Copyright (C) 2009 - 2010 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */
package fr.ifremer.wao.ui.data;

import fr.ifremer.wao.ui.pages.KmlLoader;
import fr.ifremer.wao.ui.services.KmlLoaderStrategy;
import org.apache.commons.io.FileUtils;
import org.apache.tapestry5.StreamResponse;
import org.apache.tapestry5.services.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

/**
 * StreamResponse for Kml files.
 * <p />
 * Created: 6 juil. 2010
 *
 * @author fdesbois <fdesbois@codelutin.com>
 * @version $Id$
 * @see KmlLoaderStrategy
 * @see KmlLoader
 */
public class KmlStreamResponse implements StreamResponse {

    private static final Logger logger =
            LoggerFactory.getLogger(KmlStreamResponse.class);

    protected InputStream stream;

    protected int length;

    public KmlStreamResponse(InputStream stream) throws IOException {
        this.stream = stream;
        this.length = stream.available();
    }
        
    @Override
    public String getContentType() {
        // official mime-type for Kml file
        return "application/vnd.google-earth.kml+xml";
    }

    @Override
    public InputStream getStream() throws IOException {
        return stream;
    }

    @Override
    public void prepareResponse(Response response) {
        // need to specify the Content-Length to avoid auto chunked Transfer-Encoding
        response.setHeader("Content-Length", String.valueOf(length));
    }
}
