/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.wao.ui.components;

import fr.ifremer.wao.WaoBusinessException;
import fr.ifremer.wao.WaoException;
import fr.ifremer.wao.bean.ImportResults;
import fr.ifremer.wao.ui.data.ErrorReport;
import fr.ifremer.wao.ui.data.ImportEngine;
import fr.ifremer.wao.ui.services.WaoManager;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.GZIPInputStream;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.annotations.Log;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.Property;
import org.apache.tapestry5.ioc.Messages;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.upload.services.UploadedFile;
import org.slf4j.Logger;

public class CsvImport {
    protected static final String EVENT_IMPORTED = "imported";
    protected static final String MIMETYPE_GZIP = "application/x-gzip";
    protected static final String MIMETYPE_CSV = "text/csv";
    @Parameter(required=true, defaultPrefix="literal")
    @Property
    private String label;
    @Parameter(required=true)
    private ImportEngine engine;
    @Inject
    private WaoManager manager;
    @Inject
    private ComponentResources resources;
    @Inject
    private Messages messages;
    @Inject
    private Logger logger;
    @Property
    private UploadedFile csvFile;

    @Log
    void onSuccessFromImportCsv() {
        ErrorReport errorReport = new ErrorReport();
        try {
            ImportResults result = this.engine.execute(this.getStream());
            if (result != null) {
                errorReport.addInfo(result.getNbRowsImported() + " lignes import\u00e9es dont " + result.getNbRowsImportedNew() + " nouvelles,  " + result.getNbRowsRefused() + " refus\u00e9es.");
                List errors = result.getErrors();
                errorReport.addError(errors.toArray(new String[errors.size()]));
            }
        }
        catch (WaoBusinessException eee) {
            errorReport.addError(new String[]{eee.getMessage()});
        }
        catch (WaoException eee) {
            String[] errors = this.manager.getErrorMessages(eee, this.messages, this.logger);
            errorReport.addError(errors);
        }
        catch (IOException eee) {
            errorReport.addError(new String[]{"Erreur de format du fichier ! Seul les formats [csv, gz] sont autoris\u00e9s."});
            this.logger.error("Error on import csv file", (Throwable)eee);
        }
        this.resources.triggerEvent(EVENT_IMPORTED, new Object[]{errorReport}, null);
    }

    protected InputStream getStream() throws IOException {
        InputStream input = this.csvFile.getStream();
        String contentType = this.csvFile.getContentType();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Content type : " + this.csvFile.getContentType());
        }
        if (contentType.equals(MIMETYPE_GZIP)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Gzip file");
            }
            input = new GZIPInputStream(input);
        } else if (!contentType.equals(MIMETYPE_CSV)) {
            throw new IOException("unsupported format : " + contentType);
        }
        return input;
    }
}

