/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.cruise.actions;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.TuttiEntity;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrder;
import fr.ifremer.tutti.persistence.entities.referential.GearWithOriginalRankOrders;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIHandler;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.TuttiUIUtil;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.awt.Component;
import java.util.Collection;
import java.util.HashSet;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.apache.commons.lang3.ObjectUtils;
import org.nuiton.i18n.I18n;

public class SaveCruiseAction
extends LongActionSupport<EditCruiseUIModel, EditCruiseUI, EditCruiseUIHandler> {
    protected PersistenceService persistenceService = this.getContext().getPersistenceService();
    protected boolean updateVessel;
    protected boolean updateGear;

    public SaveCruiseAction(EditCruiseUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean result = super.prepareAction();
        Cruise bean = (Cruise)((EditCruiseUIModel)this.getModel()).toEntity();
        if (!TuttiEntities.isNew((TuttiEntity)bean)) {
            Cruise oldCruise = this.persistenceService.getCruise(bean.getIdAsInt());
            if (ObjectUtils.notEqual((Object)oldCruise.getVessel(), (Object)bean.getVessel())) {
                String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editCruise.action.save.vesselChanged.message", (Object[])new Object[0]), I18n.t((String)"tutti.editCruise.action.save.vesselChanged.help", (Object[])new Object[0]));
                int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.editCruise.action.save.vesselChanged.title", (Object[])new Object[0]), 2, 2);
                this.updateVessel = answer == 0;
                result = this.updateVessel;
            }
            if (result && ObjectUtils.notEqual((Object)oldCruise.getGear(), (Object)bean.getGear())) {
                HashSet gearsToRemove = Sets.newHashSet((Iterable)oldCruise.getGear());
                for (GearWithOriginalRankOrder gearWithOriginalRankOrder : bean.getGear()) {
                    GearWithOriginalRankOrder g = GearWithOriginalRankOrders.newGearWithOriginalRankOrder((Integer)gearWithOriginalRankOrder.getIdAsInt(), (Short)gearWithOriginalRankOrder.getOriginalRankOrder());
                    gearsToRemove.remove(g);
                }
                boolean obsoleteGearIsUsed = this.persistenceService.isOperationUseGears(bean.getIdAsInt(), (Collection)gearsToRemove);
                if (obsoleteGearIsUsed) {
                    String message = I18n.t((String)"tutti.persistence.cruise.gearUsedInOperations.error", (Object[])new Object[0]);
                    this.displayWarningMessage(I18n.t((String)"tutti.editCruise.action.save.gearChanged.title", (Object[])new Object[0]), "<html><body>" + message + "</body></html>");
                    result = false;
                } else {
                    String htmlMessage = String.format("<html>%s<hr/><br/>%s</html>", I18n.t((String)"tutti.editCruise.action.save.gearChanged.message", (Object[])new Object[0]), I18n.t((String)"tutti.editCruise.action.save.gearChanged.help", (Object[])new Object[0]));
                    int answer = JOptionPane.showConfirmDialog((Component)this.getContext().getActionUI(), htmlMessage, I18n.t((String)"tutti.editCruise.action.save.gearChanged.title", (Object[])new Object[0]), 2, 2);
                    this.updateGear = answer == 0;
                    result = this.updateGear;
                }
            }
        }
        return result;
    }

    @Override
    public void doAction() throws Exception {
        Cruise saved;
        TuttiUIContext context = this.getContext();
        EditCruiseUIModel model = (EditCruiseUIModel)this.getModel();
        Cruise bean = (Cruise)model.toEntity();
        boolean createCruise = TuttiEntities.isNew((TuttiEntity)bean);
        if (createCruise) {
            saved = this.persistenceService.createCruise(bean);
            model.setId(saved.getId());
            this.sendMessage(I18n.t((String)"tutti.flash.info.cruiseCreated", (Object[])new Object[]{bean.getName()}));
        } else {
            saved = this.persistenceService.saveCruise(bean, this.updateVessel, this.updateGear);
            this.sendMessage(I18n.t((String)"tutti.flash.info.cruiseSaved", (Object[])new Object[]{bean.getName()}));
        }
        context.setProgramId(saved.getProgram().getId());
        context.setCruiseId(saved.getIdAsInt());
        if (!createCruise) {
            this.getDataContext().reloadCruise();
        }
        this.getDataContext().closeCruiseCache();
        for (GearWithOriginalRankOrder gear : model.getGear()) {
            gear.setOriginalRankOrder(gear.getRankOrder());
        }
        model.setSynchronizationStatus(saved.getSynchronizationStatus());
        model.setModify(false);
    }

    public void postSuccessAction() {
        this.getContext().getMainUI().getHandler().setBodyTitle(EditCruiseUIHandler.getTitle(true));
        ImageIcon icon = TuttiUIUtil.getCruiseIcon((Cruise)this.getModel());
        this.getContext().getMainUI().getBody().setLeftDecoration((JComponent)new JLabel(icon));
    }
}

