/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.core.dao.data.batch.Batch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatch;
import fr.ifremer.adagio.core.dao.data.batch.CatchBatchImpl;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatch;
import fr.ifremer.adagio.core.dao.data.batch.SortingBatchImpl;
import fr.ifremer.adagio.core.dao.data.measure.QuantificationMeasurement;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperation;
import fr.ifremer.adagio.core.dao.data.operation.FishingOperationImpl;
import fr.ifremer.adagio.core.dao.referential.QualityFlag;
import fr.ifremer.adagio.core.dao.referential.QualityFlagCode;
import fr.ifremer.adagio.core.dao.referential.QualityFlagImpl;
import fr.ifremer.tutti.TuttiConfiguration;
import fr.ifremer.tutti.persistence.entities.data.CatchBatchBean;
import fr.ifremer.tutti.persistence.service.AbstractPersistenceService;
import fr.ifremer.tutti.persistence.service.AttachmentPersistenceService;
import fr.ifremer.tutti.persistence.service.CatchBatchPersistenceService;
import fr.ifremer.tutti.persistence.service.util.BatchPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.MeasurementPersistenceHelper;
import fr.ifremer.tutti.persistence.service.util.SynchronizationStatusHelper;
import fr.ifremer.tutti.persistence.service.util.tree.BatchTreeHelper;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.util.Numbers;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.FlushMode;
import org.hibernate.SQLQuery;
import org.hibernate.type.IntegerType;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="batchPersistenceService")
public class CatchBatchPersistenceServiceImpl
extends AbstractPersistenceService
implements CatchBatchPersistenceService {
    private static final Log log = LogFactory.getLog(CatchBatchPersistenceServiceImpl.class);
    @Resource(name="attachmentPersistenceService")
    protected AttachmentPersistenceService attachmentPersistenceService;
    @Resource(name="batchPersistenceHelper")
    protected BatchPersistenceHelper batchHelper;
    @Resource(name="batchTreeHelper")
    protected BatchTreeHelper batchTreeHelper;
    @Resource(name="measurementPersistenceHelper")
    protected MeasurementPersistenceHelper measurementPersistenceHelper;
    @Resource(name="synchronizationStatusHelper")
    protected SynchronizationStatusHelper synchronizationStatusHelper;

    @Override
    public boolean isFishingOperationWithCatchBatch(Integer operationId) {
        Preconditions.checkNotNull((Object)operationId);
        return this.batchHelper.isCatchBatchExistsForFishingOperation(operationId);
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.data.CatchBatch getCatchBatchFromFishingOperation(Integer fishingOperationId) {
        boolean showBatchLog;
        Preconditions.checkNotNull((Object)fishingOperationId);
        CatchBatch source = this.batchHelper.getRootCatchBatchByFishingOperationId(fishingOperationId, true);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Loaded CatchBatch: " + source.getId()));
        }
        if (showBatchLog = TuttiConfiguration.getInstance().isShowBatchLog()) {
            this.batchTreeHelper.displayCatchBatch(source);
        }
        CatchBatchBean result = new CatchBatchBean();
        this.entityToBean(source, result);
        return result;
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.data.CatchBatch createCatchBatch(fr.ifremer.tutti.persistence.entities.data.CatchBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkArgument((bean.getId() == null ? 1 : 0) != 0);
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        CatchBatch catchBatch = CatchBatch.Factory.newInstance();
        this.beanToEntity(bean, catchBatch);
        bean = this.batchHelper.createCatchBatch(bean, catchBatch);
        this.getCurrentSession().flush();
        Integer fishingOperationId = bean.getFishingOperation().getIdAsInt();
        int rowUpdated = this.queryUpdate("updateFishingOperationCatchBatch", "fishingOperationId", IntegerType.INSTANCE, fishingOperationId, "catchBatchId", IntegerType.INSTANCE, catchBatch.getId());
        if (rowUpdated == 0) {
            throw new DataIntegrityViolationException("Could not attach catch batch to the given operation : operation was not found.");
        }
        this.synchronizationStatusHelper.setDirty(bean);
        return bean;
    }

    @Override
    public fr.ifremer.tutti.persistence.entities.data.CatchBatch saveCatchBatch(fr.ifremer.tutti.persistence.entities.data.CatchBatch bean) {
        Preconditions.checkNotNull((Object)bean);
        Preconditions.checkNotNull((Object)bean.getId());
        Preconditions.checkNotNull((Object)bean.getFishingOperation());
        Preconditions.checkNotNull((Object)bean.getFishingOperation().getId());
        this.getCurrentSession().enableFetchProfile("batch-with-childs");
        this.getCurrentSession().setFlushMode(FlushMode.COMMIT);
        CatchBatch catchBatch = (CatchBatch)this.load(CatchBatchImpl.class, bean.getIdAsInt());
        if (catchBatch == null) {
            throw new DataRetrievalFailureException("Could not retrieve catch batch with id=" + bean.getId());
        }
        this.beanToEntity(bean, catchBatch);
        this.batchHelper.update(catchBatch);
        this.getCurrentSession().flush();
        this.synchronizationStatusHelper.setDirty(bean);
        return bean;
    }

    @Override
    public void deleteCatchBatch(Integer fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.batchHelper.getCatchBatchIdByFishingOperationId(fishingOperationId);
        if (catchBatchId == null) {
            throw new DataRetrievalFailureException("Could not retrieve catch batch for fishingOperation id=" + fishingOperationId);
        }
        this.batchHelper.deleteCatchBatch(fishingOperationId, catchBatchId);
    }

    @Override
    public void recomputeCatchBatchSampleRatios(Integer fishingOperationId) {
        Preconditions.checkNotNull((Object)fishingOperationId);
        Integer catchBatchId = this.batchHelper.getCatchBatchIdByFishingOperationId(fishingOperationId);
        if (catchBatchId == null) {
            throw new DataRetrievalFailureException("Could not retrieve catch batch for fishingOperation id=" + fishingOperationId);
        }
        CatchBatch catchBatch = this.batchTreeHelper.loadCatchBatch(catchBatchId);
        TreeMap<Integer, SortingBatch> indirectWeightByBatch = new TreeMap<Integer, SortingBatch>();
        HashSet<QuantificationMeasurement> quantificationMeasurements = new HashSet<QuantificationMeasurement>();
        HashSet<Integer> indirectWeightByBatchSkip = new HashSet<Integer>();
        for (Batch rootBatch : catchBatch.getChildBatchs()) {
            this.computeIndirectWeight(rootBatch, indirectWeightByBatch, indirectWeightByBatchSkip, quantificationMeasurements);
        }
        if (!indirectWeightByBatch.isEmpty()) {
            for (SortingBatch batch : indirectWeightByBatch.values()) {
                Float weight = batch.getWeight();
                Float indirectWeight = batch.getIndirectWeight();
                batch.setIndirectWeight(null);
                if (indirectWeight == null) {
                    indirectWeight = weight;
                }
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("setWeightAndSampleRatio :: %d (%s // %s)", batch.getId(), weight, indirectWeight));
                }
                SortingBatch sortingBatch = (SortingBatch)this.load(SortingBatchImpl.class, batch.getId());
                this.batchTreeHelper.setSortingSamplingRatio(sortingBatch, indirectWeight, weight);
            }
        }
        if (!quantificationMeasurements.isEmpty()) {
            if (log.isInfoEnabled()) {
                log.info((Object)("updateQuantificationMeasurementsForBatchNodes :: " + quantificationMeasurements));
            }
            for (QuantificationMeasurement quantificationMeasurement : quantificationMeasurements) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Remove quantification measurement %d on batch %d (batch is not a leaf)", quantificationMeasurement.getId(), quantificationMeasurement.getBatch().getId()));
                }
                Batch batch = quantificationMeasurement.getBatch();
                SortingBatch sortingBatch = (SortingBatch)this.load(SortingBatchImpl.class, batch.getId());
                this.measurementPersistenceHelper.removeWeightMeasurementQuantificationMeasurement((Batch)sortingBatch, quantificationMeasurement);
            }
        }
    }

    protected void entityToBean(CatchBatch source, fr.ifremer.tutti.persistence.entities.data.CatchBatch target) {
        SortingBatch unsortedBatch;
        SortingBatch horsVracBatch;
        target.setId(source.getId());
        target.setCatchTotalWeight(source.getWeight());
        target.setSynchronizationStatus(source.getSynchronizationStatus());
        SortingBatch vracBatch = this.batchTreeHelper.getVracBatch(source);
        if (vracBatch != null) {
            SortingBatch vracBenthosBatch;
            target.setCatchTotalSortedCarousselWeight(vracBatch.getWeight());
            target.setCatchTotalSortedTremisWeight(vracBatch.getWeightBeforeSampling());
            SortingBatch vracSpeciesBatch = this.batchTreeHelper.getSpeciesVracRootBatch(vracBatch);
            if (vracSpeciesBatch != null) {
                SortingBatch livingNotItemizedBatch;
                target.setSpeciesTotalSortedWeight(vracSpeciesBatch.getWeight());
                SortingBatch inertBatch = this.batchTreeHelper.getSpeciesVracInertRootBatch(vracSpeciesBatch);
                if (inertBatch != null) {
                    target.setSpeciesTotalInertWeight(inertBatch.getWeight());
                }
                if ((livingNotItemizedBatch = this.batchTreeHelper.getSpeciesVracAliveNotItemizedRootBatch(vracSpeciesBatch)) != null) {
                    target.setSpeciesTotalLivingNotItemizedWeight(livingNotItemizedBatch.getWeight());
                }
            }
            if ((vracBenthosBatch = this.batchTreeHelper.getBenthosVracRootBatch(vracBatch)) != null) {
                SortingBatch livingNotItemizedBatch;
                target.setBenthosTotalSortedWeight(vracBenthosBatch.getWeight());
                SortingBatch inertBatch = this.batchTreeHelper.getBenthosVracInertRootBatch(vracBenthosBatch);
                if (inertBatch != null) {
                    target.setBenthosTotalInertWeight(inertBatch.getWeight());
                }
                if ((livingNotItemizedBatch = this.batchTreeHelper.getBenthosVracAliveNotItemizedRootBatch(vracBenthosBatch)) != null) {
                    target.setBenthosTotalLivingNotItemizedWeight(livingNotItemizedBatch.getWeight());
                }
            }
        }
        if ((horsVracBatch = this.batchTreeHelper.getHorsVracBatch(source)) != null) {
            this.batchTreeHelper.getSpeciesHorsVracRootBatch(horsVracBatch);
            this.batchTreeHelper.getBenthosHorsVracRootBatch(horsVracBatch);
            SortingBatch marineLitterBatch = this.batchTreeHelper.getMarineLitterRootBatch(horsVracBatch);
            if (marineLitterBatch != null) {
                target.setMarineLitterTotalWeight(marineLitterBatch.getWeight());
            }
        }
        if ((unsortedBatch = this.batchTreeHelper.getRejectedBatch(source)) != null) {
            target.setCatchTotalRejectedWeight(unsortedBatch.getWeight());
        }
    }

    protected void beanToEntity(fr.ifremer.tutti.persistence.entities.data.CatchBatch source, CatchBatch target) {
        boolean needUnsorted;
        Preconditions.checkNotNull((Object)source.getFishingOperation());
        Preconditions.checkNotNull((Object)source.getFishingOperation().getId());
        Integer fishingOperationId = source.getFishingOperation().getIdAsInt();
        target.setFishingOperation((FishingOperation)this.load(FishingOperationImpl.class, fishingOperationId));
        target.setQualityFlag((QualityFlag)this.load(QualityFlagImpl.class, (Serializable)((Object)QualityFlagCode.NOTQUALIFIED.getValue())));
        target.setRankOrder(Short.valueOf((short)1));
        this.synchronizationStatusHelper.setDirty(target);
        if (source.getCatchTotalWeight() == null) {
            QuantificationMeasurement quantificationMeasurement = this.measurementPersistenceHelper.getWeightMeasurementQuantificationMeasurement((Batch)target);
            if (quantificationMeasurement != null) {
                this.measurementPersistenceHelper.removeWeightMeasurementQuantificationMeasurement((Batch)target, quantificationMeasurement);
            }
        } else {
            this.measurementPersistenceHelper.setWeightMeasurementQuantificationMeasurement((Batch)target, source.getCatchTotalWeight());
        }
        SortingBatch vracBatch = this.batchTreeHelper.getVracBatch(target);
        SortingBatch horsVracBatch = this.batchTreeHelper.getHorsVracBatch(target);
        SortingBatch horsVracSpeciesRootBatch = null;
        SortingBatch horsVracBenthosRootBatch = null;
        SortingBatch horsVracMarineLitterRootBatch = null;
        if (horsVracBatch != null) {
            horsVracSpeciesRootBatch = this.batchTreeHelper.getSpeciesHorsVracRootBatch(horsVracBatch);
            horsVracBenthosRootBatch = this.batchTreeHelper.getBenthosHorsVracRootBatch(horsVracBatch);
            horsVracMarineLitterRootBatch = this.batchTreeHelper.getMarineLitterRootBatch(horsVracBatch);
        }
        SortingBatch speciesVracBatch = null;
        SortingBatch benthosVracBatch = null;
        SortingBatch speciesVracAliveNotItemizeRootBatch = null;
        SortingBatch speciesVracInertRootBatch = null;
        SortingBatch speciesVracAliveItemizeRootBatch = null;
        SortingBatch benthosVracAliveNotItemizeRootBatch = null;
        SortingBatch benthosVracInertRootBatch = null;
        SortingBatch benthosVracAliveItemizeRootBatch = null;
        if (vracBatch != null) {
            speciesVracBatch = this.batchTreeHelper.getSpeciesVracRootBatch(vracBatch);
            if (speciesVracBatch != null) {
                speciesVracAliveNotItemizeRootBatch = this.batchTreeHelper.getSpeciesVracAliveNotItemizedRootBatch(speciesVracBatch);
                speciesVracInertRootBatch = this.batchTreeHelper.getSpeciesVracInertRootBatch(speciesVracBatch);
                speciesVracAliveItemizeRootBatch = this.batchTreeHelper.getSpeciesVracAliveItemizedRootBatch(speciesVracBatch);
            }
            if ((benthosVracBatch = this.batchTreeHelper.getBenthosVracRootBatch(vracBatch)) != null) {
                benthosVracAliveNotItemizeRootBatch = this.batchTreeHelper.getBenthosVracAliveNotItemizedRootBatch(benthosVracBatch);
                benthosVracInertRootBatch = this.batchTreeHelper.getBenthosVracInertRootBatch(benthosVracBatch);
                benthosVracAliveItemizeRootBatch = this.batchTreeHelper.getBenthosVracAliveItemizedRootBatch(benthosVracBatch);
            }
        }
        boolean needVracSpeciesAliveNotItemized = speciesVracAliveNotItemizeRootBatch != null || source.getSpeciesTotalLivingNotItemizedWeight() != null;
        boolean needVracSpeciesInert = speciesVracInertRootBatch != null || source.getSpeciesTotalInertWeight() != null;
        boolean needVracSpeciesAliveItemized = speciesVracAliveItemizeRootBatch != null;
        boolean needVracSpecies = speciesVracBatch != null || source.getSpeciesTotalSortedWeight() != null || needVracSpeciesAliveNotItemized || needVracSpeciesInert || needVracSpeciesAliveItemized;
        boolean needVracBenthosAliveNotItemized = benthosVracAliveNotItemizeRootBatch != null || source.getBenthosTotalLivingNotItemizedWeight() != null;
        boolean needVracBenthosInert = benthosVracInertRootBatch != null || source.getBenthosTotalInertWeight() != null;
        boolean needVracBenthosAliveItemized = benthosVracAliveItemizeRootBatch != null;
        boolean needVracBenthos = benthosVracBatch != null || source.getBenthosTotalSortedWeight() != null || needVracBenthosAliveNotItemized || needVracBenthosInert || needVracBenthosAliveItemized;
        boolean needVrac = vracBatch != null || source.getCatchTotalSortedCarousselWeight() != null || source.getCatchTotalSortedTremisWeight() != null || needVracSpecies || needVracBenthos;
        boolean needHorsVracSpecies = horsVracSpeciesRootBatch != null;
        boolean needHorsVracBenthos = horsVracBenthosRootBatch != null;
        boolean needHorsVracMarineLitter = horsVracMarineLitterRootBatch != null || source.getMarineLitterTotalWeight() != null;
        boolean needHorsVrac = needHorsVracSpecies || needHorsVracBenthos || needHorsVracMarineLitter;
        boolean bl = needUnsorted = this.batchTreeHelper.getRejectedBatch(target) != null || source.getCatchTotalRejectedWeight() != null;
        if (needVrac) {
            vracBatch = this.batchTreeHelper.getOrCreateVracBatch(target, source.getCatchTotalSortedCarousselWeight(), source.getCatchTotalSortedTremisWeight());
            if (needVracSpecies) {
                speciesVracBatch = this.batchTreeHelper.getOrCreateSpeciesVracRootBatch(target, vracBatch, source.getSpeciesTotalSortedWeight());
                if (needVracSpeciesAliveNotItemized) {
                    this.batchTreeHelper.getOrCreateSpeciesVracAliveNotItemizedRootBatch(target, speciesVracBatch, source.getSpeciesTotalLivingNotItemizedWeight());
                }
                if (needVracSpeciesInert) {
                    this.batchTreeHelper.getOrCreateSpeciesVracInertRootBatch(target, speciesVracBatch, source.getSpeciesTotalInertWeight());
                }
                if (needVracSpeciesAliveItemized) {
                    this.batchTreeHelper.getOrCreateSpeciesVracAliveItemizedRootBatch(target, speciesVracBatch);
                }
            }
            if (needVracBenthos) {
                benthosVracBatch = this.batchTreeHelper.getOrCreateBenthosVracRootBatch(target, vracBatch, source.getBenthosTotalSortedWeight());
                if (needVracBenthosAliveNotItemized) {
                    this.batchTreeHelper.getOrCreateBenthosVracAliveNotItemizedRootBatch(target, benthosVracBatch, source.getBenthosTotalLivingNotItemizedWeight());
                }
                if (needVracBenthosInert) {
                    this.batchTreeHelper.getOrCreateBenthosVracInertRootBatch(target, benthosVracBatch, source.getBenthosTotalInertWeight());
                }
                if (needVracBenthosAliveItemized) {
                    this.batchTreeHelper.getOrCreateBenthosVracAliveItemizedRootBatch(target, benthosVracBatch);
                }
            }
        }
        if (needHorsVrac) {
            horsVracBatch = this.batchTreeHelper.getOrCreateHorsVracBatch(target);
            if (needHorsVracSpecies) {
                this.batchTreeHelper.getOrCreateSpeciesHorsVracRootBatch(target, horsVracBatch);
            }
            if (needHorsVracBenthos) {
                this.batchTreeHelper.getOrCreateBenthosHorsVracRootBatch(target, horsVracBatch);
            }
            if (needHorsVracMarineLitter) {
                this.batchTreeHelper.getOrCreateMarineLitterRootBatch(target, horsVracBatch, source.getMarineLitterTotalWeight());
            }
        }
        if (needUnsorted) {
            this.batchTreeHelper.getOrCreateRejectedBatch(target, source.getCatchTotalRejectedWeight());
        }
    }

    protected void computeIndirectWeight(Batch batch, Map<Integer, SortingBatch> indirectWeightByBatch, Set<Integer> indirectWeightByBatchSkip, Set<QuantificationMeasurement> quantificationMeasurements) {
        Integer batchId = batch.getId();
        if (indirectWeightByBatch.containsKey(batchId) || indirectWeightByBatchSkip.contains(batchId)) {
            return;
        }
        Collection childBatchs = batch.getChildBatchs();
        boolean batchIsLeaf = CollectionUtils.isEmpty((Collection)childBatchs);
        if (batchIsLeaf) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[BATCH :: " + batchId + "] - Do not compute on a leaf "));
            }
            return;
        }
        QuantificationMeasurement measurement = this.measurementPersistenceHelper.getWeightMeasurementQuantificationMeasurement(batch);
        if (measurement != null) {
            quantificationMeasurements.add(measurement);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[BATCH :: " + batchId + "] - Need to remove the quantification measurement (not a leaf) :: " + measurement.getId()));
            }
        }
        for (Batch childBatch : childBatchs) {
            this.computeIndirectWeight(childBatch, indirectWeightByBatch, indirectWeightByBatchSkip, quantificationMeasurements);
        }
        if (batch.getWeightBeforeSampling() != null) {
            indirectWeightByBatchSkip.add(batchId);
            if (log.isDebugEnabled()) {
                log.debug((Object)("[BATCH :: " + batchId + "] - No need of indirect weight (there is a weight before sampling) "));
            }
            return;
        }
        Float indirectWeight = this.computeIndirectWeight(batch);
        batch.setIndirectWeight(indirectWeight);
        if (batch.getWeight() != null) {
            indirectWeightByBatch.put(batchId, (SortingBatch)batch);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("[BATCH :: " + batchId + "] - Computed indirect weight " + indirectWeight));
        }
    }

    protected Float computeIndirectWeight(Batch batch) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("[BATCH :: " + batch.getId() + "] compute indirect weight"));
        }
        BigDecimal result = new BigDecimal(0);
        for (Batch childBatch : batch.getChildBatchs()) {
            Float weight = Numbers.getValueOrComputedValue(childBatch.getWeightBeforeSampling(), childBatch.getWeight());
            if (weight == null) {
                weight = childBatch.getIndirectWeight();
            }
            if (weight == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("[BATCH :: " + batch.getId() + "] Found a child batch " + childBatch.getId() + " has no weight, skip computing indirect weight for batch :: ..."));
                }
                return null;
            }
            result = result.add(new BigDecimal(String.valueOf(weight)));
        }
        return WeightUnit.KG.round(Float.valueOf(result.floatValue()));
    }

    @Override
    public Map getPrevOperationNameAndBatchId(int operationId, int taxonId) {
        String sql = "SELECT o.id as operationId, b.id as batchId FROM OPERATION o JOIN batch b ON o.catch_batch_fk=b.root_batch_fk WHERE o.is_fishing_operation = 1   AND o.fishing_trip_fk = (SELECT fishing_trip_fk FROM operation WHERE id = :operationId)   AND o.fishing_end_date_time < (select fishing_end_date_time from operation where id = :operationId)   AND b.reference_taxon_fk = :taxonId ORDER BY o.fishing_start_date_time DESC, b.id;";
        SQLQuery q = this.getCurrentSession().createSQLQuery(sql);
        q.setInteger("operationId", operationId);
        q.setInteger("taxonId", taxonId);
        q.setMaxResults(1);
        Object[] select = (Object[])q.uniqueResult();
        HashMap<String, Object> result = null;
        if (select != null && select.length == 2) {
            result = new HashMap<String, Object>();
            result.put("operationId", select[0]);
            result.put("batchId", select[1]);
        }
        return result;
    }

    @Override
    public Map getNextOperationNameAndBatchId(int operationId, int taxonId) {
        String sql = "SELECT o.id as operationId, b.id as batchId FROM OPERATION o JOIN batch b ON o.catch_batch_fk=b.root_batch_fk WHERE o.is_fishing_operation = 1   AND o.fishing_trip_fk = (SELECT fishing_trip_fk FROM operation WHERE id = :operationId)   AND o.fishing_end_date_time > (select fishing_end_date_time from operation where id = :operationId)   AND b.reference_taxon_fk = :taxonId ORDER BY o.fishing_start_date_time ASC, b.id;";
        SQLQuery q = this.getCurrentSession().createSQLQuery(sql);
        q.setInteger("operationId", operationId);
        q.setInteger("taxonId", taxonId);
        q.setMaxResults(1);
        Object[] select = (Object[])q.uniqueResult();
        HashMap<String, Object> result = null;
        if (select != null && select.length == 2) {
            result = new HashMap<String, Object>();
            result.put("operationId", select[0]);
            result.put("batchId", select[1]);
        }
        return result;
    }
}

