/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service;

import com.google.common.collect.Lists;
import com.opensymphony.xwork2.util.ValueStack;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.type.WeightUnit;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.util.DateUtil;
import org.nuiton.validator.xwork2.XWork2ValidatorUtil;

public abstract class TuttiValidationDataContextSupport {
    private static final Log log = LogFactory.getLog(TuttiValidationDataContextSupport.class);
    private List<Program> existingPrograms = Lists.newArrayList();
    private List<TuttiProtocol> existingProtocols = Lists.newArrayList();
    private List<FishingOperation> existingFishingOperations = Lists.newArrayList();

    public static TuttiValidationDataContextSupport setValidationContext(TuttiValidationDataContextSupport validationDataContext, boolean removePrevious) {
        ValueStack sharedValueStack = XWork2ValidatorUtil.getSharedValueStack();
        TuttiValidationDataContextSupport previousValidationContext = null;
        if (removePrevious) {
            ArrayList<Object> toRepush = new ArrayList<Object>();
            do {
                Object o = sharedValueStack.pop();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Pop object: " + o));
                }
                if (o instanceof TuttiValidationDataContextSupport) {
                    previousValidationContext = (TuttiValidationDataContextSupport)o;
                    continue;
                }
                toRepush.add(0, o);
            } while (previousValidationContext == null || sharedValueStack.size() > 0);
            for (Object e : toRepush) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Push object: " + e));
                }
                sharedValueStack.push(e);
            }
        }
        sharedValueStack.push((Object)validationDataContext);
        return previousValidationContext;
    }

    protected abstract List<Program> loadExistingPrograms();

    protected abstract List<TuttiProtocol> loadExistingProtocols();

    protected abstract List<FishingOperation> loadExistingFishingOperations();

    protected abstract Program getProgram();

    protected abstract Cruise getCruise();

    protected abstract TuttiProtocol getProtocol();

    protected abstract FishingOperation getFishingOperation();

    public final List<Program> getExistingPrograms() {
        if (this.existingPrograms == null) {
            this.existingPrograms = this.loadExistingPrograms();
        }
        return this.existingPrograms;
    }

    public final List<TuttiProtocol> getExistingProtocols() {
        if (this.existingProtocols == null) {
            this.existingProtocols = this.loadExistingProtocols();
        }
        return this.existingProtocols;
    }

    public final List<FishingOperation> getExistingFishingOperations() {
        if (this.existingFishingOperations == null) {
            this.existingFishingOperations = this.loadExistingFishingOperations();
        }
        return this.existingFishingOperations;
    }

    public final boolean isDateInCruise(Date date) {
        return DateUtil.between((Date)date, (Date)this.getCruise().getBeginDate(), (Date)this.getCruise().getEndDate());
    }

    public final boolean isNotWeightZeroValue(Float weight) {
        return WeightUnit.KG.isNotNullNorZero(weight);
    }

    public final boolean isMutiRegNumberValid(String numberAsString) {
        boolean result = false;
        if (numberAsString.matches("\\d+")) {
            Integer cruiseMultirigNumber;
            int mutlirigNumber = Integer.valueOf(numberAsString);
            result = mutlirigNumber <= (cruiseMultirigNumber = this.getCruise().getMultirigNumber());
        }
        return result;
    }

    public final boolean isValidDuration(Date gearShootingStartDate, Date gearShootingEndDate) {
        boolean result;
        boolean bl = result = gearShootingStartDate == null || gearShootingEndDate == null;
        if (!result) {
            int minutes = DateUtil.getDifferenceInMinutes((Date)gearShootingStartDate, (Date)gearShootingEndDate);
            result = minutes <= 45 && minutes >= 20;
        }
        return result;
    }

    public void reset() {
        this.resetExistingPrograms();
        this.resetExistingProtocols();
        this.resetExistingFishingOperations();
    }

    public void resetExistingPrograms() {
        this.existingPrograms = null;
    }

    public void resetExistingProtocols() {
        this.existingProtocols = null;
    }

    public void resetExistingFishingOperations() {
        this.existingFishingOperations = null;
    }
}

