/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.adagio.synchro.dao;

import com.google.common.base.Preconditions;
import fr.ifremer.adagio.synchro.SynchroTechnicalException;
import java.io.File;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.JDBCException;
import org.hibernate.Session;
import org.hibernate.cfg.Configuration;
import org.hibernate.dialect.Dialect;
import org.hibernate.exception.GenericJDBCException;
import org.hibernate.exception.spi.SQLExceptionConversionDelegate;
import org.hibernate.exception.spi.SQLExceptionConverter;
import org.nuiton.util.version.Version;
import org.nuiton.util.version.Versions;

public class Daos {
    private static final Log log = LogFactory.getLog(Daos.class);
    private static final String JDBC_URL_PREFIX_HSQLDB = "jdbc:hsqldb:";
    private static final String JDBC_URL_PREFIX_HSQLDB_FILE = "jdbc:hsqldb:file:";
    private static final String JDBC_URL_PREFIX_ORACLE = "jdbc:oracle:";

    protected Daos() {
    }

    public static Properties getConnectionProperties(String jdbcUrl, String username, String password, String schema, String dialect, String driver) {
        Properties p = new Properties();
        p.setProperty("hibernate.connection.driver_class", driver);
        p.setProperty("hibernate.dialect", dialect);
        p.setProperty("hibernate.connection.url", jdbcUrl);
        p.setProperty("hibernate.connection.username", username);
        p.setProperty("hibernate.connection.password", password);
        if (StringUtils.isNotBlank((CharSequence)schema)) {
            p.setProperty("hibernate.default_schema", schema);
        }
        p.setProperty("hibernate.synonyms", "true");
        if (jdbcUrl.startsWith("jdbc:oracle")) {
            p.setProperty("hibernatetool.metadatadialect", "org.hibernate.cfg.rveng.dialect.OracleMetaDataDialect");
        }
        return p;
    }

    public static SQLExceptionConverter newSQLExceptionConverter(final Dialect dialect) {
        return new SQLExceptionConverter(){
            private static final long serialVersionUID = 5458961195167573495L;
            SQLExceptionConversionDelegate delegate;
            {
                this.delegate = dialect.buildSQLExceptionConversionDelegate();
            }

            public JDBCException convert(SQLException sqlException, String message, String sql) {
                JDBCException exception = this.delegate.convert(sqlException, message, sql);
                if (exception != null) {
                    return exception;
                }
                return new GenericJDBCException(message, sqlException, sql);
            }
        };
    }

    public static void shutdownDatabase(Properties connectionProperties) throws SQLException {
        Connection conn = Daos.createConnection(connectionProperties);
        try {
            Daos.shutdownDatabase(conn);
        }
        finally {
            Daos.closeSilently(conn);
        }
    }

    public static void closeSilently(Statement statement) {
        block9: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(Connection connection) {
        block5: {
            try {
                if (connection != null && !connection.isClosed()) {
                    connection.close();
                }
            }
            catch (Exception e) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (!log.isErrorEnabled()) break block5;
                log.error((Object)"Could not close connection, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(ResultSet statement) {
        block9: {
            try {
                if (statement != null && !statement.isClosed()) {
                    statement.close();
                }
            }
            catch (AbstractMethodError e) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this linkage error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (IllegalAccessError e) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Fix this IllegalAccessError error, damned hsqlsb 1.8.0.7:(");
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block9;
                log.error((Object)"Could not close statement, but do not care", (Throwable)e);
            }
        }
    }

    public static void closeSilently(Session session) {
        block3: {
            try {
                if (session != null && session.isOpen()) {
                    session.close();
                }
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)"Could not close session, but do not care", (Throwable)e);
            }
        }
    }

    public static Connection createConnection(Properties connectionProperties) throws SQLException {
        return Daos.createConnection(connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    public static Connection createConnection(String jdbcUrl, String user, String password) throws SQLException {
        Connection connection = DriverManager.getConnection(jdbcUrl, user, password);
        connection.setAutoCommit(false);
        return connection;
    }

    public static void fillConnectionProperties(Properties p, String url, String username, String password) {
        p.put("hibernate.connection.url", url);
        p.put("hibernate.connection.username", username);
        p.put("hibernate.connection.password", password);
    }

    public static String getJdbcUrl(File directory, String dbName) {
        String jdbcUrl = JDBC_URL_PREFIX_HSQLDB_FILE + directory.getAbsolutePath() + "/" + dbName;
        jdbcUrl = jdbcUrl.replaceAll("\\\\", "/");
        return jdbcUrl;
    }

    public static boolean isFileDatabase(String jdbcUrl) {
        Preconditions.checkNotNull((Object)jdbcUrl);
        return jdbcUrl.startsWith(JDBC_URL_PREFIX_HSQLDB_FILE);
    }

    public static boolean isOracleDatabase(String jdbcUrl) {
        Preconditions.checkNotNull((Object)jdbcUrl);
        return jdbcUrl.startsWith(JDBC_URL_PREFIX_ORACLE);
    }

    public static boolean isValidConnectionProperties(Properties connectionProperties) {
        return Daos.isValidConnectionProperties(connectionProperties.getProperty("hibernate.connection.driver_class"), connectionProperties.getProperty("hibernate.connection.url"), connectionProperties.getProperty("hibernate.connection.username"), connectionProperties.getProperty("hibernate.connection.password"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isValidConnectionProperties(String jdbcDriver, String jdbcUrl, String user, String password) {
        boolean bl;
        String driverClassName = jdbcDriver;
        try {
            Class<?> driverClass = Class.forName(driverClassName);
            DriverManager.registerDriver((Driver)driverClass.newInstance());
        }
        catch (Exception e) {
            log.error((Object)("Could not load JDBC Driver: " + e.getMessage()), (Throwable)e);
            return false;
        }
        Connection connection = null;
        try {
            connection = Daos.createConnection(jdbcUrl, user, password);
            bl = true;
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Could not connect to database: " + e.getMessage().trim()));
            }
            catch (Throwable throwable) {
                Daos.closeSilently(connection);
                throw throwable;
            }
            Daos.closeSilently(connection);
            return false;
        }
        Daos.closeSilently(connection);
        return bl;
    }

    public static String getUrl(Properties connectionProperties) {
        return connectionProperties.getProperty("hibernate.connection.url");
    }

    public static Dialect getDialect(Properties connectionProperties) {
        return Dialect.getDialect((Properties)connectionProperties);
    }

    public static Configuration getConfiguration(Properties connectionProperties) {
        return new Configuration().setProperties(connectionProperties);
    }

    public static void shutdownDatabase(Connection connection) {
        try {
            String jdbcUrl = connection.getMetaData().getURL();
            if (Daos.isFileDatabase(jdbcUrl)) {
                Daos.sqlUpdate(connection, "SHUTDOWN");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static int sqlUpdate(Connection connection, String sql) {
        Statement stmt = null;
        try {
            stmt = connection.createStatement();
        }
        catch (SQLException ex) {
            Daos.closeSilently(stmt);
            throw new SynchroTechnicalException("Could not open database connection", ex);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)sql);
        }
        try {
            int ex = stmt.executeUpdate(sql);
            return ex;
        }
        catch (SQLException ex) {
            throw new SynchroTechnicalException("Could not execute query: " + sql, ex);
        }
        finally {
            Daos.closeSilently(stmt);
        }
    }

    public static boolean isHsqldbDatabase(String jdbcUrl) {
        Preconditions.checkNotNull((Object)jdbcUrl);
        return jdbcUrl.startsWith(JDBC_URL_PREFIX_HSQLDB);
    }

    public static void setIntegrityConstraints(Properties connectionProperties, boolean enableIntegrityConstraints) throws SQLException {
        Connection connection = null;
        try {
            connection = Daos.createConnection(connectionProperties);
            Daos.setIntegrityConstraints(connection, enableIntegrityConstraints);
        }
        finally {
            Daos.closeSilently(connection);
        }
    }

    public static void setIntegrityConstraints(Connection connection, boolean enableIntegrityConstraints) throws SQLException {
        String jdbcUrl = connection.getMetaData().getURL();
        String sql = null;
        if (!Daos.isHsqldbDatabase(jdbcUrl)) {
            throw new SynchroTechnicalException(String.format("Could not disable integrity constraints on database: %s. Not implemented for this DBMS.", jdbcUrl));
        }
        Version hsqldbVersion = Daos.getDatabaseVersion(connection);
        sql = "1.8".equals(hsqldbVersion.toString()) ? "SET REFERENTIAL_INTEGRITY %s" : "SET DATABASE REFERENTIAL INTEGRITY %s";
        sql = String.format(sql, enableIntegrityConstraints ? "TRUE" : "FALSE");
        Daos.sqlUpdate(connection, sql);
    }

    public static Timestamp getCurrentTimestamp(Properties connectionProperties) {
        Dialect dialect = Dialect.getDialect((Properties)connectionProperties);
        Preconditions.checkNotNull((Object)dialect, (Object)"Could not found hibernate dialect for this connection properties.");
        Connection connection = null;
        try {
            connection = Daos.createConnection(connectionProperties);
            Timestamp timestamp = Daos.getCurrentTimestamp(connection, dialect);
            return timestamp;
        }
        catch (SQLException e) {
            throw new SynchroTechnicalException("Could not connect to given database", e);
        }
        finally {
            Daos.closeSilently(connection);
        }
    }

    public static Timestamp getCurrentTimestamp(Connection connection, Dialect dialect) {
        String sql = dialect.getCurrentTimestampSelectString();
        Statement statement = null;
        try {
            Timestamp result;
            statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(sql);
            rs.next();
            Timestamp timestamp = result = rs.getTimestamp(1);
            return timestamp;
        }
        catch (SQLException e) {
            throw new SynchroTechnicalException("Error while executing function SYSTIMESTAMP query.", e);
        }
        finally {
            Daos.closeSilently(statement);
        }
    }

    public static int compareUpdateDates(Timestamp t1, Timestamp t2) {
        if (t1 == null && t2 == null) {
            return 0;
        }
        if (t2 == null) {
            return 1;
        }
        if (t1 == null) {
            return -1;
        }
        return t1.compareTo(t2);
    }

    public static boolean isUpdateDateBefore(Timestamp t1, Timestamp t2) {
        return Daos.compareUpdateDates(t1, t2) < 0;
    }

    public static Version getDatabaseVersion(Connection connection) throws SQLException {
        int majorVersion = connection.getMetaData().getDatabaseMajorVersion();
        int minorVersion = connection.getMetaData().getDatabaseMinorVersion();
        return Versions.valueOf((String)String.format("%d.%d", majorVersion, minorVersion));
    }
}

