/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.bigfin.csv;

import fr.ifremer.tutti.persistence.entities.data.SpeciesBatch;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.service.bigfin.csv.BigfinDataRow;
import fr.ifremer.tutti.service.bigfin.csv.SpeciesOrSpeciesBatch;
import fr.ifremer.tutti.service.bigfin.signs.Sex;
import fr.ifremer.tutti.service.bigfin.signs.Size;
import fr.ifremer.tutti.service.bigfin.signs.VracHorsVrac;
import fr.ifremer.tutti.service.csv.AbstractTuttiImportModel;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nuiton.csv.Common;
import org.nuiton.csv.ValueParser;

public class BigfinDataRowModel
extends AbstractTuttiImportModel<BigfinDataRow> {
    public BigfinDataRowModel(Map<String, Species> speciesBySurveyCode, Map<Integer, SpeciesBatch> speciesBatchesById) {
        super(',');
        this.newIgnoredColumn("Study name");
        this.newMandatoryColumn("ID", "recordId");
        this.newMandatoryColumn("Date", "date", (ValueParser)new Common.DateValue("MM/dd/yy HH:mm:ss"));
        this.newIgnoredColumn("LOC");
        this.newMandatoryColumn("STA", "station");
        this.newMandatoryColumn("COMMENT", "vracHorsVrac", new VracHorsVracValueParser());
        this.newIgnoredColumn("GPS X");
        this.newIgnoredColumn("GPS Y");
        this.newIgnoredColumn("SP CODE");
        this.newMandatoryColumn("SPEC", "speciesOrSpeciesBatch", new SpeciesOrSpeciesBatchValueParser(speciesBySurveyCode, speciesBatchesById));
        this.newMandatoryColumn("LENGTH (mm)", "length", (ValueParser)Common.PRIMITIVE_FLOAT);
        this.newMandatoryColumn("WEIGHT (g)", "weight", (ValueParser)Common.FLOAT);
        this.newMandatoryColumn("SEX", "sex", new SexValueParser());
        this.newMandatoryColumn("SIZE", "size", new SizeValueParser());
        this.newIgnoredColumn("MT");
        this.newIgnoredColumn("MS");
    }

    public BigfinDataRow newEmptyInstance() {
        return new BigfinDataRow();
    }

    private static class VracHorsVracValueParser
    implements ValueParser<VracHorsVrac> {
        private VracHorsVracValueParser() {
        }

        public VracHorsVrac parse(String value) throws ParseException {
            VracHorsVrac result = VracHorsVrac.getValue(value.toUpperCase());
            if (result == null) {
                result = VracHorsVrac.VRAC;
            }
            return result;
        }
    }

    private static class SexValueParser
    implements ValueParser<Sex> {
        private SexValueParser() {
        }

        public Sex parse(String value) throws ParseException {
            Sex result = Sex.getValue(value.toUpperCase());
            if (result == null) {
                throw new ParseException("Could not parse Sex value: " + value, 0);
            }
            return result;
        }
    }

    private static class SizeValueParser
    implements ValueParser<Size> {
        private SizeValueParser() {
        }

        public Size parse(String value) throws ParseException {
            return Size.getValue(value.toUpperCase());
        }
    }

    private static class SpeciesOrSpeciesBatchValueParser
    implements ValueParser<SpeciesOrSpeciesBatch> {
        final Map<String, Species> foundSpecies = new HashMap<String, Species>();
        private final Map<String, Species> speciesBySurveyCode;
        private final Map<Integer, SpeciesBatch> speciesBatches;

        public SpeciesOrSpeciesBatchValueParser(Map<String, Species> speciesBySurveyCode, Map<Integer, SpeciesBatch> speciesBatchesById) {
            this.speciesBySurveyCode = speciesBySurveyCode;
            this.speciesBatches = speciesBatchesById;
        }

        public SpeciesOrSpeciesBatch parse(String value) throws ParseException {
            SpeciesBatch speciesBatch = null;
            Species species = null;
            if (StringUtils.isNotBlank((CharSequence)value) && (speciesBatch = this.getSpeciesBatch(value)) == null) {
                species = this.getSpecies(value);
            }
            SpeciesOrSpeciesBatch result = speciesBatch == null ? new SpeciesOrSpeciesBatch(species) : new SpeciesOrSpeciesBatch(speciesBatch);
            return result;
        }

        protected SpeciesBatch getSpeciesBatch(String value) {
            SpeciesBatch speciesBatch = null;
            if (StringUtils.isNotBlank((CharSequence)value)) {
                try {
                    Integer batchId = Integer.valueOf(value);
                    speciesBatch = this.speciesBatches.get(batchId);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return speciesBatch;
        }

        protected Species getSpecies(String value) {
            Species species;
            if (StringUtils.isBlank((CharSequence)value)) {
                species = Speciess.newSpecies();
            } else {
                species = this.foundSpecies.get(value = value.toUpperCase());
                if (species == null) {
                    species = this.speciesBySurveyCode.get(value);
                }
                if (species == null) {
                    String alternativeSpeciesCode = value.substring(0, 4) + '-' + value.substring(4);
                    species = this.speciesBySurveyCode.get(alternativeSpeciesCode);
                }
                if (species == null) {
                    species = Speciess.newSpecies();
                    species.setExternalCode(value);
                }
                this.foundSpecies.put(value, species);
            }
            return species;
        }
    }
}

