/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.actions;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.tutti.service.protocol.ProtocolImportExportService;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiBeanUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class ExportProtocolSpeciesAction
extends LongActionSupport<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(ExportProtocolSpeciesAction.class);
    private File file;

    public ExportProtocolSpeciesAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    public boolean prepareAction() throws Exception {
        boolean doAction = super.prepareAction();
        if (doAction) {
            this.file = this.saveFile(((EditProtocolUIModel)this.getModel()).getName() + "-species", "csv", I18n.t((String)"tutti.editProtocol.title.choose.speciesExportFile", (Object[])new Object[0]), I18n.t((String)"tutti.editProtocol.action.exportProtocolSpeciesFile", (Object[])new Object[0]), new String[]{"^.*\\.csv", I18n.t((String)"tutti.common.file.csv", (Object[])new Object[0])});
            doAction = this.file != null;
        }
        return doAction;
    }

    public void releaseAction() {
        this.file = null;
        super.releaseAction();
    }

    @Override
    public void doAction() throws Exception {
        Preconditions.checkNotNull((Object)this.file);
        if (log.isInfoEnabled()) {
            log.info((Object)("Will export protocol species to file: " + this.file));
        }
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        ArrayList protocols = Lists.newArrayList();
        protocols.addAll(model.getSpeciesRow().stream().filter(AbstractTuttiBeanUIModel::isValid).map(AbstractTuttiBeanUIModel::toEntity).collect(Collectors.toList()));
        ProtocolImportExportService service = this.getContext().getTuttiProtocolImportExportService();
        service.exportProtocolSpecies(this.file, (List)protocols, model.getAllCaracteristic(), model.getAllReferentSpeciesByTaxonId());
        this.sendMessage(I18n.t((String)"tutti.flash.info.species.exported.from.protocol", (Object[])new Object[]{this.file}));
    }
}

