/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cache.annotation;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import org.springframework.cache.annotation.CacheAnnotationParser;
import org.springframework.cache.annotation.CacheConfig;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.CachePut;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.cache.annotation.Caching;
import org.springframework.cache.interceptor.CacheEvictOperation;
import org.springframework.cache.interceptor.CacheOperation;
import org.springframework.cache.interceptor.CachePutOperation;
import org.springframework.cache.interceptor.CacheableOperation;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class SpringCacheAnnotationParser
implements CacheAnnotationParser,
Serializable {
    @Override
    public Collection<CacheOperation> parseCacheAnnotations(Class<?> type) {
        DefaultCacheConfig defaultConfig = this.getDefaultCacheConfig(type);
        return this.parseCacheAnnotations(defaultConfig, type);
    }

    @Override
    public Collection<CacheOperation> parseCacheAnnotations(Method method) {
        DefaultCacheConfig defaultConfig = this.getDefaultCacheConfig(method.getDeclaringClass());
        return this.parseCacheAnnotations(defaultConfig, method);
    }

    protected Collection<CacheOperation> parseCacheAnnotations(DefaultCacheConfig cachingConfig, AnnotatedElement ae) {
        Collection<Caching> collection;
        Collection<CachePut> collection2;
        Collection<CacheEvict> evicts;
        Collection<CacheOperation> ops = null;
        Collection<Cacheable> cacheables = this.getAnnotations(ae, Cacheable.class);
        if (cacheables != null) {
            ops = this.lazyInit(ops);
            for (Cacheable cacheable : cacheables) {
                ops.add(this.parseCacheableAnnotation(ae, cachingConfig, cacheable));
            }
        }
        if ((evicts = this.getAnnotations(ae, CacheEvict.class)) != null) {
            ops = this.lazyInit(ops);
            for (CacheEvict cacheEvict : evicts) {
                ops.add(this.parseEvictAnnotation(ae, cachingConfig, cacheEvict));
            }
        }
        if ((collection2 = this.getAnnotations(ae, CachePut.class)) != null) {
            ops = this.lazyInit(ops);
            for (CachePut put : collection2) {
                ops.add(this.parsePutAnnotation(ae, cachingConfig, put));
            }
        }
        if ((collection = this.getAnnotations(ae, Caching.class)) != null) {
            ops = this.lazyInit(ops);
            for (Caching caching : collection) {
                ops.addAll(this.parseCachingAnnotation(ae, cachingConfig, caching));
            }
        }
        return ops;
    }

    private <T extends Annotation> Collection<CacheOperation> lazyInit(Collection<CacheOperation> ops) {
        return ops != null ? ops : new ArrayList(1);
    }

    CacheableOperation parseCacheableAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, Cacheable cacheable) {
        CacheableOperation op = new CacheableOperation();
        op.setCacheNames(cacheable.cacheNames());
        op.setCondition(cacheable.condition());
        op.setUnless(cacheable.unless());
        op.setKey(cacheable.key());
        op.setKeyGenerator(cacheable.keyGenerator());
        op.setCacheManager(cacheable.cacheManager());
        op.setCacheResolver(cacheable.cacheResolver());
        op.setName(ae.toString());
        defaultConfig.applyDefault(op);
        this.validateCacheOperation(ae, op);
        return op;
    }

    CacheEvictOperation parseEvictAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, CacheEvict cacheEvict) {
        CacheEvictOperation op = new CacheEvictOperation();
        op.setCacheNames(cacheEvict.cacheNames());
        op.setCondition(cacheEvict.condition());
        op.setKey(cacheEvict.key());
        op.setKeyGenerator(cacheEvict.keyGenerator());
        op.setCacheManager(cacheEvict.cacheManager());
        op.setCacheResolver(cacheEvict.cacheResolver());
        op.setCacheWide(cacheEvict.allEntries());
        op.setBeforeInvocation(cacheEvict.beforeInvocation());
        op.setName(ae.toString());
        defaultConfig.applyDefault(op);
        this.validateCacheOperation(ae, op);
        return op;
    }

    CacheOperation parsePutAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, CachePut cachePut) {
        CachePutOperation op = new CachePutOperation();
        op.setCacheNames(cachePut.cacheNames());
        op.setCondition(cachePut.condition());
        op.setUnless(cachePut.unless());
        op.setKey(cachePut.key());
        op.setKeyGenerator(cachePut.keyGenerator());
        op.setCacheManager(cachePut.cacheManager());
        op.setCacheResolver(cachePut.cacheResolver());
        op.setName(ae.toString());
        defaultConfig.applyDefault(op);
        this.validateCacheOperation(ae, op);
        return op;
    }

    Collection<CacheOperation> parseCachingAnnotation(AnnotatedElement ae, DefaultCacheConfig defaultConfig, Caching caching) {
        Object[] cachePuts;
        Object[] cacheEvicts;
        Collection<CacheOperation> ops = null;
        Object[] cacheables = caching.cacheable();
        if (!ObjectUtils.isEmpty((Object[])cacheables)) {
            ops = this.lazyInit(ops);
            for (Object cacheable : cacheables) {
                ops.add(this.parseCacheableAnnotation(ae, defaultConfig, (Cacheable)cacheable));
            }
        }
        if (!ObjectUtils.isEmpty((Object[])(cacheEvicts = caching.evict()))) {
            ops = this.lazyInit(ops);
            for (Object cacheEvict : cacheEvicts) {
                ops.add(this.parseEvictAnnotation(ae, defaultConfig, (CacheEvict)cacheEvict));
            }
        }
        if (!ObjectUtils.isEmpty((Object[])(cachePuts = caching.put()))) {
            ops = this.lazyInit(ops);
            for (Object cachePut : cachePuts) {
                ops.add(this.parsePutAnnotation(ae, defaultConfig, (CachePut)cachePut));
            }
        }
        return ops;
    }

    DefaultCacheConfig getDefaultCacheConfig(Class<?> target) {
        CacheConfig annotation = (CacheConfig)AnnotationUtils.getAnnotation(target, CacheConfig.class);
        if (annotation != null) {
            return new DefaultCacheConfig(annotation.cacheNames(), annotation.keyGenerator(), annotation.cacheManager(), annotation.cacheResolver());
        }
        return new DefaultCacheConfig();
    }

    private <A extends Annotation> Collection<A> getAnnotations(AnnotatedElement ae, Class<A> annotationType) {
        ArrayList<Annotation> anns = new ArrayList<Annotation>(2);
        A ann = ae.getAnnotation(annotationType);
        if (ann != null) {
            anns.add(AnnotationUtils.synthesizeAnnotation(ann, (AnnotatedElement)ae));
        }
        for (Annotation metaAnn : ae.getAnnotations()) {
            ann = metaAnn.annotationType().getAnnotation(annotationType);
            if (ann == null) continue;
            anns.add(AnnotationUtils.synthesizeAnnotation(ann, (AnnotatedElement)ae));
        }
        return anns.isEmpty() ? null : anns;
    }

    private void validateCacheOperation(AnnotatedElement ae, CacheOperation operation) {
        if (StringUtils.hasText((String)operation.getKey()) && StringUtils.hasText((String)operation.getKeyGenerator())) {
            throw new IllegalStateException("Invalid cache annotation configuration on '" + ae.toString() + "'. Both 'key' and 'keyGenerator' attributes have been set. " + "These attributes are mutually exclusive: either set the SpEL expression used to" + "compute the key at runtime or set the name of the KeyGenerator bean to use.");
        }
        if (StringUtils.hasText((String)operation.getCacheManager()) && StringUtils.hasText((String)operation.getCacheResolver())) {
            throw new IllegalStateException("Invalid cache annotation configuration on '" + ae.toString() + "'. Both 'cacheManager' and 'cacheResolver' attributes have been set. " + "These attributes are mutually exclusive: the cache manager is used to configure a" + "default cache resolver if none is set. If a cache resolver is set, the cache manager" + "won't be used.");
        }
    }

    public boolean equals(Object other) {
        return this == other || other instanceof SpringCacheAnnotationParser;
    }

    public int hashCode() {
        return SpringCacheAnnotationParser.class.hashCode();
    }

    static class DefaultCacheConfig {
        private final String[] cacheNames;
        private final String keyGenerator;
        private final String cacheManager;
        private final String cacheResolver;

        public DefaultCacheConfig() {
            this(null, null, null, null);
        }

        private DefaultCacheConfig(String[] cacheNames, String keyGenerator, String cacheManager, String cacheResolver) {
            this.cacheNames = cacheNames;
            this.keyGenerator = keyGenerator;
            this.cacheManager = cacheManager;
            this.cacheResolver = cacheResolver;
        }

        public void applyDefault(CacheOperation operation) {
            if (operation.getCacheNames().isEmpty() && this.cacheNames != null) {
                operation.setCacheNames(this.cacheNames);
            }
            if (!StringUtils.hasText((String)operation.getKey()) && !StringUtils.hasText((String)operation.getKeyGenerator()) && StringUtils.hasText((String)this.keyGenerator)) {
                operation.setKeyGenerator(this.keyGenerator);
            }
            if (!StringUtils.hasText((String)operation.getCacheManager()) && !StringUtils.hasText((String)operation.getCacheResolver())) {
                if (StringUtils.hasText((String)this.cacheResolver)) {
                    operation.setCacheResolver(this.cacheResolver);
                } else if (StringUtils.hasText((String)this.cacheManager)) {
                    operation.setCacheManager(this.cacheManager);
                }
            }
        }
    }
}

