/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.CatchCustomTab;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesSvgHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.EditCatchesUIModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.BenthosBatchUISupportImpl;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.EditSpeciesBatchPanelUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.SpeciesOrBenthosBatchUISupport;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiTabContainerUIHandler;
import fr.ifremer.tutti.ui.swing.util.TuttiBeanMonitor;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.Serializable;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import jaxx.runtime.swing.CardLayout2Ext;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTitledPanel;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.tab.TabContentModel;
import org.nuiton.jaxx.application.swing.tab.TabHandler;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class EditCatchesUIHandler
extends AbstractTuttiTabContainerUIHandler<EditCatchesUIModel, EditCatchesUI>
implements TabHandler {
    public static final String MAIN_CARD = "main";
    public static final String CREATE_BATCH_CARD = "createBatch";
    public static final String EDIT_CARACTERISTICS_CARD = "caracteristicsCard";
    private static final Log log = LogFactory.getLog(EditCatchesUIHandler.class);
    private TuttiBeanMonitor<EditCatchesUIModel> catchBatchMonitor;
    private final PropertyChangeListener totalWeightRejectedListener = new PropertyChangeListener(){

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            EditCatchesUIModel source = (EditCatchesUIModel)evt.getSource();
            Float totalWeight = (Float)evt.getNewValue();
            if (totalWeight != null && WeightUnit.KG.isZero(totalWeight.floatValue())) {
                source.setCatchTotalRejectedWeight(null);
            }
        }
    };
    private EditCatchesSvgHandler editCatchesSvgHandler;

    public void beforeInit(EditCatchesUI ui) {
        super.beforeInit((ApplicationUI)ui);
        this.catchBatchMonitor = new TuttiBeanMonitor("marineLitterTotalWeight", "speciesTotalSortedWeight", "speciesTotalInertWeight", "speciesTotalLivingNotItemizedWeight", "benthosTotalSortedWeight", "benthosTotalInertWeight", "benthosTotalLivingNotItemizedWeight");
        EditCatchesUIModel model = ui.getContextValue(EditCatchesUIModel.class);
        model.setValidationContext(this.getContext().getValidationContext());
        this.listModelIsModify(model);
        this.catchBatchMonitor.setBean(model);
        this.editCatchesSvgHandler = new EditCatchesSvgHandler(this.getContext(), ui, model);
    }

    public void afterInit(EditCatchesUI ui) {
        this.initUI(ui);
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        this.changeValidatorContext(model.getValidationContext(), this.getValidator());
        this.listenValidationTableHasNoFatalError((SimpleBeanValidator)this.getValidator(), model);
        this.setCustomTab2(0, model, Sets.newHashSet((Object[])new String[]{"catchTotalWeight", "catchTotalRejectedWeight", "speciesTotalSortedWeight", "speciesTotalInertWeight", "speciesTotalLivingNotItemizedWeight", "benthosTotalSortedWeight", "benthosTotalInertWeight", "benthosTotalLivingNotItemizedWeight", "marineLitterTotalWeight"}));
        this.setCustomTab(1, ui.getSpeciesTabPanel().getEditBatchesUI().getModel());
        this.setCustomTab(2, ui.getBenthosTabPanel().getEditBatchesUI().getModel());
        this.setCustomTab(3, ui.getMarineLitterTabContent().getModel());
        this.setCustomTab(4, ui.getAccidentalTabContent().getModel());
        this.getTabPanel().setSelectedIndex(1);
        this.getTabPanel().addChangeListener(e -> this.closeAttachments());
    }

    public void setCustomTab2(int index, TabContentModel model, Set<String> modifyPropertyNames) {
        JTabbedPane tabPanel = this.getTabPanel();
        tabPanel.setTabComponentAt(index, (Component)((Object)CatchCustomTab.newCustomTab(model, this, modifyPropertyNames)));
    }

    public void closeAttachments() {
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getSpeciesTabPanel().getEditBatchesUI().getSpeciesBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getBenthosTabPanel().getEditBatchesUI().getSpeciesBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getMarineLitterTabContent().getMarineLitterBatchAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getAccidentalTabContent().getAccidentalBatchAttachmentsButton().onCloseUI();
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        this.editCatchesSvgHandler.clearSVG();
        this.closeUI(((EditCatchesUI)this.ui).getSpeciesTabPanel());
        this.closeUI(((EditCatchesUI)this.ui).getBenthosTabPanel());
        this.closeUI(((EditCatchesUI)this.ui).getMarineLitterTabContent());
        this.closeUI(((EditCatchesUI)this.ui).getAccidentalTabContent());
    }

    public SwingValidator<EditCatchesUIModel> getValidator() {
        return ((EditCatchesUI)this.ui).getValidator();
    }

    @Override
    protected Set<String> getPropertiesToIgnore() {
        Set<String> result = super.getPropertiesToIgnore();
        result.addAll(Sets.newHashSet((Object[])new String[]{"catchTotalComputedWeight", "catchTotalUnsortedComputedWeight", "catchTotalSortedComputedWeight", "catchTotalSortedSortedComputedWeight", "catchTotalRejectedComputedWeight", "speciesTotalComputedWeight", "speciesTotalSortedComputedWeight", "speciesTotalUnsortedComputedWeight", "speciesTotalSampleSortedComputedWeight", "speciesTotalInertComputedWeight", "speciesTotalLivingNotItemizedComputedWeight", "benthosTotalComputedWeight", "benthosTotalSortedComputedWeight", "benthosTotalUnsortedComputedWeight", "benthosTotalSampleSortedComputedWeight", "benthosTotalInertComputedWeight", "benthosTotalLivingNotItemizedComputedWeight", "speciesDistinctSortedSpeciesCount", "benthosDistinctSortedSpeciesCount", "speciesDistinctUnsortedSpeciesCount", "benthosDistinctUnsortedSpeciesCount", "marineLitterTotalComputedWeight", "attachment"}));
        return result;
    }

    public JTabbedPane getTabPanel() {
        return ((EditCatchesUI)this.ui).getTabPane();
    }

    @Override
    public boolean onTabChanged(int currentIndex, int newIndex) {
        ((EditCatchesUI)this.ui).getCatchesCaracteristicsAttachmentsButton().onCloseUI();
        ((EditCatchesUI)this.ui).getComputeSpeciesBatchButton().setVisible(newIndex < 4);
        ((EditCatchesUI)this.ui).getCleanSpeciesBatchButton().setVisible(newIndex > 0 && newIndex < 3);
        boolean result = super.onTabChanged(currentIndex, newIndex);
        if (result && currentIndex != newIndex) {
            boolean showMainActions;
            boolean bl = result = ((EditCatchesUIModel)this.getModel()).isDoNotCheckLeavingFrequencyScreen() || this.blockIfNotLeavingFrequencyScreen();
            if (!result) {
                return false;
            }
            if (currentIndex == 0) {
                this.editCatchesSvgHandler.clearSVG();
            }
            if (newIndex == 0) {
                if (((EditCatchesUI)this.getUI()).isVisible()) {
                    this.editCatchesSvgHandler.initResumeSvg();
                }
                showMainActions = true;
            } else {
                JComponent componentAt = (JComponent)this.getTabPanel().getComponentAt(newIndex);
                CardLayout2Ext layout = (CardLayout2Ext)componentAt.getLayout();
                String selectedCard = layout.getSelected();
                showMainActions = selectedCard == null || MAIN_CARD.equals(selectedCard) || "editBatch".equals(selectedCard);
            }
            ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions().setVisible(showMainActions);
        }
        return result;
    }

    public boolean onHideTab(int currentIndex, int newIndex) {
        this.closeAttachments();
        EditCatchesUIModel model = (EditCatchesUIModel)this.getModel();
        boolean result = this.blockIfNotLeavingFrequencyScreen();
        if (!result) {
            return false;
        }
        if (model.isModify()) {
            if (model.isValid()) {
                int answer = this.askSaveBeforeLeaving(I18n.t((String)"tutti.editCatchBatch.askSaveBeforeLeaving.saveCatchBatch", (Object[])new Object[0]));
                switch (answer) {
                    case 0: {
                        this.getContext().getActionEngine().runAction((AbstractButton)((EditCatchesUI)this.getUI()).getSaveButton());
                        result = true;
                        break;
                    }
                    case 1: {
                        this.getContext().getActionEngine().runAction((AbstractButton)((EditCatchesUI)this.getUI()).getCancelButton());
                        result = true;
                        break;
                    }
                    default: {
                        result = false;
                        break;
                    }
                }
            } else {
                result = this.askCancelEditBeforeLeaving(I18n.t((String)"tutti.editCatchBatch.askCancelEditBeforeLeaving.cancelEditCatchBatch", (Object[])new Object[0]));
                if (result) {
                    this.getContext().getActionEngine().runAction((AbstractButton)((EditCatchesUI)this.ui).getCancelButton());
                }
            }
        } else {
            result = true;
        }
        if (result) {
            this.editCatchesSvgHandler.clearSVG();
        }
        return result;
    }

    public void onShowTab(int currentIndex, int newIndex) {
        this.registerValidators();
        this.editCatchesSvgHandler.initResumeSvg();
    }

    public boolean removeTab(int i) {
        return false;
    }

    public boolean onRemoveTab() {
        return false;
    }

    public EditSpeciesBatchPanelUI getEditSpeciesBatchPanelUI(SpeciesOrBenthosBatchUISupport batchUISupport) {
        return batchUISupport instanceof BenthosBatchUISupportImpl ? ((EditCatchesUI)this.ui).getBenthosTabPanel() : ((EditCatchesUI)this.ui).getSpeciesTabPanel();
    }

    public void uninstallTotalRejectWeightListener() {
        ((EditCatchesUIModel)this.getModel()).removePropertyChangeListener("catchTotalRejectedWeight", this.totalWeightRejectedListener);
    }

    public void installTotalRejectWeightListener() {
        ((EditCatchesUIModel)this.getModel()).addPropertyChangeListener("catchTotalRejectedWeight", this.totalWeightRejectedListener);
    }

    public TuttiBeanMonitor<EditCatchesUIModel> getCatchBatchMonitor() {
        return this.catchBatchMonitor;
    }

    protected void registerValidators() {
        this.registerValidators(this.getValidator(), ((EditCatchesUI)this.ui).getSpeciesTabPanel().getEditBatchesUI().getHandler().getValidator(), ((EditCatchesUI)this.ui).getBenthosTabPanel().getEditBatchesUI().getHandler().getValidator(), ((EditCatchesUI)this.ui).getMarineLitterTabContent().getHandler().getValidator());
    }

    public void setMarineLitterSelectedCard(String card) {
        JPanel panel = ((EditCatchesUI)this.ui).getMarineLitterTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            boolean showActionPanel;
            layout.setSelected(card);
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                showActionPanel = true;
            } else {
                showActionPanel = false;
                if (CREATE_BATCH_CARD.equals(card)) {
                    this.registerValidators(((EditCatchesUI)this.ui).getMarineLitterTabCreateBatch().getValidator());
                    String title = I18n.n((String)"tutti.createMarineLitterBatch.title", (Object[])new Object[0]);
                    ((EditCatchesUI)this.ui).getMarineLitterTabCreateBatchReminderLabel().setTitle(((EditCatchesUI)this.ui).getMarineLitterTabCreateBatchReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[0]));
                }
            }
            ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions().setVisible(showActionPanel);
        }
    }

    public void setAccidentalSelectedCard(String card) {
        this.setAccidentalSelectedCard(card, null);
    }

    public void setAccidentalSelectedCard(String card, Species species) {
        JPanel panel = ((EditCatchesUI)this.ui).getAccidentalTabPanel();
        CardLayout2Ext layout = (CardLayout2Ext)panel.getLayout();
        if (!card.equals(layout.getSelected())) {
            boolean showActionPanel;
            layout.setSelected(card);
            if (MAIN_CARD.equals(card)) {
                this.registerValidators();
                showActionPanel = true;
            } else {
                showActionPanel = false;
                JXTitledPanel titlePanel = null;
                String title = "";
                if (CREATE_BATCH_CARD.equals(card)) {
                    this.registerValidators(((EditCatchesUI)this.ui).getAccidentalTabCreateBatch().getValidator());
                    titlePanel = ((EditCatchesUI)this.ui).getAccidentalTabCreateBatchReminderLabel();
                    title = I18n.n((String)"tutti.createAccidentalBatch.title", (Object[])new Object[0]);
                } else if (EDIT_CARACTERISTICS_CARD.equals(card)) {
                    titlePanel = ((EditCatchesUI)this.ui).getAccidentalCaracteristicMapEditorReminderLabel();
                    title = I18n.n((String)"tutti.editCaracteristics.title", (Object[])new Object[0]);
                }
                if (titlePanel != null) {
                    titlePanel.setTitle(((EditCatchesUI)this.ui).getAccidentalTabFishingOperationReminderLabel().getTitle() + " - " + I18n.t((String)title, (Object[])new Object[]{this.decorate((Serializable)species)}));
                }
            }
            ((EditCatchesUI)this.getUI()).getCreateFishingOperationActions().setVisible(showActionPanel);
        }
    }

    private boolean blockIfNotLeavingFrequencyScreen() {
        Component selectedComponent = ((EditCatchesUI)this.getUI()).getTabPane().getSelectedComponent();
        if (selectedComponent != null) {
            EditSpeciesBatchPanelUI speciesTabPanel = ((EditCatchesUI)this.getUI()).getSpeciesTabPanel();
            EditSpeciesBatchPanelUI benthosTabPanel = ((EditCatchesUI)this.getUI()).getBenthosTabPanel();
            if (speciesTabPanel.equals(selectedComponent)) {
                if ("editFrequency".equals(speciesTabPanel.getTopPanelLayout().getSelected())) {
                    boolean canContinue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)"Species frequencies screen on, try to leave it.");
                    }
                    if (!(canContinue = speciesTabPanel.getEditFrequenciesUI().leaveIfConfirmed())) {
                        return false;
                    }
                }
            } else if (benthosTabPanel.equals(selectedComponent) && "editFrequency".equals(benthosTabPanel.getTopPanelLayout().getSelected())) {
                boolean canContinue;
                if (log.isInfoEnabled()) {
                    log.info((Object)"Benthos frequencies screen on, try to leave it.");
                }
                if (!(canContinue = benthosTabPanel.getEditFrequenciesUI().leaveIfConfirmed())) {
                    return false;
                }
            }
        }
        return true;
    }
}

