/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.home;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.Program;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUI;
import fr.ifremer.tutti.ui.swing.content.home.SelectCruiseUIModel;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import java.awt.Font;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import jaxx.runtime.swing.editor.bean.BeanFilterableComboBox;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.validator.bean.simple.SimpleBeanValidator;

public class SelectCruiseUIHandler
extends AbstractTuttiUIHandler<SelectCruiseUIModel, SelectCruiseUI> {
    private static final Log log = LogFactory.getLog(SelectCruiseUIHandler.class);

    public SwingValidator<SelectCruiseUIModel> getValidator() {
        return ((SelectCruiseUI)this.ui).getValidator();
    }

    public void beforeInit(SelectCruiseUI ui) {
        super.beforeInit((ApplicationUI)ui);
        PersistenceService persistenceService = this.getContext().getPersistenceService();
        SelectCruiseUIModel model = new SelectCruiseUIModel();
        ArrayList programs = Lists.newArrayList((Iterable)persistenceService.getAllProgram());
        model.setPrograms(programs);
        Program selectedProgram = null;
        if (programs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No program found.");
            }
        } else {
            ArrayList cruises = null;
            if (this.getContext().isProgramFilled()) {
                selectedProgram = this.getDataContext().getProgram();
                cruises = Lists.newArrayList((Iterable)persistenceService.getAllCruise(selectedProgram.getId()));
            }
            model.setProgram(selectedProgram);
            model.setCruises(cruises);
            if (!CollectionUtils.isEmpty(cruises)) {
                Cruise selectedCruise = null;
                if (this.getContext().isCruiseFilled()) {
                    selectedCruise = this.getDataContext().reloadCruise();
                }
                model.setCruise(selectedCruise);
            }
        }
        ArrayList protocols = Lists.newArrayList((Iterable)persistenceService.getAllProtocol(selectedProgram == null ? null : selectedProgram.getId()));
        model.setProtocols(protocols);
        if (protocols.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No protocol found.");
            }
        } else {
            model.setProtocol(this.getDataContext().getProtocol());
        }
        ui.setContextValue(model);
    }

    public void afterInit(SelectCruiseUI ui) {
        this.initUI(ui);
        Font font = ui.getEditCatchesButton().getFont();
        ui.getEditCatchesButton().setFont(font.deriveFont(1, 14.0f));
        ui.getValidateCatchesButton().setFont(font.deriveFont(1, 14.0f));
        SelectCruiseUIModel model = (SelectCruiseUIModel)((Object)this.getModel());
        this.initBeanFilterableComboBox(ui.getProgramCombobox(), model.getPrograms(), model.getProgram());
        this.initBeanFilterableComboBox(ui.getCruiseCombobox(), model.getCruises(), model.getCruise());
        this.initBeanFilterableComboBox(ui.getProtocolCombobox(), model.getProtocols(), model.getProtocol());
        model.addPropertyChangeListener("protocols", evt -> {
            BeanFilterableComboBox<TuttiProtocol> combobox = ((SelectCruiseUI)this.ui).getProtocolCombobox();
            List protocols = (List)evt.getNewValue();
            combobox.setData(null);
            if (protocols != null) {
                combobox.setData(protocols);
            }
            ((SelectCruiseUI)this.ui).applyDataBinding("protocolCombobox.enabled");
        });
        model.addPropertyChangeListener("program", evt -> {
            ArrayList protocols;
            ArrayList cruises;
            Program newValue = (Program)evt.getNewValue();
            boolean noProgram = newValue == null;
            this.getContext().setProgramId(noProgram ? null : newValue.getId());
            if (log.isInfoEnabled()) {
                log.info((Object)("Selected program: " + newValue));
            }
            if (noProgram) {
                cruises = Lists.newArrayList();
                protocols = Lists.newArrayList((Iterable)this.getPersistenceService().getAllProtocol(null));
            } else {
                cruises = Lists.newArrayList((Iterable)this.getPersistenceService().getAllCruise(newValue.getId()));
                protocols = Lists.newArrayList((Iterable)this.getPersistenceService().getAllProtocol(newValue.getId()));
            }
            SelectCruiseUIModel source = (SelectCruiseUIModel)((Object)((Object)evt.getSource()));
            source.setCruises(cruises);
            source.setCruise(null);
            source.setProtocols(protocols);
            source.setProtocol(null);
        });
        model.addPropertyChangeListener("cruises", evt -> {
            BeanFilterableComboBox<Cruise> combobox = ((SelectCruiseUI)this.ui).getCruiseCombobox();
            List campaigns = (List)evt.getNewValue();
            combobox.setData(null);
            if (campaigns != null) {
                combobox.setData(campaigns);
            }
        });
        model.addPropertyChangeListener("cruise", evt -> {
            Cruise newValue = (Cruise)evt.getNewValue();
            this.getContext().setCruiseId(newValue == null ? null : newValue.getIdAsInt());
        });
        model.addPropertyChangeListener("protocols", evt -> {
            BeanFilterableComboBox<TuttiProtocol> combobox = ((SelectCruiseUI)this.ui).getProtocolCombobox();
            List protocols = (List)evt.getNewValue();
            combobox.setData(null);
            if (protocols != null) {
                combobox.setData(protocols);
            }
        });
        model.addPropertyChangeListener("protocol", evt -> {
            TuttiProtocol newValue = (TuttiProtocol)evt.getNewValue();
            this.getContext().setProtocolId(newValue == null ? null : newValue.getId());
            JComboBox editProtocolComboBox = ((SelectCruiseUI)this.ui).getEditProtocolComboBox();
            editProtocolComboBox.putClientProperty("_canEdit_", false);
            try {
                if (model.isProgramFound()) {
                    if (editProtocolComboBox.getItemCount() == 2) {
                        editProtocolComboBox.removeAllItems();
                        editProtocolComboBox.addItem(((SelectCruiseUI)this.getUI()).getEditProtocolButton());
                        editProtocolComboBox.addItem(((SelectCruiseUI)this.getUI()).getCloneProtocolButton());
                        editProtocolComboBox.addItem(((SelectCruiseUI)this.getUI()).getExportProtocolButton());
                        editProtocolComboBox.addItem(((SelectCruiseUI)this.getUI()).getDeleteProtocolButton());
                    }
                } else if (editProtocolComboBox.getItemCount() == 4) {
                    editProtocolComboBox.removeItem(((SelectCruiseUI)this.getUI()).getEditProtocolButton());
                    editProtocolComboBox.removeItem(((SelectCruiseUI)this.getUI()).getCloneProtocolButton());
                }
            }
            finally {
                editProtocolComboBox.putClientProperty("_canEdit_", true);
            }
        });
        this.registerValidators(this.getValidator());
        this.listenValidatorValid((SimpleBeanValidator)this.getValidator(), model);
        this.getValidator().setBean((Object)model);
        ui.applyDataBinding("newCruiseButton.enabled");
        ui.applyDataBinding("editCatchesButton.enabled");
        ui.applyDataBinding("validateCatchesButton.enabled");
    }

    protected JComponent getComponentToFocus() {
        return ((SelectCruiseUI)this.getUI()).getEditCatchesButton();
    }

    public void onCloseUI() {
        PropertyChangeListener[] listeners;
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        for (PropertyChangeListener listener : listeners = ((SelectCruiseUIModel)((Object)this.getModel())).getPropertyChangeListeners()) {
            ((SelectCruiseUIModel)((Object)this.getModel())).removePropertyChangeListener(listener);
        }
        this.clearValidators();
    }
}

