/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.validation;

import com.google.common.base.Preconditions;
import fr.ifremer.tutti.persistence.ProgressionModel;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.ui.swing.content.cruise.EditCruiseUI;
import fr.ifremer.tutti.ui.swing.content.operation.FishingOperationsUI;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUI;
import fr.ifremer.tutti.ui.swing.content.validation.ValidateCruiseUIModel;
import fr.ifremer.tutti.ui.swing.content.validation.actions.EditCruiseInValidationUIAction;
import fr.ifremer.tutti.ui.swing.content.validation.actions.EditFishingOperationInValidationUIAction;
import fr.ifremer.tutti.ui.swing.content.validation.tree.CruiseTreeNode;
import fr.ifremer.tutti.ui.swing.content.validation.tree.OperationTreeNode;
import fr.ifremer.tutti.ui.swing.content.validation.tree.ValidationTreeCellRenderer;
import fr.ifremer.tutti.ui.swing.util.AbstractTuttiUIHandler;
import fr.ifremer.tutti.ui.swing.util.RemoveablePropertyChangeListener;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.validator.swing.SwingValidator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.decorator.Decorator;
import org.nuiton.jaxx.application.swing.ApplicationUI;
import org.nuiton.jaxx.application.swing.action.AbstractApplicationAction;
import org.nuiton.jaxx.application.swing.action.ApplicationActionUIModel;
import org.nuiton.jaxx.application.swing.util.CloseableUI;
import org.nuiton.jaxx.application.type.ApplicationProgressionModel;
import org.nuiton.validator.NuitonValidatorResult;

public class ValidateCruiseUIHandler
extends AbstractTuttiUIHandler<ValidateCruiseUIModel, ValidateCruiseUI>
implements CloseableUI {
    private static final Log log = LogFactory.getLog(ValidateCruiseUIHandler.class);
    protected EditFishingOperationInValidationUIAction editFishingOperationAction;
    protected EditCruiseInValidationUIAction editCruiseAction;

    public void beforeInit(ValidateCruiseUI ui) {
        super.beforeInit((ApplicationUI)ui);
        ValidateCruiseUIModel model = new ValidateCruiseUIModel();
        model.setCruise(this.getDataContext().getCruise());
        ProgressionModel progressionModel = new ProgressionModel();
        ApplicationActionUIModel actionUIModel = this.getContext().getActionUI().getModel();
        actionUIModel.setProgressionModel((ApplicationProgressionModel)progressionModel);
        Integer cruiseId = this.getDataContext().getCruiseId();
        List operationIds = this.getPersistenceService().getAllFishingOperationIds(cruiseId);
        progressionModel.setTotal(2 * operationIds.size() + 2);
        NuitonValidatorResult cruiseValidatorResult = this.getValidateCruiseOperationsService().validateCruise(progressionModel, cruiseId);
        model.setCruiseValidatorResult(cruiseValidatorResult);
        LinkedHashMap validator = this.getValidateCruiseOperationsService().validateOperations(progressionModel, operationIds);
        model.addFishingOperationValidatorResults(validator);
        actionUIModel.setProgressionModel(null);
        model.addPropertyChangeListener("selectedFishingOperation", new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FishingOperation operation = (FishingOperation)evt.getNewValue();
                ValidateCruiseUIHandler.this.editFishingOperationAction.setFishingOperation(operation);
                ValidateCruiseUIHandler.this.getContext().getActionEngine().runAction((AbstractApplicationAction)ValidateCruiseUIHandler.this.editFishingOperationAction);
                ((ValidateCruiseUI)ValidateCruiseUIHandler.this.getUI()).getEditPanelLayout().setSelected("fishingOperation");
            }
        });
        model.addPropertyChangeListener("selectedCruise", new RemoveablePropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                Cruise cruise = (Cruise)evt.getNewValue();
                ValidateCruiseUIHandler.this.editCruiseAction.setCruise(cruise);
                ValidateCruiseUIHandler.this.getContext().getActionEngine().runAction((AbstractApplicationAction)ValidateCruiseUIHandler.this.editCruiseAction);
                ((ValidateCruiseUI)ValidateCruiseUIHandler.this.getUI()).getEditPanelLayout().setSelected("cruise");
            }
        });
        ((ValidateCruiseUI)this.ui).setContextValue(model);
    }

    public void afterInit(ValidateCruiseUI ui) {
        this.initUI(ui);
        this.editFishingOperationAction = this.getContext().getActionFactory().createLogicAction(this, EditFishingOperationInValidationUIAction.class);
        this.editCruiseAction = this.getContext().getActionFactory().createLogicAction(this, EditCruiseInValidationUIAction.class);
        ui.getOperationPanel().getModel().setSelectedFishingOperation(null);
        ValidateCruiseUIModel uiModel = (ValidateCruiseUIModel)((Object)this.getModel());
        DefaultMutableTreeNode root = new DefaultMutableTreeNode();
        NuitonValidatorResult result = uiModel.getCruiseValidatorResult();
        CruiseTreeNode node = new CruiseTreeNode(uiModel.getCruise(), result);
        root.add(node);
        for (FishingOperation operation : uiModel.getFishingOperations()) {
            NuitonValidatorResult result2 = uiModel.getValidatorResult(operation);
            OperationTreeNode node2 = new OperationTreeNode(operation, result2);
            root.add(node2);
        }
        DefaultTreeModel model = new DefaultTreeModel(root);
        JTree navigation = ui.getNavigation();
        navigation.setModel(model);
        Decorator<Cruise> cruiseDecorator = this.getDecorator(Cruise.class, null);
        Decorator<FishingOperation> fishingOperationDecorator = this.getDecorator(FishingOperation.class, null);
        navigation.setCellRenderer(new ValidationTreeCellRenderer(cruiseDecorator, fishingOperationDecorator));
        SwingUtil.expandTree((JTree)navigation);
        SwingUtil.addExpandOnClickListener((JTree)navigation);
        FishingOperationsUI operationPanel = ui.getOperationPanel();
        operationPanel.getTopPanel().setVisible(false);
        EditCruiseUI cruisePanel = ui.getCruisePanel();
        cruisePanel.remove(cruisePanel.getTopToolBar());
        cruisePanel.getCloseButton().getParent().remove(cruisePanel.getCloseButton());
        cruisePanel.getResetButton().setIcon(cruisePanel.getCloseButton().getIcon());
        ((ValidateCruiseUIModel)((Object)this.getModel())).computeReadyToSynch();
    }

    public void onCloseUI() {
        if (log.isDebugEnabled()) {
            log.debug((Object)("closing: " + this.ui));
        }
        this.clearValidators();
    }

    public SwingValidator<ValidateCruiseUIModel> getValidator() {
        return null;
    }

    protected JComponent getComponentToFocus() {
        return null;
    }

    public void autoSelectNode(MouseEvent e, JPopupMenu popup) {
        TreePath selectionPath;
        JTree navigation = (JTree)e.getSource();
        boolean rightClick = SwingUtilities.isRightMouseButton(e);
        if (rightClick) {
            TreePath path = navigation.getPathForLocation(e.getX(), e.getY());
            if (path == null) {
                navigation.clearSelection();
            } else {
                navigation.setSelectionPath(path);
            }
            popup.show(navigation, e.getX(), e.getY());
        }
        if ((selectionPath = navigation.getSelectionPath()) != null && selectionPath.getPathCount() > 1) {
            Cruise cruise;
            FishingOperation operation;
            Object o = selectionPath.getPathComponent(1);
            if (o instanceof OperationTreeNode && !Objects.equals(operation = (FishingOperation)((OperationTreeNode)o).getUserObject(), ((ValidateCruiseUIModel)((Object)this.getModel())).getLastSelectedObject())) {
                ((ValidateCruiseUIModel)((Object)this.getModel())).setSelectedFishingOperation(operation);
            }
            if (o instanceof CruiseTreeNode && !Objects.equals(cruise = (Cruise)((CruiseTreeNode)o).getUserObject(), ((ValidateCruiseUIModel)((Object)this.getModel())).getLastSelectedObject())) {
                ((ValidateCruiseUIModel)((Object)this.getModel())).setSelectedCruise(cruise);
            }
        }
    }

    public void openNodeMenu(KeyEvent e, JPopupMenu popup) {
        JTree navigation;
        TreePath path;
        if (e.getKeyCode() == 525 && (path = (navigation = (JTree)e.getSource()).getSelectionPath()) != null) {
            Rectangle r = navigation.getPathBounds(path);
            Point p = new Point(r.x + r.width / 2, r.y + r.height);
            popup.show(navigation, p.x, p.y);
        }
    }

    public void updateCurrentOperationNode(NuitonValidatorResult validationResult) {
        JTree navigation = ((ValidateCruiseUI)this.ui).getNavigation();
        TreePath selectionPath = navigation.getSelectionPath();
        Preconditions.checkArgument((selectionPath.getPathCount() > 1 ? 1 : 0) != 0);
        OperationTreeNode node = (OperationTreeNode)selectionPath.getPathComponent(1);
        node.removeAllChildren();
        node.createChildren(validationResult);
        DefaultTreeModel treeModel = (DefaultTreeModel)navigation.getModel();
        treeModel.reload(node);
        navigation.setSelectionPath(selectionPath);
    }

    public void updateCurrentCruiseNode(NuitonValidatorResult validationResult) {
        JTree navigation = ((ValidateCruiseUI)this.ui).getNavigation();
        TreePath selectionPath = navigation.getSelectionPath();
        Preconditions.checkArgument((selectionPath.getPathCount() > 1 ? 1 : 0) != 0);
        CruiseTreeNode node = (CruiseTreeNode)selectionPath.getPathComponent(1);
        node.removeAllChildren();
        node.createChildren(validationResult);
        DefaultTreeModel treeModel = (DefaultTreeModel)navigation.getModel();
        treeModel.reload(node);
        navigation.setSelectionPath(selectionPath);
    }

    public boolean quitUI() {
        this.editFishingOperationAction.removeListener();
        this.editCruiseAction.removeListener();
        return true;
    }
}

