/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.data.oda.mongodb.impl;

import com.ibm.icu.util.ULocale;
import com.mongodb.CommandResult;
import com.mongodb.DB;
import com.mongodb.Mongo;
import com.mongodb.MongoException;
import java.util.Properties;
import org.eclipse.birt.data.oda.mongodb.impl.DataSetMetaData;
import org.eclipse.birt.data.oda.mongodb.impl.MDbQuery;
import org.eclipse.birt.data.oda.mongodb.impl.MongoDBDriver;
import org.eclipse.birt.data.oda.mongodb.nls.Messages;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;

public class MDbConnection
implements IConnection {
    private DB m_mongoDbInstance;
    private boolean m_useRequestSession = false;

    public void open(Properties connProperties) throws OdaException {
        DB dbInstance;
        if (this.isOpen()) {
            return;
        }
        this.m_mongoDbInstance = dbInstance = MDbConnection.getMongoDatabase(connProperties);
        Boolean useRequestSession = MongoDBDriver.getBooleanPropValue(connProperties, MongoDBDriver.REQUEST_SESSION_PROP);
        boolean bl = this.m_useRequestSession = useRequestSession != null ? useRequestSession : false;
        if (this.m_mongoDbInstance != null) {
            if (this.m_useRequestSession) {
                this.m_mongoDbInstance.requestStart();
            } else {
                this.m_mongoDbInstance.requestDone();
            }
        }
    }

    public static DB getMongoDatabase(Properties connProperties) throws OdaException {
        Mongo mongoInstance = MongoDBDriver.getMongoNode(connProperties);
        if (!mongoInstance.getConnector().isOpen()) {
            throw new OdaException(Messages.mDbConnection_failedToOpenConn);
        }
        String dbName = MongoDBDriver.getDatabaseName(connProperties);
        if (dbName == null || dbName.isEmpty()) {
            throw new OdaException(Messages.mDbConnection_missingValueDBName);
        }
        Boolean dbExists = MDbConnection.existsDatabase(mongoInstance, dbName, connProperties);
        if (dbExists != null && !dbExists.booleanValue()) {
            throw new OdaException(Messages.bind((String)Messages.mDbConnection_invalidDatabaseName, (Object)dbName));
        }
        DB dbInstance = mongoInstance.getDB(dbName);
        MDbConnection.authenticateDB(dbInstance, connProperties);
        return dbInstance;
    }

    public void setAppContext(Object context) throws OdaException {
    }

    public void close() throws OdaException {
        if (this.m_useRequestSession && this.m_mongoDbInstance != null) {
            this.m_mongoDbInstance.requestDone();
        }
        this.m_mongoDbInstance = null;
    }

    public boolean isOpen() throws OdaException {
        return this.m_mongoDbInstance != null;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        return new DataSetMetaData(this);
    }

    public IQuery newQuery(String dataSetType) throws OdaException {
        if (!this.isOpen()) {
            throw new OdaException(Messages.mDbConnection_noConnection);
        }
        return new MDbQuery(this);
    }

    public int getMaxQueries() throws OdaException {
        return 0;
    }

    public void commit() throws OdaException {
    }

    public void rollback() throws OdaException {
    }

    public void setLocale(ULocale locale) throws OdaException {
    }

    DB getConnectedDB() {
        return this.m_mongoDbInstance;
    }

    static void authenticateDB(DB mongoDb, Properties connProps) throws OdaException {
        if (mongoDb.isAuthenticated()) {
            return;
        }
        String username = MongoDBDriver.getUserName(connProps);
        if (username == null || username.isEmpty()) {
            return;
        }
        String passwd = MongoDBDriver.getPassword(connProps);
        char[] passwdChars = passwd != null ? passwd.toCharArray() : new char[]{};
        CommandResult result = null;
        try {
            result = mongoDb.authenticateCommand(username, passwdChars);
        }
        catch (Exception ex) {
            OdaException odaEx = null;
            if (result != null) {
                odaEx = new OdaException(result.getErrorMessage());
                odaEx.initCause((Throwable)ex);
            } else {
                odaEx = new OdaException((Throwable)ex);
            }
            MongoDBDriver.getLogger().info(Messages.bind((String)"Unable to authenticate user (${0}) in database (${1}).\n ${2}", (Object[])new Object[]{username, mongoDb, odaEx.getCause().getMessage()}));
            throw odaEx;
        }
    }

    private static Boolean existsDatabase(Mongo mongoInstance, String dbName, Properties connProps) throws OdaException {
        String username = MongoDBDriver.getUserName(connProps);
        if (username != null && !username.isEmpty()) {
            DB adminDb = mongoInstance.getDB("admin");
            try {
                MDbConnection.authenticateDB(adminDb, connProps);
            }
            catch (OdaException odaException) {
                return null;
            }
        }
        try {
            return mongoInstance.getDatabaseNames().contains(dbName);
        }
        catch (MongoException ex) {
            throw new OdaException((Throwable)ex);
        }
    }
}

