/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ichtyometer.feed;

import com.google.common.base.Preconditions;
import com.google.common.io.Closeables;
import fr.ifremer.tutti.ichtyometer.IchtyometerClient;
import fr.ifremer.tutti.ichtyometer.feed.event.FeedReaderEvent;
import fr.ifremer.tutti.ichtyometer.feed.event.FeedReaderListener;
import fr.ifremer.tutti.ichtyometer.feed.record.FeedReaderMeasureRecord;
import fr.ifremer.tutti.ichtyometer.feed.record.FeedReaderRecordFactory;
import fr.ifremer.tutti.ichtyometer.feed.record.FeedReaderRecordSupport;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import javax.microedition.io.StreamConnection;
import javax.swing.event.EventListenerList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FeedReader
implements Closeable {
    private static final Log log = LogFactory.getLog(FeedReader.class);
    protected IchtyometerClient client;
    protected ReadingRunnable readingRunnable;
    protected final EventListenerList listenerList = new EventListenerList();
    protected final FeedReaderRecordFactory recordFactory = new FeedReaderRecordFactory();

    public void start(IchtyometerClient client) throws IOException {
        Preconditions.checkNotNull((Object)client, (Object)"client can not be null");
        Preconditions.checkState((boolean)client.isOpen(), (Object)"client must be opened");
        this.client = client;
        StreamConnection connection = client.openConnection();
        DataInputStream dataInputStream = connection.openDataInputStream();
        this.readingRunnable = new ReadingRunnable(dataInputStream);
        new Thread(this.readingRunnable).start();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Ready to read remote device...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Preconditions.checkNotNull((Object)this.client, (Object)"client can not be null");
        Preconditions.checkState((boolean)this.client.isOpen(), (Object)"client must be opened");
        try {
            this.readingRunnable.stop();
        }
        finally {
            Closeables.close((Closeable)this.client, (boolean)true);
        }
    }

    public String getClientName() {
        return this.client.getName();
    }

    public void addFeedModeReaderListener(FeedReaderListener listener) {
        this.listenerList.add(FeedReaderListener.class, listener);
    }

    public void removeFeedModeReaderListener(FeedReaderListener listener) {
        this.listenerList.remove(FeedReaderListener.class, listener);
    }

    public void removeAllFeedModeReaderListeners() {
        for (FeedReaderListener listener : (FeedReaderListener[])this.listenerList.getListeners(FeedReaderListener.class)) {
            this.listenerList.remove(FeedReaderListener.class, listener);
        }
    }

    protected class ReadingRunnable
    implements Runnable {
        protected final DataInputStream dataInputStream;
        protected boolean stop;

        protected ReadingRunnable(DataInputStream dataInputStream) {
            this.dataInputStream = dataInputStream;
        }

        protected void stop() {
            this.stop = true;
        }

        @Override
        public void run() {
            if (log.isInfoEnabled()) {
                log.info((Object)("Reader thread start... " + this));
            }
            while (!this.stop) {
                try {
                    FeedReaderRecordSupport readerRecord = this.readRecord(this.dataInputStream);
                    if (this.stop || readerRecord == null || !(readerRecord instanceof FeedReaderMeasureRecord)) continue;
                    FeedReaderEvent e = new FeedReaderEvent(FeedReader.this, (FeedReaderMeasureRecord)readerRecord);
                    for (FeedReaderListener listener : (FeedReaderListener[])FeedReader.this.listenerList.getListeners(FeedReaderListener.class)) {
                        listener.recordRead(e);
                    }
                }
                catch (IOException e) {
                    if (!log.isErrorEnabled()) continue;
                    log.error((Object)"Could not read record", (Throwable)e);
                }
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Reader thread stop..." + this));
            }
        }

        protected FeedReaderRecordSupport readRecord(DataInputStream dataInputStream) throws IOException {
            String result = "";
            boolean complete = false;
            while (!complete && !this.stop) {
                while (dataInputStream.available() > 0 && !complete && !this.stop) {
                    int c = dataInputStream.read();
                    result = result + (char)c;
                    if ('#' != (char)c) continue;
                    complete = true;
                }
            }
            FeedReaderRecordSupport readerRecord = null;
            if (!this.stop) {
                if (log.isInfoEnabled()) {
                    log.info((Object)("New raw record: " + result));
                }
                readerRecord = FeedReader.this.recordFactory.newRecord(result);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("New feed record: " + readerRecord));
                }
            }
            return readerRecord;
        }
    }
}

