package fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.actions;

/*
 * #%L
 * Tutti :: UI
 * %%
 * Copyright (C) 2012 - 2014 Ifremer
 * %%
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, either version 3 of the 
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public 
 * License along with this program.  If not, see
 * <http://www.gnu.org/licenses/gpl-3.0.html>.
 * #L%
 */

import fr.ifremer.tutti.persistence.entities.data.BenthosBatch;
import fr.ifremer.tutti.persistence.entities.data.CatchBatch;
import fr.ifremer.tutti.persistence.entities.data.FishingOperation;
import fr.ifremer.tutti.service.catches.multipost.MultiPostImportService;
import fr.ifremer.tutti.type.WeightUnit;
import fr.ifremer.tutti.ui.swing.content.operation.catches.actions.ImportMultiPostActionSupport;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIHandler;
import fr.ifremer.tutti.ui.swing.content.operation.catches.benthos.BenthosBatchUIModel;

import java.io.File;
import java.util.Collection;
import java.util.Map;

import static org.nuiton.i18n.I18n.n;
import static org.nuiton.i18n.I18n.t;

/**
 * @author Kevin Morin - kmorin@codelutin.com
 * @since 2.2
 */
public class ImportMultiPostBenthosAction extends ImportMultiPostActionSupport<BenthosBatchUIModel, BenthosBatchUI, BenthosBatchUIHandler> {

    public ImportMultiPostBenthosAction(BenthosBatchUIHandler handler) {
        super(handler);
    }

    @Override
    protected String getFileExtension() {
        return "tuttiBenthos";
    }

    @Override
    protected String getFileExtensionDescription() {
        return t("tutti.common.file.tuttiBenthos");
    }

    @Override
    protected String getFileChooserTitle() {
        return t("tutti.editBenthosBatch.action.importMultiPost.sourceFile.title");
    }

    @Override
    protected String getFileChooserButton() {
        return t("tutti.editBenthosBatch.action.importMultiPost.sourceFile.button");
    }

    @Override
    protected String getSuccessMessage(File file) {
        return t("tutti.editBenthosBatch.action.importMultiPost.success", file);
    }

    @Override
    protected Map<String, Object> importBatches(MultiPostImportService multiPostImportExportService, File file, FishingOperation operation) {

        Map<String, Object> notImportedData = multiPostImportExportService.importBenthos(file, operation);
        return notImportedData;

    }

    @Override
    protected String buildNotImportedDataReportText(Map<String, Object> notImportedData) {

        WeightUnit benthosWeightUnit = getConfig().getBenthosWeightUnit();

        StringBuilder builder = new StringBuilder();

        Float totalSortedWeight = (Float) notImportedData.get(CatchBatch.PROPERTY_BENTHOS_TOTAL_SORTED_WEIGHT);
        addNotImportedWeightToReport(builder, totalSortedWeight, benthosWeightUnit, n("tutti.multiPostImportLog.totalSortedWeight"));

        Float inertWeight = (Float) notImportedData.get(CatchBatch.PROPERTY_BENTHOS_TOTAL_INERT_WEIGHT);
        addNotImportedWeightToReport(builder, inertWeight, benthosWeightUnit, n("tutti.multiPostImportLog.inertWeight"));

        Float livingNotItemizedWeight =
                (Float) notImportedData.get(CatchBatch.PROPERTY_BENTHOS_TOTAL_LIVING_NOT_ITEMIZED_WEIGHT);
        addNotImportedWeightToReport(builder, livingNotItemizedWeight, benthosWeightUnit, n("tutti.multiPostImportLog.livingNotItemizedWeight"));

        Collection<BenthosBatch> notImportedBenthosBatches =
                (Collection<BenthosBatch>) notImportedData.get(MultiPostImportService.BATCHES_KEY);

        for (BenthosBatch sb : notImportedBenthosBatches) {
            builder.append("- ").append(decorate(sb.getSpecies())).append(" / ").append(decorate(sb.getSampleCategoryValue())).append("\n");
        }
        return builder.toString();

    }

}
