/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.protocol.actions;

import com.google.common.collect.Lists;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.protocol.CaracteristicMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.OperationFieldMappingRow;
import fr.ifremer.tutti.persistence.entities.protocol.SpeciesProtocol;
import fr.ifremer.tutti.persistence.entities.protocol.TuttiProtocol;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.ui.swing.TuttiUIContext;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolCaracteristicsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolOperationFieldsRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolSpeciesRowModel;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUI;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIHandler;
import fr.ifremer.tutti.ui.swing.content.protocol.EditProtocolUIModel;
import fr.ifremer.tutti.ui.swing.util.actions.LongActionSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuiton.i18n.I18n;

public class SaveProtocolAction
extends LongActionSupport<EditProtocolUIModel, EditProtocolUI, EditProtocolUIHandler> {
    private static final Log log = LogFactory.getLog(SaveProtocolAction.class);

    public SaveProtocolAction(EditProtocolUIHandler handler) {
        super(handler, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void doAction() throws Exception {
        void var11_17;
        EditProtocolUIModel model = (EditProtocolUIModel)this.getModel();
        TuttiUIContext context = this.getContext();
        PersistenceService persistenceService = context.getPersistenceService();
        TuttiProtocol bean = (TuttiProtocol)model.toBean();
        Collection<EditProtocolCaracteristicsRowModel> protocolCaracteristicMappingRows = ((EditProtocolUI)this.getUI()).getModel().getCaracteristicMappingRows();
        ArrayList<CaracteristicMappingRow> caracteristicMappingRows = new ArrayList<CaracteristicMappingRow>();
        for (EditProtocolCaracteristicsRowModel row : protocolCaracteristicMappingRows) {
            if (!row.isValid()) continue;
            caracteristicMappingRows.add((CaracteristicMappingRow)row.toEntity());
        }
        bean.setCaracteristicMapping(caracteristicMappingRows);
        List<EditProtocolOperationFieldsRowModel> protocolOperationFieldMappingRows = ((EditProtocolUI)this.getUI()).getModel().getOperationFieldMappingRows();
        ArrayList<OperationFieldMappingRow> operationFieldMappingRows = new ArrayList<OperationFieldMappingRow>();
        for (EditProtocolOperationFieldsRowModel editProtocolOperationFieldsRowModel : protocolOperationFieldMappingRows) {
            if (!StringUtils.isNotBlank((CharSequence)editProtocolOperationFieldsRowModel.getField()) || !StringUtils.isNotBlank((CharSequence)editProtocolOperationFieldsRowModel.getImportColumn()) || !editProtocolOperationFieldsRowModel.isValid()) continue;
            operationFieldMappingRows.add((OperationFieldMappingRow)editProtocolOperationFieldsRowModel.toEntity());
        }
        bean.setOperationFieldMapping(operationFieldMappingRows);
        ArrayList speciesProtocols = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel editProtocolSpeciesRowModel : model.getSpeciesRow()) {
            if (!editProtocolSpeciesRowModel.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)editProtocolSpeciesRowModel.toBean();
            speciesProtocols.add(protocol);
        }
        bean.setSpecies(speciesProtocols);
        ArrayList arrayList = Lists.newArrayList();
        for (EditProtocolSpeciesRowModel row : model.getBenthosRow()) {
            if (!row.isValid()) continue;
            SpeciesProtocol protocol = (SpeciesProtocol)row.toBean();
            arrayList.add(protocol);
        }
        bean.setBenthos(arrayList);
        if (log.isDebugEnabled()) {
            log.debug((Object)("protocol id to save: " + bean.getId()));
        }
        if (TuttiEntities.isNew(bean)) {
            TuttiProtocol tuttiProtocol = persistenceService.createProtocol(bean);
            model.setId(tuttiProtocol.getId());
            this.sendMessage(I18n.t((String)"tutti.flash.info.protocolCreated", (Object[])new Object[]{bean.getName()}));
        } else {
            TuttiProtocol tuttiProtocol = persistenceService.saveProtocol(bean);
            this.sendMessage(I18n.t((String)"tutti.flash.info.protocolSaved", (Object[])new Object[]{bean.getName()}));
        }
        context.setProtocolId(var11_17.getId());
        model.setModify(false);
    }

    public void postSuccessAction() {
        this.getContext().getMainUI().getHandler().setBodyTitle(EditProtocolUIHandler.getTitle(true));
        ((EditProtocolUI)this.getUI()).getSaveWarningContainer().setVisible(false);
    }
}

