/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatchFrequency;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.service.TuttiDecorator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesBatchDecorator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesBatchDecoratorComparator;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortMode;
import fr.ifremer.tutti.ui.swing.content.operation.catches.SpeciesSortableRowModel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.JTableHeader;
import jaxx.runtime.SwingUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnExt;
import org.nuiton.decorator.DecoratorUtil;
import org.nuiton.decorator.JXPathDecorator;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.swing.table.AbstractApplicationTableModel;

public class SpeciesAbleBatchRowHelper {
    private static final Log log = LogFactory.getLog(SpeciesAbleBatchRowHelper.class);
    public static final String SPECIES_DECORATOR = "decorator";
    public static final String SPECIES_DECORATOR_INDEX = "decoratorIndex";

    public static <E extends SpeciesAbleBatch> int getIndexToInsert(List<E> rows, E newRow, SpeciesSortMode sortMode, SpeciesBatchDecorator decorator) {
        int result;
        int rowsSize = rows.size();
        if (sortMode == SpeciesSortMode.NONE) {
            result = rowsSize;
        } else {
            HashSet speciesSet = Sets.newHashSet();
            for (SpeciesAbleBatch row : rows) {
                speciesSet.add(row.getSpecies());
            }
            Species newSpecies = newRow.getSpecies();
            boolean speciestoAdd = speciesSet.add(newSpecies);
            int nbSpecies = speciesSet.size();
            ArrayList speciesList = Lists.newArrayList((Iterable)speciesSet);
            TuttiDecorator.TuttiDecoratorComparator comparator = decorator.getOriginalComparator();
            comparator.init((JXPathDecorator)decorator, (List)speciesList);
            Collections.sort(speciesList, comparator);
            if (sortMode == SpeciesSortMode.DESC) {
                Collections.reverse(speciesList);
            }
            int indexOf = speciesList.indexOf(newSpecies);
            if (!speciestoAdd) {
                ++indexOf;
            }
            if (indexOf == 0) {
                result = 0;
            } else if (indexOf >= nbSpecies) {
                result = rowsSize;
            } else {
                SpeciesAbleBatch row;
                Species species;
                Species beforeSpecies = speciestoAdd ? (Species)speciesList.get(indexOf + 1) : (Species)speciesList.get(indexOf);
                result = 0;
                Iterator<E> iterator = rows.iterator();
                while (iterator.hasNext() && !beforeSpecies.equals(species = (row = (SpeciesAbleBatch)iterator.next()).getSpecies())) {
                    ++result;
                }
            }
        }
        return result;
    }

    public static TuttiDecorator<Species> getSpeciesColumnDecorator(TableColumnExt tableColumn) {
        TuttiDecorator decorator = (TuttiDecorator)tableColumn.getClientProperty((Object)SPECIES_DECORATOR);
        return decorator;
    }

    public static <R extends Serializable, T extends AbstractApplicationTableModel<R>> void installSpeciesColumnComparatorPopup(JXTable table, TableColumnExt speciesColumn, SpeciesSortableRowModel optionalModel, String ... tips) {
        ButtonGroup buttonGroup = new ButtonGroup();
        SpeciesDecoratorListener speciesDecoratorListener = new SpeciesDecoratorListener(table, buttonGroup, speciesColumn, optionalModel);
        TuttiDecorator<Species> decorator = SpeciesAbleBatchRowHelper.getSpeciesColumnDecorator(speciesColumn);
        JPopupMenu popup = new JPopupMenu();
        popup.add(new JLabel(I18n.t((String)"tutti.ui.change.species.decorator", (Object[])new Object[0])));
        popup.add(new JSeparator());
        int nbContext = decorator.getNbContext();
        for (int i = 0; i < nbContext; ++i) {
            String property = decorator.getProperty(i);
            String i18nName = "tutti.property." + property;
            speciesColumn.putClientProperty((Object)i18nName, (Object)tips[i]);
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(tips[i]);
            item.putClientProperty(SPECIES_DECORATOR_INDEX, i);
            item.addActionListener(speciesDecoratorListener);
            if (i == 0) {
                item.setSelected(true);
            }
            buttonGroup.add(item);
            popup.add(item);
        }
        speciesDecoratorListener.recomputeSpeciesColumnTip();
        table.getTableHeader().addMouseListener(new ShowSpeciesDecoratorPopupListener(popup));
    }

    public static <R extends SpeciesAbleBatch> void sortSpeciesRows(SpeciesBatchDecoratorComparator comparator, SpeciesBatchDecorator decorator, List<R> rows, SpeciesSortMode speciesSortMode) {
        comparator.setSpeciesSortMode(speciesSortMode);
        comparator.init(decorator, rows);
        switch (speciesSortMode) {
            case NONE: {
                break;
            }
            case ASC: 
            case DESC: {
                DecoratorUtil.sort((JXPathDecorator)decorator, rows, (int)decorator.getContextIndex());
            }
        }
    }

    public static <F extends SpeciesAbleBatchFrequency> Float getFrequenciesTotalWeight(Collection<F> frequency) {
        if (CollectionUtils.isEmpty(frequency)) {
            return null;
        }
        float frequencyTotalWeight = 0.0f;
        for (SpeciesAbleBatchFrequency aFrequency : frequency) {
            if (aFrequency.getWeight() == null) {
                return null;
            }
            frequencyTotalWeight += aFrequency.getWeight().floatValue();
        }
        return Float.valueOf(frequencyTotalWeight);
    }

    protected static class ShowSpeciesDecoratorPopupListener
    extends MouseAdapter {
        private final JPopupMenu popup;

        public ShowSpeciesDecoratorPopupListener(JPopupMenu popup) {
            this.popup = popup;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader source = (JTableHeader)e.getSource();
            Point point = e.getPoint();
            int columnIndex = source.columnAtPoint(point);
            boolean rightClick = SwingUtilities.isRightMouseButton(e);
            if (columnIndex == 0 && rightClick) {
                e.consume();
                this.popup.show(source, e.getX(), e.getY());
            }
        }
    }

    protected static class SpeciesDecoratorListener<R extends Serializable, T extends AbstractApplicationTableModel<R>>
    implements ActionListener {
        protected final JXTable table;
        protected final ButtonGroup buttonGroup;
        protected final SpeciesSortableRowModel optionalModel;
        protected final TuttiDecorator<Species> decorator;
        protected final TableColumnExt column;

        public SpeciesDecoratorListener(JXTable table, ButtonGroup buttonGroup, TableColumnExt speciesColumn, SpeciesSortableRowModel optionalModel) {
            this.table = table;
            this.buttonGroup = buttonGroup;
            this.optionalModel = optionalModel;
            this.column = speciesColumn;
            this.decorator = SpeciesAbleBatchRowHelper.getSpeciesColumnDecorator(this.column);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JRadioButtonMenuItem source = (JRadioButtonMenuItem)e.getSource();
            this.buttonGroup.setSelected(source.getModel(), true);
            Integer index = (Integer)source.getClientProperty(SpeciesAbleBatchRowHelper.SPECIES_DECORATOR_INDEX);
            if (log.isInfoEnabled()) {
                log.info((Object)("Selected decorator context index: " + index));
            }
            this.decorator.setContextIndex(index.intValue());
            this.column.setComparator((Comparator)this.decorator.getCurrentComparator());
            this.recomputeSpeciesColumnTip();
            if (this.optionalModel != null) {
                this.optionalModel.setSpeciesDecoratorContextIndex(index);
            } else {
                AbstractApplicationTableModel tableModel = (AbstractApplicationTableModel)this.table.getModel();
                ArrayList rowsToReSelect = Lists.newArrayList();
                for (int rowIndex : SwingUtil.getSelectedModelRows((JTable)this.table)) {
                    Serializable row = tableModel.getEntry(rowIndex);
                    rowsToReSelect.add(row);
                }
                tableModel.fireTableDataChanged();
                Object object = rowsToReSelect.iterator();
                while (object.hasNext()) {
                    Serializable row = (Serializable)object.next();
                    int modelRowIndex = tableModel.getRowIndex(row);
                    SwingUtil.addRowSelectionInterval((JTable)this.table, (int)modelRowIndex);
                }
            }
        }

        public void recomputeSpeciesColumnTip() {
            ArrayList tips = Lists.newArrayList();
            int nbContext = this.decorator.getNbContext();
            for (int i = 0; i < nbContext; ++i) {
                String property = this.decorator.getProperty(i);
                String i18nName = "tutti.property." + property;
                String tip = (String)this.column.getClientProperty((Object)i18nName);
                tips.add(tip);
            }
            String tip = Joiner.on((String)" - ").join((Iterable)tips);
            this.column.setToolTipText(tip);
        }
    }
}

