/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service.referential;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonName;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonNameImpl;
import fr.ifremer.adagio.core.dao.referential.taxon.TaxonRefVO;
import fr.ifremer.adagio.core.dao.referential.transcribing.TranscribingItemType;
import fr.ifremer.adagio.core.dao.referential.transcribing.TranscribingItemTypeDao;
import fr.ifremer.adagio.core.dao.referential.transcribing.TranscribingItemTypeId;
import fr.ifremer.tutti.persistence.dao.TaxonNameDaoTutti;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.Speciess;
import fr.ifremer.tutti.persistence.service.referential.CouldNotLoadTaxonException;
import fr.ifremer.tutti.persistence.service.referential.ReferentialPersistenceServiceSupport;
import fr.ifremer.tutti.persistence.service.referential.SpeciesPersistenceService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.type.IntegerType;
import org.hibernate.type.StringType;
import org.nuiton.jaxx.application.ApplicationBusinessException;
import org.springframework.cache.Cache;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.stereotype.Service;

@Service(value="speciesPersistenceService")
public class SpeciesPersistenceServiceImpl
extends ReferentialPersistenceServiceSupport
implements SpeciesPersistenceService {
    private static final Log log = LogFactory.getLog(SpeciesPersistenceServiceImpl.class);
    public static final String TAXINOMIE_COMMUN_REFERENCE_HISTORY = "TAXINOMIE-COMMUN.REFERENCE_HISTORY";
    @Resource(name="taxonNameDaoTutti")
    protected TaxonNameDaoTutti taxonNameDao;
    @Resource(name="transcribingItemTypeDao")
    protected TranscribingItemTypeDao transcribingItemTypeDao;

    @Override
    public List<Species> getAllSpecies() {
        TaxonRefVO[] sources = this.taxonNameDao.getAllTaxonNames(true, TranscribingItemTypeId.TAXON_NAME_REFTAX_CODE.getValue());
        ArrayList result = Lists.newArrayListWithCapacity((int)sources.length);
        ArrayList referenceTaxonsOnly = Lists.newArrayList();
        Cache referentSpeciesByIdCache = this.cacheService.getCache("referentSpeciesById");
        for (TaxonRefVO source : sources) {
            Species target = this.loadSpecies(source);
            target.setRefTaxCode(StringUtils.trim((String)target.getExternalCode()));
            if (target.isReferenceTaxon()) {
                referentSpeciesByIdCache.put((Object)target.getReferenceTaxonId(), (Object)target);
                referenceTaxonsOnly.add(target);
            }
            result.add(target);
        }
        Cache allReferentSpeciesCache = this.cacheService.getCache("referentSpecies");
        allReferentSpeciesCache.put((Object)"", (Object)referenceTaxonsOnly);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Species> getAllReferentSpecies() {
        TaxonRefVO[] sources = this.taxonNameDao.getAllTaxonNames(false, TranscribingItemTypeId.TAXON_NAME_REFTAX_CODE.getValue());
        ArrayList result = Lists.newArrayListWithCapacity((int)sources.length);
        Cache referentSpeciesByIdCache = this.cacheService.getCache("referentSpeciesById");
        this.loadReferentSpecies(sources, result, referentSpeciesByIdCache);
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Species> getAllReferentSpeciesWithObsoletes() {
        TaxonRefVO[] sources = this.taxonNameDao.getAllTaxonNamesWithObsoletes(false, TranscribingItemTypeId.TAXON_NAME_REFTAX_CODE.getValue());
        ArrayList result = Lists.newArrayListWithCapacity((int)sources.length);
        this.loadReferentSpecies(sources, result, null);
        return Collections.unmodifiableList(result);
    }

    protected void loadReferentSpecies(TaxonRefVO[] sources, List<Species> result, Cache referentSpeciesByIdCache) {
        for (TaxonRefVO source : sources) {
            Species target = this.loadSpecies(source);
            target.setRefTaxCode(StringUtils.trim((String)target.getExternalCode()));
            if (referentSpeciesByIdCache != null) {
                referentSpeciesByIdCache.put((Object)target.getReferenceTaxonId(), (Object)target);
            }
            result.add(target);
        }
    }

    @Override
    public Species getSpeciesByReferenceTaxonId(Integer referenceTaxonId) {
        try {
            Species result = this.getSpeciesByReferenceTaxonId(referenceTaxonId, TranscribingItemTypeId.TAXON_NAME_REFTAX_CODE.getValue());
            if (result != null) {
                result.setRefTaxCode(result.getExternalCode());
            }
            return result;
        }
        catch (Exception e) {
            throw new CouldNotLoadTaxonException(referenceTaxonId, "Could not getSpeciesByReferenceTaxonId with referenceTaxonId: " + referenceTaxonId, e);
        }
    }

    @Override
    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer referenceTaxonId) {
        try {
            Species result = this.getSpeciesByReferenceTaxonId(referenceTaxonId, TranscribingItemTypeId.TAXON_NAME_LOCAL_NAME.getValue());
            if (result != null) {
                result.setVernacularCode(result.getExternalCode());
            }
            return result;
        }
        catch (Exception e) {
            throw new CouldNotLoadTaxonException(referenceTaxonId, "Could not getSpeciesByReferenceTaxonId with referenceTaxonId: " + referenceTaxonId, e);
        }
    }

    @Override
    public Map<Integer, Integer> getAllObsoleteReferentTaxons() {
        TranscribingItemType transcribingItemType = this.transcribingItemTypeDao.searchUniqueLabel(TAXINOMIE_COMMUN_REFERENCE_HISTORY);
        TreeMap<Integer, Integer> result = new TreeMap<Integer, Integer>();
        if (transcribingItemType == null) {
            if (log.isWarnEnabled()) {
                log.warn((Object)"Could not find transcribing item type with label: 'TAXINOMIE-COMMUN.REFERENCE_HISTORY'");
            }
        } else {
            Query query = this.createQuery("allTranscribingForAType", "transcribingTypeId", IntegerType.INSTANCE, transcribingItemType.getId());
            for (Object o : query.list()) {
                Object[] cols = (Object[])o;
                Integer referencetaxonId = (Integer)cols[0];
                String externalCode = (String)cols[1];
                result.put(Integer.valueOf(externalCode), referencetaxonId);
            }
            if (log.isInfoEnabled()) {
                log.info((Object)("Loaded allObsoleteReferentTaxons : " + result.keySet()));
            }
        }
        return result;
    }

    protected Species getSpeciesByReferenceTaxonId(Integer referenceTaxonId, Integer transcribingTypeId) {
        Species target;
        try {
            TaxonRefVO source = this.taxonNameDao.getTaxonNameReferent(referenceTaxonId, transcribingTypeId);
            target = this.loadSpecies(source);
        }
        catch (DataRetrievalFailureException drfe) {
            target = null;
        }
        return target;
    }

    @Override
    public boolean isTemporarySpeciesUsed(Integer referenceTaxonId) {
        boolean result;
        Long count = (Long)this.queryUniqueTyped("countReferenceTaxonInSortingBatch", "id", IntegerType.INSTANCE, referenceTaxonId);
        boolean bl = result = count > 0L;
        if (!result) {
            count = (Long)this.queryUniqueTyped("countReferenceTaxonInSample", "id", IntegerType.INSTANCE, referenceTaxonId);
            result = count > 0L;
        }
        return result;
    }

    @Override
    public List<Species> addTemporarySpecies(List<Species> species) {
        ArrayList result = Lists.newArrayList();
        for (Species source : species) {
            Species added = this.addTemporarySpecies(source);
            result.add(added);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Species> updateTemporarySpecies(List<Species> species) {
        ArrayList result = Lists.newArrayList();
        for (Species source : species) {
            Species updated = this.updateTemporarySpecies(source);
            result.add(updated);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public List<Species> linkTemporarySpecies(List<Species> species) {
        ArrayList result = Lists.newArrayList();
        for (Species source : species) {
            Species linked = this.linkTemporarySpecies(source);
            result.add(linked);
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public void replaceSpecies(Species source, Species target, boolean delete) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)target);
        Preconditions.checkState((boolean)Speciess.isTemporary(source));
        Preconditions.checkState((!Speciess.isTemporary(target) ? 1 : 0) != 0);
        Integer sourceId = source.getReferenceTaxonId();
        Integer targetId = target.getReferenceTaxonId();
        this.queryUpdate("replaceReferenceTaxonInSortingBatch", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        this.queryUpdate("replaceReferenceTaxonInSample", "sourceId", IntegerType.INSTANCE, sourceId, "targetId", IntegerType.INSTANCE, targetId);
        if (delete) {
            this.deleteTemporarySpecies(sourceId);
        }
    }

    @Override
    public void deleteTemporarySpecies(Collection<Integer> referenceTaxonIds) {
        for (Integer id : referenceTaxonIds) {
            this.deleteTemporarySpecies(id);
        }
    }

    @Override
    public void deleteTemporarySpecies(Integer referenceTaxonId) {
        Preconditions.checkNotNull((Object)referenceTaxonId);
        if (referenceTaxonId > 0) {
            throw new ApplicationBusinessException(String.format("Can't delete a Species with a positive id %d.", referenceTaxonId));
        }
        Species species = this.getSpeciesByReferenceTaxonId(referenceTaxonId);
        if (species == null) {
            throw new ApplicationBusinessException(String.format("Species with id %d does not exists", referenceTaxonId));
        }
        this.taxonNameDao.remove(species.getIdAsInt());
    }

    protected Species addTemporarySpecies(Species source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getName());
        Preconditions.checkArgument((source.getId() == null || Speciess.isTemporaryId(source.getIdAsInt()) ? 1 : 0) != 0);
        TaxonRefVO taxonRefVO = null;
        if (source.getReferenceTaxonId() != null) {
            taxonRefVO = this.taxonNameDao.getTaxonNameReferent(source.getReferenceTaxonId());
        }
        if (taxonRefVO == null) {
            taxonRefVO = new TaxonRefVO();
            taxonRefVO.setName(source.getName());
            taxonRefVO = this.taxonNameDao.createAsTemporary(taxonRefVO, "Added by tutti (file import).");
        } else {
            TaxonName taxonName = (TaxonName)this.load(TaxonNameImpl.class, taxonRefVO.getTaxonNameId());
            taxonName.setName(source.getName());
            taxonRefVO.setName(source.getName());
            this.taxonNameDao.update(taxonName);
        }
        Species result = this.loadSpecies(taxonRefVO);
        result.setRefTaxCode(result.getExternalCode());
        Cache cache = this.cacheService.getCache("referentSpeciesById");
        cache.put((Object)result.getIdAsInt(), (Object)result);
        return result;
    }

    protected Species updateTemporarySpecies(Species source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getName());
        Preconditions.checkNotNull((Object)source.getId());
        Preconditions.checkNotNull((Object)source.getReferenceTaxonId());
        Preconditions.checkArgument((boolean)Speciess.isTemporaryId(source.getIdAsInt()));
        TaxonRefVO taxonRefVO = this.taxonNameDao.getTaxonNameReferent(source.getReferenceTaxonId());
        TaxonName taxonName = (TaxonName)this.load(TaxonNameImpl.class, taxonRefVO.getTaxonNameId());
        taxonName.setName(source.getName());
        taxonRefVO.setName(source.getName());
        this.taxonNameDao.update(taxonName);
        Species result = this.loadSpecies(taxonRefVO);
        result.setRefTaxCode(result.getExternalCode());
        Cache cache = this.cacheService.getCache("referentSpeciesById");
        cache.put((Object)result.getIdAsInt(), (Object)result);
        return result;
    }

    protected Species linkTemporarySpecies(Species source) {
        Preconditions.checkNotNull((Object)source);
        Preconditions.checkNotNull((Object)source.getName());
        Preconditions.checkNotNull((Object)source.getId());
        Preconditions.checkArgument((boolean)Speciess.isTemporaryId(source.getIdAsInt()));
        String taxonName = "#TEMP\u00bf" + source.getName();
        Integer referenceTaxonId = (Integer)this.queryUniqueTyped("taxonNameReferenceTaxonIdByName", "taxonName", StringType.INSTANCE, taxonName);
        Species result = this.getSpeciesByReferenceTaxonId(referenceTaxonId);
        return result;
    }

    protected Species loadSpecies(TaxonRefVO source) {
        Species target = Speciess.newSpecies();
        target.setId(source.getTaxonNameId());
        target.setName(source.getName());
        target.setExternalCode(source.getExternalCode());
        target.setReferenceTaxonId(source.getReferenceTaxonId());
        target.setReferenceTaxon(source.getIsReference());
        this.setStatus(source.getStatus().getValue(), target);
        return target;
    }
}

