/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import fr.ifremer.adagio.core.dao.referential.ObjectTypeCode;
import fr.ifremer.tutti.persistence.entities.TuttiEntities;
import fr.ifremer.tutti.persistence.entities.data.Attachment;
import fr.ifremer.tutti.persistence.entities.data.Cruise;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.service.PersistenceService;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.csv.AttachmentRow;
import fr.ifremer.tutti.service.genericformat.csv.SurveyRow;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportCruiseActionSupport;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForAttachment;
import fr.ifremer.tutti.service.genericformat.producer.CsvProducerForSurvey;
import java.util.ArrayList;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ExportSurveyAction
extends ExportCruiseActionSupport {
    private final String countryId;

    public ExportSurveyAction(PersistenceService persistenceService, String countryId) {
        super(persistenceService);
        this.countryId = countryId;
    }

    @Override
    public void execute(GenericFormatExportContext exportContext, Cruise cruise) {
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.exportCruise.exportSurvey", (Object[])new Object[]{cruise.getName()}));
        List<TuttiLocation> allCountry = this.persistenceService.getAllCountry();
        TuttiLocation country = (TuttiLocation)TuttiEntities.splitById(allCountry).get(this.countryId);
        try {
            CsvProducerForSurvey producerForSurvey = exportContext.getProducerForSurvey();
            SurveyRow surveyRow = producerForSurvey.getDataToExport(cruise, country);
            producerForSurvey.write(surveyRow);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.genericFormat.export.survey.error", (Object[])new Object[0]), (Throwable)e);
        }
        if (exportContext.isExportAttachments()) {
            this.exportAttachments(exportContext, cruise);
        }
    }

    protected void exportAttachments(GenericFormatExportContext exportContext, Cruise cruise) {
        List<Attachment> attachments = this.persistenceService.getAllAttachments(ObjectTypeCode.SCIENTIFIC_CRUISE, cruise.getIdAsInt());
        CsvProducerForAttachment producerForAttachment = exportContext.getProducerForAttachment();
        ArrayList<AttachmentRow> attachmentRows = new ArrayList<AttachmentRow>();
        producerForAttachment.addAttachments(attachments, attachmentRows);
        try {
            producerForAttachment.write((List<AttachmentRow>)attachmentRows);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException(I18n.t((String)"tutti.service.genericFormat.export.attachment.error", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

