/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.service.genericformat.exportactions;

import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.service.genericformat.GenericFormatExportContext;
import fr.ifremer.tutti.service.genericformat.exportactions.ExportTechnicalActionSupport;
import fr.ifremer.tutti.service.referential.ReferentialTemporaryGearService;
import fr.ifremer.tutti.service.referential.csv.GearRow;
import fr.ifremer.tutti.service.referential.producer.CsvProducerForTemporaryGear;
import java.util.List;
import org.nuiton.i18n.I18n;
import org.nuiton.jaxx.application.ApplicationTechnicalException;

public class ExportReferentialGearAction
extends ExportTechnicalActionSupport {
    private final ReferentialTemporaryGearService referentialTemporaryGearService;

    public ExportReferentialGearAction(ReferentialTemporaryGearService referentialTemporaryGearService) {
        this.referentialTemporaryGearService = referentialTemporaryGearService;
    }

    @Override
    public void execute(GenericFormatExportContext exportContext) {
        List<Gear> temporaryGears = this.referentialTemporaryGearService.getTemporaryGears();
        exportContext.increments(I18n.t((String)"tutti.service.genericFormat.export.exportTemporaryGear", (Object[])new Object[]{temporaryGears.size()}));
        try {
            CsvProducerForTemporaryGear producerForTemporarySpecies = exportContext.getProducerForTemporaryGear();
            List<GearRow> dataToExport = producerForTemporarySpecies.getDataToExport(temporaryGears);
            producerForTemporarySpecies.write(dataToExport);
        }
        catch (Exception e) {
            throw new ApplicationTechnicalException("Could not export temporary gear", (Throwable)e);
        }
    }
}

