/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.persistence.service;

import com.google.common.base.Predicate;
import fr.ifremer.tutti.persistence.TuttiPersistenceServiceImplementor;
import fr.ifremer.tutti.persistence.entities.data.SpeciesAbleBatch;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.persistence.entities.referential.Gear;
import fr.ifremer.tutti.persistence.entities.referential.ObjectType;
import fr.ifremer.tutti.persistence.entities.referential.Person;
import fr.ifremer.tutti.persistence.entities.referential.Species;
import fr.ifremer.tutti.persistence.entities.referential.TuttiLocation;
import fr.ifremer.tutti.persistence.entities.referential.TuttiReferentialEntity;
import fr.ifremer.tutti.persistence.entities.referential.Vessel;
import java.util.Collection;
import java.util.List;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.transaction.annotation.Transactional;

@Transactional(readOnly=true)
public interface ReferentialPersistenceService
extends TuttiPersistenceServiceImplementor {
    @Cacheable(value={"programZones"})
    public List<TuttiLocation> getAllProgramZone();

    @Cacheable(value={"countries"})
    public List<TuttiLocation> getAllCountry();

    @Cacheable(value={"harbours"})
    public List<TuttiLocation> getAllHarbour();

    public List<TuttiLocation> getAllFishingOperationStrata(String var1);

    public List<TuttiLocation> getAllFishingOperationSubStrata(String var1, String var2);

    public List<TuttiLocation> getAllFishingOperationLocation(String var1, String var2, String var3);

    public List<Vessel> getAllScientificVessel();

    @Cacheable(value={"fishingVessels"})
    public List<Vessel> getAllFishingVessel();

    @Cacheable(value={"vesselByCode"}, key="#vesselCode")
    public Vessel getVessel(String var1);

    @Cacheable(value={"referentSpecies"})
    public List<Species> getAllReferentSpecies();

    @Cacheable(value={"species"})
    public List<Species> getAllSpecies();

    public TuttiLocation getLocation(String var1);

    @Cacheable(value={"referentSpeciesById"}, key="#referenceTaxonId")
    public Species getSpeciesByReferenceTaxonId(Integer var1);

    @Cacheable(value={"referentSpeciesByIdVernacular"}, key="#referenceTaxonId")
    public Species getSpeciesByReferenceTaxonIdWithVernacularCode(Integer var1);

    @Cacheable(value={"pmfms"})
    public List<Caracteristic> getAllCaracteristic();

    @Cacheable(value={"pmfmsWithProtected"})
    public List<Caracteristic> getAllCaracteristicWithProtected();

    public List<Caracteristic> getAllCaracteristicForSampleCategory();

    public List<Caracteristic> getAllNumericCaracteristic();

    @Cacheable(value={"objectTypes"})
    public List<ObjectType> getAllObjectType();

    public Caracteristic getSizeCategoryCaracteristic();

    public Caracteristic getSexCaracteristic();

    public Caracteristic getSortedUnsortedCaracteristic();

    public Caracteristic getMaturityCaracteristic();

    public Caracteristic getAgeCaracteristic();

    public Caracteristic getMarineLitterCategoryCaracteristic();

    public Caracteristic getMarineLitterSizeCategoryCaracteristic();

    public Caracteristic getVerticalOpeningCaracteristic();

    public Caracteristic getHorizontalOpeningWingsCaracteristic();

    public Caracteristic getHorizontalOpeningDoorCaracteristic();

    public Caracteristic getDeadOrAliveCaracteristic();

    public Caracteristic getPmfmIdCaracteristic();

    public Caracteristic getWeightMeasuredCaracteristic();

    public boolean isTemporary(TuttiReferentialEntity var1);

    public List<Gear> getAllScientificGear();

    public List<Gear> getAllFishingGear();

    @Cacheable(value={"persons"})
    public List<Person> getAllPerson();

    @Cacheable(value={"personById"}, key="#personId")
    public Person getPerson(Integer var1);

    public Gear getGear(Integer var1);

    @Cacheable(value={"pmfmById"}, key="#pmfmId")
    public Caracteristic getCaracteristic(Integer var1);

    public Predicate<SpeciesAbleBatch> getVracBatchPredicate();

    public boolean isVracBatch(SpeciesAbleBatch var1);

    public boolean isHorsVracBatch(SpeciesAbleBatch var1);

    @Cacheable(value={"objectTypeByCode"}, key="#objectTypeCode")
    public ObjectType getObjectType(String var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"species", "referentSpecies", "referentSpeciesById", "referentSpeciesByIdVernacular", "obsoleteReferentTaxons"}, allEntries=true)
    public List<Species> importTemporarySpecies(List<Species> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fishingVessels", "vesselByCode"}, allEntries=true)
    public List<Vessel> importTemporaryVessel(List<Vessel> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"persons", "personById"}, allEntries=true)
    public List<Person> importTemporaryPerson(List<Person> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"gears"}, allEntries=true)
    public List<Gear> importTemporaryGear(List<Gear> var1);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache", "gears"}, allEntries=true)
    public void replaceGear(Gear var1, Gear var2, boolean var3);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache", "species", "referentSpecies", "referentSpeciesById", "referentSpeciesByIdVernacular", "obsoleteReferentTaxons"}, allEntries=true)
    public void replaceSpecies(Species var1, Species var2, boolean var3);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache", "persons", "personById"}, allEntries=true)
    public void replacePerson(Person var1, Person var2, boolean var3);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fr.ifremer.adagio.core.dao.data.batch.CatchBatchCache", "fishingVessels", "vesselByCode"}, allEntries=true)
    public void replaceVessel(Vessel var1, Vessel var2, boolean var3);

    @Transactional(readOnly=false)
    @CacheEvict(value={"gears"}, allEntries=true)
    public void deleteTemporaryGear(Integer var1, boolean var2);

    @Transactional(readOnly=false)
    @CacheEvict(value={"gears"}, allEntries=true)
    public void deleteTemporaryGears(Collection<Integer> var1, boolean var2);

    @Transactional(readOnly=false)
    @CacheEvict(value={"species", "referentSpecies", "referentSpeciesById", "referentSpeciesByIdVernacular", "obsoleteReferentTaxons"}, allEntries=true)
    public void deleteTemporarySpecies(Integer var1, boolean var2);

    @Transactional(readOnly=false)
    @CacheEvict(value={"species", "referentSpecies", "referentSpeciesById", "referentSpeciesByIdVernacular", "obsoleteReferentTaxons"}, allEntries=true)
    public void deleteTemporarySpecies(Collection<Integer> var1, boolean var2);

    @Transactional(readOnly=false)
    @CacheEvict(value={"persons", "personById"}, allEntries=true)
    public void deleteTemporaryPerson(Integer var1, boolean var2);

    @Transactional(readOnly=false)
    @CacheEvict(value={"persons", "personById"}, allEntries=true)
    public void deleteTemporaryPersons(Collection<Integer> var1, boolean var2);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fishingVessels", "vesselByCode"}, allEntries=true)
    public void deleteTemporaryVessel(String var1, boolean var2);

    @Transactional(readOnly=false)
    @CacheEvict(value={"fishingVessels", "vesselByCode"}, allEntries=true)
    public void deleteTemporaryVessels(Collection<String> var1, boolean var2);

    public boolean isTemporaryPersonUsed(Integer var1);

    public boolean isTemporarySpeciesUsed(Integer var1);

    public boolean isTemporaryGearUsed(Integer var1);

    public boolean isTemporaryVesselUsed(String var1);
}

