/*
 * Decompiled with CFR 0.152.
 */
package fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.actions;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import fr.ifremer.tutti.persistence.entities.referential.Caracteristic;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyRowModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyTableModel;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUI;
import fr.ifremer.tutti.ui.swing.content.operation.catches.species.frequency.SpeciesFrequencyUIModel;
import fr.ifremer.tutti.util.Numbers;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JTable;
import jaxx.runtime.SwingUtil;
import jaxx.runtime.swing.JTables;
import org.nuiton.i18n.I18n;

public class GenerateSpeciesFrequencyLengthStepsAction
extends AbstractAction {
    private static final long serialVersionUID = 1L;
    final SpeciesFrequencyUI ui;

    public GenerateSpeciesFrequencyLengthStepsAction(SpeciesFrequencyUI ui) {
        this.ui = ui;
        this.putValue("Name", I18n.t((String)"tutti.editSpeciesFrequencies.action.generate", (Object[])new Object[0]));
        this.putValue("ShortDescription", I18n.t((String)"tutti.editSpeciesFrequencies.action.generate.tip", (Object[])new Object[0]));
        this.putValue("MnemonicKey", SwingUtil.getFirstCharAt((String)I18n.t((String)"tutti.editSpeciesFrequencies.action.generate.mnemonic", (Object[])new Object[0]), (char)'Z'));
        this.putValue("SmallIcon", SwingUtil.createActionIcon((String)"generate"));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SpeciesFrequencyUIModel model = this.ui.getModel();
        SpeciesFrequencyTableModel tableModel = this.ui.getHandler().getTableModel();
        Map<Float, SpeciesFrequencyRowModel> rowsByStep = model.getRowCache();
        Float minStep = Float.valueOf(model.getLengthStep(model.getMinStep().floatValue()));
        Float maxStep = Float.valueOf(model.getLengthStep(model.getMaxStep().floatValue()));
        Caracteristic lengthStepCaracteristic = model.getLengthStepCaracteristic();
        HashSet existingKeys = Sets.newHashSet(rowsByStep.keySet());
        ArrayList rows = Lists.newArrayList(rowsByStep.values());
        float i = minStep.floatValue();
        float step = model.getStep().floatValue();
        while (i <= maxStep.floatValue()) {
            if (!existingKeys.contains(Float.valueOf(i))) {
                SpeciesFrequencyRowModel newRow = tableModel.createNewRow();
                newRow.setLengthStep(Float.valueOf(i));
                newRow.setLengthStepCaracteristic(lengthStepCaracteristic);
                rows.add(newRow);
            }
            i = Numbers.getRoundedLengthStep(i + step, true);
        }
        Collections.sort(rows);
        model.setRows(rows);
        JTables.doSelectCell((JTable)this.ui.getTable(), (int)0, (int)1);
    }
}

