/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.script.internal;

import java.util.HashMap;
import java.util.logging.Level;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IDataScriptEngine;
import org.eclipse.birt.data.engine.script.JSMethodRunner;
import org.eclipse.birt.report.engine.api.EngineException;
import org.eclipse.birt.report.engine.api.script.IReportContext;
import org.eclipse.birt.report.engine.executor.ExecutionContext;
import org.eclipse.birt.report.engine.script.internal.ScriptExecutor;
import org.mozilla.javascript.Scriptable;

public abstract class DtEScriptExecutor
extends ScriptExecutor {
    protected static final String DATA_SET = "DataSet";
    protected static final String DATA_SOURCE = "DataSource";
    protected static final String BEFORE_OPEN = "beforeOpen";
    protected static final String BEFORE_CLOSE = "beforeClose";
    protected static final String AFTER_OPEN = "afterOpen";
    protected static final String AFTER_CLOSE = "afterClose";
    protected ExecutionContext context;
    protected Scriptable scope;
    protected IReportContext reportContext;
    private HashMap<Scriptable, JSMethodRunner> runner = new HashMap();

    public DtEScriptExecutor(ExecutionContext context) throws BirtException {
        this.context = context;
        if (context != null) {
            this.reportContext = context.getReportContext();
            this.scope = ((IDataScriptEngine)((Object)context.getScriptContext().getScriptEngine("javascript"))).getJSScope(context.getScriptContext());
        } else {
            this.reportContext = null;
        }
    }

    protected JSMethodRunner getRunner(Scriptable scope, String type, String name) {
        if (scope == null) {
            return new JSMethodRunner(this.context.getScriptContext(), scope, name);
        }
        JSMethodRunner result = this.runner.get(scope);
        if (result != null) {
            return result;
        }
        String scopeName = String.valueOf(type) + "[" + name + "]";
        result = new JSMethodRunner(this.context.getScriptContext(), scope, scopeName);
        this.runner.put(scope, result);
        return result;
    }

    protected ScriptExecutor.ScriptStatus handleJS(Scriptable scope, String type, String name, String method, String script, String id) {
        Object result;
        block4: {
            if (script == null || type == null || name == null || method == null) {
                return ScriptExecutor.ScriptStatus.NO_RUN;
            }
            if (!DATA_SET.equals(type) && !DATA_SOURCE.equals(type)) {
                return ScriptExecutor.ScriptStatus.NO_RUN;
            }
            result = null;
            try {
                JSMethodRunner jsr = this.getRunner(scope, type, name);
                result = jsr.runScript(method, script, id);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.getMessage(), e);
                if (this.context == null) break block4;
                this.context.addException(new EngineException("Error.ScriptEvaluationError", new Object[]{script, e.getMessage()}, (Throwable)e));
            }
        }
        return new ScriptExecutor.ScriptStatus(true, result);
    }

    protected abstract ScriptExecutor.ScriptStatus handleJS(Scriptable var1, String var2, String var3, String var4, String var5);
}

