/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.engine.content.impl;

import java.util.List;
import org.eclipse.birt.core.exception.BirtException;
import org.eclipse.birt.data.engine.api.IBaseExpression;
import org.eclipse.birt.data.engine.api.IBaseQueryResults;
import org.eclipse.birt.report.engine.api.DataSetID;
import org.eclipse.birt.report.engine.data.dte.CubeResultSet;
import org.eclipse.birt.report.engine.data.dte.QueryResultSet;
import org.eclipse.birt.report.engine.extension.IBaseResultSet;

public class BaseResultSetDecorator
implements IBaseResultSet {
    private List<IBaseResultSet> resultSets;
    private IBaseResultSet lastResultSet;

    public BaseResultSetDecorator(List<IBaseResultSet> resultSets) {
        assert (resultSets.size() > 0);
        this.resultSets = resultSets;
        this.lastResultSet = resultSets.get(resultSets.size() - 1);
    }

    @Override
    public void close() {
        for (IBaseResultSet resultSet : this.resultSets) {
            resultSet.close();
        }
    }

    @Override
    public Object evaluate(String expr) throws BirtException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object evaluate(String language, String expr) throws BirtException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object evaluate(IBaseExpression expr) throws BirtException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataSetID getID() {
        return this.lastResultSet.getID();
    }

    @Override
    public IBaseResultSet getParent() {
        return this.lastResultSet.getParent();
    }

    @Override
    public IBaseQueryResults getQueryResults() {
        return this.lastResultSet.getQueryResults();
    }

    @Override
    public String getRawID() throws BirtException {
        return this.lastResultSet.getRawID();
    }

    @Override
    public int getType() {
        return this.lastResultSet.getType();
    }

    public String getResultSetId() {
        if (this.lastResultSet instanceof QueryResultSet) {
            QueryResultSet queryResultSet = (QueryResultSet)this.lastResultSet;
            return queryResultSet.getQueryResultsID();
        }
        CubeResultSet cubeResultSet = (CubeResultSet)this.lastResultSet;
        return cubeResultSet.getQueryResultsID();
    }
}

